/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.commons_cli.modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Singleton;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.name.Names;
import com.netflix.governator.annotations.binding.Main;
import com.netflix.governator.commons_cli.providers.StringOptionProvider;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OptionsModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(OptionsModule.class);
    private List<OptionBuilder> builders = Lists.newArrayList();
    private boolean parserIsBound = false;

    protected final void configure() {
        this.configureOptions();
        Options options = new Options();
        for (OptionBuilder builder : this.builders) {
            Option option = builder.create();
            if (builder.annot != null) {
                this.bind(String.class).annotatedWith(builder.annot).toProvider((Provider)new StringOptionProvider(option, builder.defaultValue)).asEagerSingleton();
                LOG.info("Binding option to annotation : " + builder.annot.getName());
            } else {
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)option.getOpt())).toProvider((Provider)new StringOptionProvider(option, builder.defaultValue)).asEagerSingleton();
                LOG.info("Binding option to String : " + option.getOpt());
            }
            options.addOption(option);
        }
        this.bind(Options.class).toInstance((Object)options);
        this.bind(CommandLine.class).toProvider(CommandLineProvider.class);
        if (!this.parserIsBound) {
            this.bindParser().to(BasicParser.class);
        }
    }

    protected abstract void configureOptions();

    protected OptionBuilder option(char shortopt) {
        OptionBuilder builder = new OptionBuilder().withShortOpt(shortopt);
        this.builders.add(builder);
        return builder;
    }

    protected AnnotatedBindingBuilder<Parser> bindParser() {
        this.parserIsBound = true;
        return this.bind(Parser.class);
    }

    @Singleton
    public static class CommandLineProvider
    implements Provider<CommandLine> {
        private final Options options;
        private final String[] arguments;
        private final Parser parser;

        @Inject
        public CommandLineProvider(Options options, @Main String[] arguments, Parser parser) {
            this.options = options;
            this.arguments = arguments;
            this.parser = parser;
        }

        public CommandLine get() {
            try {
                return this.parser.parse(this.options, this.arguments);
            }
            catch (ParseException e) {
                throw new ProvisionException("Error parsing command line arguments", (Throwable)e);
            }
        }
    }

    protected class OptionBuilder {
        private String longopt;
        private String description;
        private String argName;
        private boolean required;
        private int numberOfArgs = -1;
        private Object type;
        private boolean optionalArg;
        private char valuesep;
        private String shortopt;
        private String defaultValue;
        private Class<? extends Annotation> annot;

        protected OptionBuilder() {
        }

        public OptionBuilder annotatedWith(Class<? extends Annotation> annot) {
            this.annot = annot;
            return this;
        }

        public OptionBuilder withLongOpt(String longopt) {
            this.longopt = longopt;
            return this;
        }

        public OptionBuilder withShortOpt(char shortopt) {
            this.shortopt = Character.toString(shortopt);
            return this;
        }

        public OptionBuilder hasArg() {
            this.numberOfArgs = 1;
            return this;
        }

        public OptionBuilder hasArg(boolean hasArg) {
            this.numberOfArgs = hasArg ? 1 : -1;
            return this;
        }

        public OptionBuilder withArgName(String name) {
            this.argName = name;
            return this;
        }

        public OptionBuilder isRequired() {
            this.required = true;
            return this;
        }

        public OptionBuilder withValueSeparator(char sep) {
            this.valuesep = sep;
            return this;
        }

        public OptionBuilder withValueSeparator() {
            this.valuesep = (char)61;
            return this;
        }

        public OptionBuilder isRequired(boolean newRequired) {
            this.required = newRequired;
            return this;
        }

        public OptionBuilder hasArgs() {
            this.numberOfArgs = -2;
            return this;
        }

        public OptionBuilder hasArgs(int num) {
            this.numberOfArgs = num;
            return this;
        }

        public OptionBuilder hasOptionalArg() {
            this.numberOfArgs = 1;
            this.optionalArg = true;
            return this;
        }

        public OptionBuilder hasOptionalArgs() {
            this.numberOfArgs = -2;
            this.optionalArg = true;
            return this;
        }

        public OptionBuilder hasOptionalArgs(int numArgs) {
            this.numberOfArgs = numArgs;
            this.optionalArg = true;
            return this;
        }

        public OptionBuilder withType(Object newType) {
            this.type = newType;
            return this;
        }

        public OptionBuilder withDescription(String newDescription) {
            this.description = newDescription;
            return this;
        }

        public OptionBuilder withDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        Option create() throws IllegalArgumentException {
            Preconditions.checkNotNull((Object)this.shortopt);
            Option option = null;
            option = new Option(this.shortopt, this.description);
            option.setLongOpt(this.longopt);
            option.setRequired(this.required);
            option.setOptionalArg(this.optionalArg);
            option.setArgs(this.numberOfArgs);
            option.setType(this.type);
            option.setValueSeparator(this.valuesep);
            option.setArgName(this.argName);
            return option;
        }
    }
}

