/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache;

import brave.Span;
import brave.Tracer;
import com.netflix.evcache.EVCacheException;
import com.netflix.evcache.EVCacheKey;
import com.netflix.evcache.EVCacheTracingTags;
import com.netflix.evcache.event.EVCacheEvent;
import com.netflix.evcache.event.EVCacheEventListener;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.spy.memcached.CachedData;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheTracingEventListener
implements EVCacheEventListener {
    public static String EVCACHE_SPAN_NAME = "evcache";
    private static Logger logger = LoggerFactory.getLogger(EVCacheTracingEventListener.class);
    private static String CLIENT_SPAN_ATTRIBUTE_KEY = "clientSpanAttributeKey";
    private final Tracer tracer;

    public EVCacheTracingEventListener(EVCacheClientPoolManager poolManager, Tracer tracer) {
        poolManager.addEVCacheEventListener((EVCacheEventListener)this);
        this.tracer = tracer;
    }

    public void onStart(EVCacheEvent e) {
        try {
            Span clientSpan = this.tracer.nextSpan().kind(Span.Kind.CLIENT).name(EVCACHE_SPAN_NAME).start(e.getStartTime());
            if (clientSpan.isNoop()) {
                return;
            }
            String appName = e.getAppName();
            this.safeTag(clientSpan, EVCacheTracingTags.APP_NAME, appName);
            String cacheNamePrefix = e.getCacheName();
            this.safeTag(clientSpan, EVCacheTracingTags.CACHE_NAME_PREFIX, cacheNamePrefix);
            String call = e.getCall().name();
            this.safeTag(clientSpan, EVCacheTracingTags.CALL, call);
            ArrayList<String> serverGroups = new ArrayList<String>();
            for (EVCacheClient client : e.getClients()) {
                String serverGroup = client.getServerGroupName();
                if (!StringUtils.isNotBlank((CharSequence)serverGroup)) continue;
                serverGroups.add("\"" + serverGroup + "\"");
            }
            clientSpan.tag(EVCacheTracingTags.SERVER_GROUPS, serverGroups.stream().collect(Collectors.joining(",", "[", "]")));
            ArrayList<String> hashKeys = new ArrayList<String>();
            ArrayList<String> canonicalKeys = new ArrayList<String>();
            for (EVCacheKey keyObj : e.getEVCacheKeys()) {
                String hashKey = keyObj.getHashKey();
                if (StringUtils.isNotBlank((CharSequence)hashKey)) {
                    hashKeys.add("\"" + hashKey + "\"");
                    continue;
                }
                canonicalKeys.add("\"" + keyObj.getCanonicalKey() + "\"");
            }
            if (hashKeys.size() > 0) {
                this.safeTag(clientSpan, EVCacheTracingTags.HASH_KEYS, hashKeys.stream().collect(Collectors.joining(",", "[", "]")));
            }
            if (canonicalKeys.size() > 0) {
                this.safeTag(clientSpan, EVCacheTracingTags.CANONICAL_KEYS, canonicalKeys.stream().collect(Collectors.joining(",", "[", "]")));
            }
            e.setAttribute((Object)CLIENT_SPAN_ATTRIBUTE_KEY, (Object)clientSpan);
        }
        catch (Exception exception) {
            logger.error("onStart exception", (Throwable)exception);
        }
    }

    public void onComplete(EVCacheEvent e) {
        try {
            this.onFinishHelper(e, null);
        }
        catch (Exception exception) {
            logger.error("onComplete exception", (Throwable)exception);
        }
    }

    public void onError(EVCacheEvent e, Throwable t) {
        try {
            this.onFinishHelper(e, t);
        }
        catch (Exception exception) {
            logger.error("onError exception", (Throwable)exception);
        }
    }

    public boolean onThrottle(EVCacheEvent e) throws EVCacheException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFinishHelper(EVCacheEvent e, Throwable t) {
        Object clientSpanObj = e.getAttribute((Object)CLIENT_SPAN_ATTRIBUTE_KEY);
        if (clientSpanObj == null) {
            return;
        }
        Span clientSpan = (Span)clientSpanObj;
        try {
            if (t != null) {
                this.safeTag(clientSpan, EVCacheTracingTags.ERROR, t.toString());
            }
            String status = e.getStatus();
            this.safeTag(clientSpan, EVCacheTracingTags.STATUS, status);
            long latency = e.getDurationInMillis();
            clientSpan.tag(EVCacheTracingTags.LATENCY, String.valueOf(latency));
            int ttl = e.getTTL();
            clientSpan.tag(EVCacheTracingTags.DATA_TTL, String.valueOf(ttl));
            CachedData cachedData = e.getCachedData();
            if (cachedData != null) {
                int cachedDataSize = cachedData.getData().length;
                clientSpan.tag(EVCacheTracingTags.DATA_SIZE, String.valueOf(cachedDataSize));
            }
        }
        finally {
            clientSpan.finish();
        }
    }

    private void safeTag(Span span, String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            span.tag(key, value);
        }
    }
}

