/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.shared.Application;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheKetamaNodeLocatorConfiguration;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import net.spy.memcached.MemcachedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DIEVCacheKetamaNodeLocatorConfiguration
extends EVCacheKetamaNodeLocatorConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DIEVCacheKetamaNodeLocatorConfiguration.class);
    private final EurekaClient eurekaClient;

    public DIEVCacheKetamaNodeLocatorConfiguration(EVCacheClient client, EurekaClient eurekaClient) {
        super(client);
        this.eurekaClient = eurekaClient;
    }

    public String getKeyForNode(MemcachedNode node, int repetition) {
        String result = (String)this.socketAddresses.get(node);
        if (result == null) {
            SocketAddress socketAddress = node.getSocketAddress();
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress isa = (InetSocketAddress)socketAddress;
                if (this.eurekaClient != null) {
                    Application app = this.eurekaClient.getApplication(this.client.getAppName());
                    if (app != null) {
                        List instances = app.getInstances();
                        for (InstanceInfo info : instances) {
                            String hostName = info.getHostName();
                            if (!hostName.equalsIgnoreCase(isa.getHostName())) continue;
                            String ip = info.getIPAddr();
                            result = hostName + '/' + ip + ":11211";
                            break;
                        }
                    } else {
                        result = ((InetSocketAddress)socketAddress).getHostName() + '/' + ((InetSocketAddress)socketAddress).getAddress().getHostAddress() + ":11211";
                    }
                } else {
                    result = isa.getHostName() + '/' + isa.getAddress().getHostAddress() + ":11211";
                }
            } else {
                result = String.valueOf(socketAddress);
                if (result.startsWith("/")) {
                    result = result.substring(1);
                }
            }
            this.socketAddresses.put(node, result);
        }
        if (log.isDebugEnabled()) {
            log.debug("Returning : " + result + "-" + repetition);
        }
        return result + "-" + repetition;
    }

    public String toString() {
        return "DIEVCacheKetamaNodeLocatorConfiguration [" + super.toString() + ", EurekaClient=" + this.eurekaClient + "]";
    }
}

