/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.shared.Application;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheKetamaNodeLocatorConfiguration;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import net.spy.memcached.MemcachedNode;

public class DIEVCacheKetamaNodeLocatorConfiguration
extends EVCacheKetamaNodeLocatorConfiguration {
    private final DiscoveryClient discoveryClient;

    public DIEVCacheKetamaNodeLocatorConfiguration(EVCacheClient client, DiscoveryClient discoveryClient) {
        super(client);
        this.discoveryClient = discoveryClient;
    }

    public String getKeyForNode(MemcachedNode node, int repetition) {
        String result = (String)this.socketAddresses.get(node);
        if (result == null) {
            SocketAddress socketAddress = node.getSocketAddress();
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress isa = (InetSocketAddress)socketAddress;
                if (this.discoveryClient != null) {
                    Application app = this.discoveryClient.getApplication(this.client.getAppName());
                    if (app != null) {
                        List instances = app.getInstances();
                        for (InstanceInfo info : instances) {
                            String hostName = info.getHostName();
                            if (!hostName.equalsIgnoreCase(isa.getHostName())) continue;
                            String ip = info.getIPAddr();
                            result = hostName + '/' + ip + ":11211";
                            break;
                        }
                    } else {
                        result = ((InetSocketAddress)socketAddress).getHostName() + '/' + ((InetSocketAddress)socketAddress).getAddress().getHostAddress() + ":11211";
                    }
                } else {
                    result = isa.getHostName() + '/' + isa.getAddress().getHostAddress() + ":11211";
                }
            } else {
                result = String.valueOf(socketAddress);
                if (result.startsWith("/")) {
                    result = result.substring(1);
                }
            }
            this.socketAddresses.put(node, result);
        }
        return result;
    }

    public String toString() {
        return "DIEVCacheKetamaNodeLocatorConfiguration [" + super.toString() + ", DiscoveryClient=" + this.discoveryClient + "]";
    }
}

