/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.netflix.archaius.api.annotations.ConfigurationSource;
import com.netflix.evcache.connection.DIConnectionModule;
import com.netflix.evcache.connection.IConnectionBuilder;
import com.netflix.evcache.event.hotkey.HotKeyListener;
import com.netflix.evcache.event.throttle.ThrottleListener;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import com.netflix.evcache.pool.EVCacheNodeList;
import com.netflix.evcache.pool.eureka.DIEVCacheNodeListProvider;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

@Singleton
public class EVCacheModule
extends AbstractModule {
    @Inject
    EVCacheClientPoolManager manager;

    protected void configure() {
        this.bind(EVCacheModuleConfigLoader.class).asEagerSingleton();
        this.bind(EVCacheNodeList.class).toProvider(DIEVCacheNodeListProvider.class);
        this.bind(EVCacheClientPoolManager.class).asEagerSingleton();
        this.bind(HotKeyListener.class).asEagerSingleton();
        this.bind(ThrottleListener.class).asEagerSingleton();
    }

    @PostConstruct
    public void init() {
        if (this.manager != null) {
            this.manager.initAtStartup();
        } else {
            EVCacheClientPoolManager.getInstance().initAtStartup();
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.manager != null) {
            this.manager.shutdown();
        } else {
            EVCacheClientPoolManager.getInstance().shutdown();
        }
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == ((Object)((Object)this)).getClass();
    }

    @Singleton
    @ConfigurationSource(value={"evcache"})
    public static class EVCacheModuleConfigLoader {
        @Inject
        public EVCacheModuleConfigLoader(Injector injector, EVCacheModule module) {
            if (injector.getExistingBinding(Key.get(IConnectionBuilder.class)) == null) {
                module.install((Module)new DIConnectionModule());
            }
        }
    }
}

