/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.event;

import com.netflix.evcache.EVCache;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheClientPool;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.spy.memcached.CachedData;

public class EVCacheEvent {
    public static final String CLIENTS = "clients";
    private final EVCache.Call call;
    private final String appName;
    private final String cacheName;
    private final EVCacheClientPool pool;
    private Collection<EVCacheClient> clients = null;
    private Collection<String> keys = null;
    private Collection<String> canonicalKeys = null;
    private int ttl = 0;
    private CachedData cachedData = null;
    private Map<Object, Object> data;

    public EVCacheEvent(EVCache.Call call, String appName, String cacheName, EVCacheClientPool pool) {
        this.call = call;
        this.appName = appName;
        this.cacheName = cacheName;
        this.pool = pool;
    }

    public EVCache.Call getCall() {
        return this.call;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public EVCacheClientPool getEVCacheClientPool() {
        return this.pool;
    }

    public Collection<String> getKeys() {
        return this.keys;
    }

    public void setKeys(Collection<String> keys) {
        this.keys = keys;
    }

    public Collection<String> getCanonicalKeys() {
        return this.canonicalKeys;
    }

    public void setCanonicalKeys(Collection<String> canonicalKeys) {
        this.canonicalKeys = canonicalKeys;
    }

    public int getTTL() {
        return this.ttl;
    }

    public void setTTL(int ttl) {
        this.ttl = ttl;
    }

    public CachedData getCachedData() {
        return this.cachedData;
    }

    public void setCachedData(CachedData cachedData) {
        this.cachedData = cachedData;
    }

    public Collection<EVCacheClient> getClients() {
        return this.clients;
    }

    public void setClients(Collection<EVCacheClient> clients) {
        this.clients = clients;
    }

    public void setAttribute(Object key, Object value) {
        if (this.data == null) {
            this.data = new HashMap<Object, Object>();
        }
        this.data.put(key, value);
    }

    public Object getAttribute(Object key) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(key);
    }

    public int hashCode() {
        return this.canonicalKeys.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EVCacheEvent other = (EVCacheEvent)obj;
        if (this.appName == null ? other.appName != null : !this.appName.equals(other.appName)) {
            return false;
        }
        if (this.cacheName == null ? other.cacheName != null : !this.cacheName.equals(other.cacheName)) {
            return false;
        }
        if (this.call != other.call) {
            return false;
        }
        return !(this.canonicalKeys == null ? other.canonicalKeys != null : !this.canonicalKeys.equals(other.canonicalKeys));
    }

    public String toString() {
        return "EVCacheEvent [call=" + (Object)((Object)this.call) + ", appName=" + this.appName + ", cacheName=" + this.cacheName + ", clients=" + this.clients + ", keys=" + this.keys + ", canonicalKeys=" + this.canonicalKeys + ", ttl=" + this.ttl + ", cachedData=" + this.cachedData + ", data=" + this.data + "]";
    }
}

