/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.metrics;

import com.netflix.evcache.EVCache;
import com.netflix.evcache.metrics.Operation;
import com.netflix.evcache.metrics.Stats;

public class EVCacheOperation
implements Operation {
    private final EVCache.Call op;
    private final Stats stats;
    private long startTime;
    private final String name;
    private long duration;
    private final Operation.TYPE type;

    public EVCacheOperation(String name) {
        this.op = null;
        this.name = name;
        this.stats = null;
        this.type = Operation.TYPE.MILLI;
    }

    public EVCacheOperation(String name, EVCache.Call op, Stats stats, Operation.TYPE type) {
        this.op = op;
        this.stats = stats;
        this.startTime = System.nanoTime();
        this.type = type;
        this.name = op == null ? name : name + ":" + op.name();
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public void start() {
        this.startTime = System.nanoTime();
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void stop() {
        this.duration = System.nanoTime() - this.startTime;
        if (this.op != null && this.stats != null) {
            this.stats.operationCompleted(this.op, this.getDuration());
        }
    }

    @Override
    public long getDuration() {
        if (this.type == Operation.TYPE.MILLI) {
            return this.duration / 1000000L;
        }
        if (this.type == Operation.TYPE.MICRO) {
            return this.duration / 1000L;
        }
        return this.duration;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

