/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.netflix.config.DynamicIntProperty;
import com.netflix.evcache.util.EVCacheConfig;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.StepCounter;
import com.netflix.servo.tag.Tag;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheInMemoryCache<T> {
    private static final Logger log = LoggerFactory.getLogger(EVCacheInMemoryCache.class);
    private final DynamicIntProperty _cacheDuration;
    private final DynamicIntProperty _cacheSize;
    private final String appName;
    private Cache<String, T> cache;

    public EVCacheInMemoryCache(String appName) {
        this.appName = appName;
        this._cacheDuration = EVCacheConfig.getInstance().getDynamicIntProperty(appName + ".inmemory.cache.duration.ms", 20);
        this._cacheDuration.addCallback(new Runnable(){

            @Override
            public void run() {
                EVCacheInMemoryCache.this.setupCache();
            }
        });
        this._cacheSize = EVCacheConfig.getInstance().getDynamicIntProperty(appName + ".inmemory.cache.size", 100);
        this._cacheSize.addCallback(new Runnable(){

            @Override
            public void run() {
                EVCacheInMemoryCache.this.setupCache();
            }
        });
        this.setupCache();
    }

    private void register(Monitor<?> monitor) {
        MonitorRegistry registry = DefaultMonitorRegistry.getInstance();
        if (registry.isRegistered(monitor)) {
            registry.unregister(monitor);
        }
        registry.register(monitor);
    }

    private MonitorConfig getMonitorConfig(String appName, String metric, Tag tag) {
        MonitorConfig.Builder builder = MonitorConfig.builder((String)("EVCacheInMemoryCache-" + appName + "-" + metric)).withTag(tag);
        return builder.build();
    }

    private void setupCache() {
        try {
            Cache<String, T> currentCache = this.cache;
            this.cache = CacheBuilder.newBuilder().maximumSize((long)this._cacheSize.get()).expireAfterWrite((long)this._cacheDuration.get(), TimeUnit.MILLISECONDS).recordStats().build();
            this.setupMonitoring(this.appName);
            currentCache.invalidateAll();
            currentCache.cleanUp();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void setupMonitoring(final String appName) {
        StepCounter sizeCounter = new StepCounter(this.getMonitorConfig(appName, "size", (Tag)DataSourceType.GAUGE)){

            public Number getValue() {
                if (EVCacheInMemoryCache.this.cache == null) {
                    return 0L;
                }
                return EVCacheInMemoryCache.this.cache.size();
            }

            public Number getValue(int pollerIndex) {
                return this.getValue();
            }
        };
        this.register((Monitor<?>)sizeCounter);
        this.register(new Monitor<Number>(){
            final MonitorConfig config;
            {
                this.config = EVCacheInMemoryCache.this.getMonitorConfig(appName, "requests", (Tag)DataSourceType.COUNTER);
            }

            public Number getValue() {
                if (EVCacheInMemoryCache.this.cache == null) {
                    return 0L;
                }
                return EVCacheInMemoryCache.this.cache.stats().requestCount();
            }

            public Number getValue(int pollerIndex) {
                return this.getValue();
            }

            public MonitorConfig getConfig() {
                return this.config;
            }
        });
        StepCounter hitrateCounter = new StepCounter(this.getMonitorConfig(appName, "hitrate", (Tag)DataSourceType.GAUGE)){

            public Number getValue() {
                if (EVCacheInMemoryCache.this.cache == null) {
                    return 0L;
                }
                return EVCacheInMemoryCache.this.cache.stats().hitRate();
            }

            public Number getValue(int pollerIndex) {
                return this.getValue();
            }
        };
        this.register((Monitor<?>)hitrateCounter);
        this.register(new Monitor<Number>(){
            final MonitorConfig config;
            {
                this.config = EVCacheInMemoryCache.this.getMonitorConfig(appName, "hits", (Tag)DataSourceType.COUNTER);
            }

            public Number getValue() {
                if (EVCacheInMemoryCache.this.cache == null) {
                    return 0L;
                }
                return (double)EVCacheInMemoryCache.this.cache.stats().hitCount();
            }

            public Number getValue(int pollerIndex) {
                return this.getValue();
            }

            public MonitorConfig getConfig() {
                return this.config;
            }
        });
        this.register(new Monitor<Number>(){
            final MonitorConfig config;
            {
                this.config = EVCacheInMemoryCache.this.getMonitorConfig(appName, "miss", (Tag)DataSourceType.COUNTER);
            }

            public Number getValue() {
                if (EVCacheInMemoryCache.this.cache == null) {
                    return 0L;
                }
                return (double)EVCacheInMemoryCache.this.cache.stats().missCount();
            }

            public Number getValue(int pollerIndex) {
                return this.getValue();
            }

            public MonitorConfig getConfig() {
                return this.config;
            }
        });
        this.register(new Monitor<Number>(){
            final MonitorConfig config;
            {
                this.config = EVCacheInMemoryCache.this.getMonitorConfig(appName, "evictions", (Tag)DataSourceType.COUNTER);
            }

            public Number getValue() {
                if (EVCacheInMemoryCache.this.cache == null) {
                    return 0L;
                }
                return (double)EVCacheInMemoryCache.this.cache.stats().evictionCount();
            }

            public Number getValue(int pollerIndex) {
                return this.getValue();
            }

            public MonitorConfig getConfig() {
                return this.config;
            }
        });
    }

    public T get(String key) {
        if (this.cache == null) {
            return null;
        }
        Object val = this.cache.getIfPresent((Object)key);
        if (log.isDebugEnabled()) {
            log.debug("GET : appName : " + this.appName + "; Key : " + key + "; val : " + val);
        }
        return (T)val;
    }

    public void put(String key, T value) {
        if (this.cache == null) {
            return;
        }
        this.cache.put((Object)key, value);
        if (log.isDebugEnabled()) {
            log.debug("PUT : appName : " + this.appName + "; Key : " + key + "; val : " + value);
        }
    }

    public void delete(String key) {
        if (this.cache == null) {
            return;
        }
        this.cache.invalidate((Object)key);
        if (log.isDebugEnabled()) {
            log.debug("DEL : appName : " + this.appName + "; Key : " + key);
        }
    }
}

