/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.event;

import com.netflix.evcache.EVCache;
import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.pool.EVCacheClient;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.spy.memcached.CachedData;

public class EVCacheEvent {
    public static final String CLIENTS = "clients";
    private final EVCache.Call call;
    private final String appName;
    private final String cacheName;
    private Collection<EVCacheClient> clients = null;
    private Collection<String> keys = null;
    private Collection<String> canonicalKeys = null;
    private int ttl = 0;
    private EVCacheLatch latch = null;
    private CachedData cachedData = null;
    private Map<Object, Object> data;

    public EVCacheEvent(EVCache.Call call, String appName, String cacheName) {
        this.call = call;
        this.appName = appName;
        this.cacheName = cacheName;
    }

    public EVCache.Call getCall() {
        return this.call;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public Collection<String> getKeys() {
        return this.keys;
    }

    public void setKeys(Collection<String> keys) {
        this.keys = keys;
    }

    public Collection<String> getCanonicalKeys() {
        return this.canonicalKeys;
    }

    public void setCanonicalKeys(Collection<String> canonicalKeys) {
        this.canonicalKeys = canonicalKeys;
    }

    public int getTTL() {
        return this.ttl;
    }

    public void setTTL(int ttl) {
        this.ttl = ttl;
    }

    public EVCacheLatch getLatch() {
        return this.latch;
    }

    public void setLatch(EVCacheLatch latch) {
        this.latch = latch;
    }

    public CachedData getCachedData() {
        return this.cachedData;
    }

    public void setCachedData(CachedData cachedData) {
        this.cachedData = cachedData;
    }

    public Collection<EVCacheClient> getClients() {
        return this.clients;
    }

    public void setClients(Collection<EVCacheClient> clients) {
        this.clients = clients;
    }

    public void setAttribute(Object key, Object value) {
        if (this.data == null) {
            this.data = new HashMap<Object, Object>();
        }
        this.data.put(key, value);
    }

    public Object getAttribute(Object key) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(key);
    }

    public String toString() {
        return "EVCacheEvent [call=" + (Object)((Object)this.call) + ", appName=" + this.appName + ", cacheName=" + this.cacheName + ", clients=" + this.clients + ", keys=" + this.keys + ", canonicalKeys=" + this.canonicalKeys + ", ttl=" + this.ttl + ", latch=" + this.latch + ", cachedData=" + this.cachedData + ", data=" + this.data + "]";
    }
}

