/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.version;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import com.netflix.servo.monitor.LongGauge;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.TagList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class VersionTracker
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(VersionTracker.class);
    private LongGauge versionGauge;
    private EVCacheClientPoolManager poolManager;

    @Inject
    public VersionTracker(EVCacheClientPoolManager poolManager) {
        this.poolManager = poolManager;
        poolManager.getEVCacheScheduledExecutor().schedule(this, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        if (this.versionGauge == null) {
            String fullVersion = this.getClass().getPackage().getImplementationVersion() != null ? this.getClass().getPackage().getImplementationVersion() : "unknown";
            String jarName = this.getClass().getPackage().getImplementationVersion() != null ? this.getClass().getPackage().getImplementationTitle() : "unknown";
            if (log.isErrorEnabled()) {
                log.error("fullVersion : " + fullVersion + "; jarName : " + jarName);
            }
            this.versionGauge = EVCacheMetricsFactory.getLongGauge("evcache-client", (TagList)BasicTagList.of((String[])new String[]{"version", fullVersion, "jarName", jarName}));
        }
        this.versionGauge.set(Long.valueOf(1L));
        this.poolManager.getEVCacheScheduledExecutor().schedule(this, 30L, TimeUnit.SECONDS);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

