/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import com.netflix.config.ChainedDynamicProperty;
import com.netflix.config.DynamicLongProperty;
import com.netflix.evcache.EVCacheGetOperationListener;
import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.operation.EVCacheBulkGetFuture;
import com.netflix.evcache.operation.EVCacheLatchImpl;
import com.netflix.evcache.operation.EVCacheOperationFuture;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.ServerGroup;
import com.netflix.evcache.util.EVCacheConfig;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.TagList;
import com.netflix.spectator.api.DistributionSummary;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.CASValue;
import net.spy.memcached.CachedData;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.internal.GetFuture;
import net.spy.memcached.internal.ListenableFuture;
import net.spy.memcached.internal.OperationCompletionListener;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.ops.ConcatenationOperation;
import net.spy.memcached.ops.ConcatenationType;
import net.spy.memcached.ops.DeleteOperation;
import net.spy.memcached.ops.GetAndTouchOperation;
import net.spy.memcached.ops.GetOperation;
import net.spy.memcached.ops.KeyedOperation;
import net.spy.memcached.ops.Mutator;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StatusCode;
import net.spy.memcached.ops.StoreOperation;
import net.spy.memcached.ops.StoreType;
import net.spy.memcached.protocol.binary.BinaryOperationFactory;
import net.spy.memcached.protocol.binary.EVCacheNodeImpl;
import net.spy.memcached.transcoders.Transcoder;
import net.spy.memcached.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS", "SIC_INNER_SHOULD_BE_STATIC_ANON"})
public class EVCacheMemcachedClient
extends MemcachedClient {
    private static final Logger log = LoggerFactory.getLogger(EVCacheMemcachedClient.class);
    private final int id;
    private final String appName;
    private final String zone;
    private final ChainedDynamicProperty.IntProperty readTimeout;
    private final ServerGroup serverGroup;
    private final EVCacheClient client;
    private final ConnectionFactory connectionFactory;
    private final Map<String, Counter> counterMap = new ConcurrentHashMap<String, Counter>();
    private final Map<String, Timer> timerMap = new ConcurrentHashMap<String, Timer>();
    private DistributionSummary getDataSize;
    private DistributionSummary bulkDataSize;
    private DistributionSummary getAndTouchDataSize;
    private DynamicLongProperty mutateOperationTimeout;
    private final String BULK_OPERATION_STRING = "BulkOperation";
    private final String GET_OPERATION_STRING = "GetOperation";
    private final String GET_AND_TOUCH_OPERATION_STRING = "GetAndTouchOperation";
    private final String DELETE_STRING = "DeleteOperation";
    private final String TOUCH_OPERATION_STRING = "TouchOperation";
    private final String AOA_STRING = "AoAOperation";
    private final String SET_OPERATION_STRING = "SetOperation";
    private final String ADD_OPERATION_STRING = "AddOperation";
    private final String REPLACE_OPERATION_STRING = "ReplaceOperation";
    private final String INCR_OPERATION_STRING = "IncrOperation";
    private final String DECR_OPERATION_STRING = "DecrOperation";
    private final String DELETE_OPERATION_SUCCESS_STRING = "DeleteOperation-SUCCESS";
    private final String SET_OPERATION_SUCCESS_STRING = "SetOperation-SUCCESS";
    private final String ADD_OPERATION_SUCCESS_STRING = "AddOperation-SUCCESS";
    private final String REPLACE_OPERATION_SUCCESS_STRING = "ReplaceOperation-SUCCESS";
    private final String AOA_APPEND_OPERATION_SUCCESS_STRING = "AoA-AppendOperation-SUCCESS";
    private final String AOA_ADD_OPERATION_SUCCESS_STRING = "AoA-AddOperation-SUCCESS";

    public EVCacheMemcachedClient(ConnectionFactory cf, List<InetSocketAddress> addrs, ChainedDynamicProperty.IntProperty readTimeout, String appName, String zone, int id, ServerGroup serverGroup, EVCacheClient client) throws IOException {
        super(cf, addrs);
        this.connectionFactory = cf;
        this.id = id;
        this.appName = appName;
        this.zone = zone;
        this.readTimeout = readTimeout;
        this.serverGroup = serverGroup;
        this.client = client;
    }

    public NodeLocator getNodeLocator() {
        return this.mconn.getLocator();
    }

    public MemcachedNode getEVCacheNode(String key) {
        return this.mconn.getLocator().getPrimary(key);
    }

    public <T> GetFuture<T> asyncGet(String key, Transcoder<T> tc) {
        throw new UnsupportedOperationException("asyncGet");
    }

    public <T> EVCacheOperationFuture<T> asyncGet(final String key, final Transcoder<T> tc, EVCacheGetOperationListener<T> listener) {
        final CountDownLatch latch = new CountDownLatch(1);
        final EVCacheOperationFuture<Object> rv = new EVCacheOperationFuture<Object>(key, latch, new AtomicReference<Object>(null), ((Integer)this.readTimeout.get()).intValue(), this.executorService, this.appName, this.serverGroup);
        final Stopwatch operationDuration = this.getTimer("GetOperation").start();
        GetOperation op = this.opFact.get(key, new GetOperation.Callback(){
            private Future<T> val = null;

            public void receivedStatus(OperationStatus status) {
                operationDuration.stop();
                if (log.isDebugEnabled()) {
                    log.debug("Getting Key : " + key + "; Status : " + status.getStatusCode().name() + (log.isTraceEnabled() ? " Node : " + EVCacheMemcachedClient.this.getEVCacheNode(key) : "") + "; Message : " + status.getMessage() + "; Elapsed Time - " + operationDuration.getDuration(TimeUnit.MILLISECONDS));
                }
                if (status.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                    EVCacheMemcachedClient.this.getCounter("GetOperation-SUCCESS").increment();
                } else if (status.getStatusCode().equals((Object)StatusCode.TIMEDOUT)) {
                    MemcachedNode node = EVCacheMemcachedClient.this.getEVCacheNode(key);
                    if (node instanceof EVCacheNodeImpl) {
                        EVCacheMemcachedClient.this.getCounter("GetOperation-" + status.getStatusCode().name(), ((EVCacheNodeImpl)node).getBaseTags()).increment();
                    } else {
                        EVCacheMemcachedClient.this.getCounter("GetOperation-" + status.getStatusCode().name(), (TagList)BasicTagList.of((String[])new String[]{"HOST", node.getSocketAddress().toString()})).increment();
                    }
                } else {
                    EVCacheMemcachedClient.this.getCounter("GetOperation-" + status.getStatusCode().name()).increment();
                }
                try {
                    if (this.val != null) {
                        rv.set(this.val.get(), status);
                    } else {
                        rv.set(null, status);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    rv.set(null, status);
                }
            }

            public void gotData(String k, int flags, byte[] data) {
                if (data != null) {
                    if (EVCacheMemcachedClient.this.getDataSize == null) {
                        EVCacheMemcachedClient.this.getDataSize = EVCacheMetricsFactory.getDistributionSummary(EVCacheMemcachedClient.this.appName + "-GetOperation-DataSize", EVCacheMemcachedClient.this.appName, EVCacheMemcachedClient.this.serverGroup.getName());
                    }
                    if (EVCacheMemcachedClient.this.getDataSize != null) {
                        EVCacheMemcachedClient.this.getDataSize.record((long)data.length);
                    }
                }
                if (!key.equals(k)) {
                    log.warn("Wrong key returned. Key - {}; Returned Key {}", (Object)key, (Object)k);
                }
                if (tc == null) {
                    if (EVCacheMemcachedClient.this.tcService == null) {
                        log.error("tcService is null, will not be able to decode");
                        throw new RuntimeException("TranscoderSevice is null. Not able to decode");
                    }
                    Transcoder t = EVCacheMemcachedClient.this.getTranscoder();
                    this.val = EVCacheMemcachedClient.this.tcService.decode(t, new CachedData(flags, data, t.getMaxSize()));
                } else {
                    if (EVCacheMemcachedClient.this.tcService == null) {
                        log.error("tcService is null, will not be able to decode");
                        throw new RuntimeException("TranscoderSevice is null. Not able to decode");
                    }
                    this.val = EVCacheMemcachedClient.this.tcService.decode(tc, new CachedData(flags, data, tc.getMaxSize()));
                }
            }

            public void complete() {
                latch.countDown();
                rv.signalComplete();
            }
        });
        rv.setOperation((Operation)op);
        if (listener != null) {
            rv.addListener(listener);
        }
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public <T> EVCacheBulkGetFuture<T> asyncGetBulk(final Collection<String> keys, final Transcoder<T> tc, EVCacheGetOperationListener<T> listener, String metricName) {
        final ConcurrentHashMap m = new ConcurrentHashMap();
        HashMap<MemcachedNode, ArrayList<String>> chunks = new HashMap<MemcachedNode, ArrayList<String>>();
        NodeLocator locator = this.mconn.getLocator();
        for (String key : keys) {
            StringUtils.validateKey((String)key, (boolean)(this.opFact instanceof BinaryOperationFactory));
            MemcachedNode primaryNode = locator.getPrimary(key);
            if (!primaryNode.isActive()) continue;
            ArrayList<String> ks = (ArrayList<String>)chunks.get(primaryNode);
            if (ks == null) {
                ks = new ArrayList<String>();
                chunks.put(primaryNode, ks);
            }
            ks.add(key);
        }
        final AtomicInteger pendingChunks = new AtomicInteger(chunks.size());
        int initialLatchCount = chunks.isEmpty() ? 0 : 1;
        final CountDownLatch latch = new CountDownLatch(initialLatchCount);
        ArrayList<Operation> ops = new ArrayList<Operation>(chunks.size());
        final EVCacheBulkGetFuture rv = new EVCacheBulkGetFuture(this.appName, m, ops, latch, this.executorService, this.serverGroup, metricName);
        final Stopwatch operationDuration = this.getTimer("BulkOperation").start();
        GetOperation.Callback cb = new GetOperation.Callback(){

            public void receivedStatus(OperationStatus status) {
                operationDuration.stop();
                if (log.isDebugEnabled()) {
                    log.debug("GetBulk Keys : " + keys + "; Status : " + status.getStatusCode().name() + "; Message : " + status.getMessage() + "; Elapsed Time - " + operationDuration.getDuration(TimeUnit.MILLISECONDS));
                }
                if (status.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                    EVCacheMemcachedClient.this.getCounter("BulkOperation-SUCCESS").increment();
                } else {
                    EVCacheMemcachedClient.this.getCounter("BulkOperation-" + status.getStatusCode().name()).increment();
                }
                rv.setStatus(status);
            }

            public void gotData(String k, int flags, byte[] data) {
                if (data != null) {
                    if (EVCacheMemcachedClient.this.bulkDataSize == null) {
                        EVCacheMemcachedClient.this.bulkDataSize = EVCacheMetricsFactory.getDistributionSummary(EVCacheMemcachedClient.this.appName + "-BulkOperation-DataSize", EVCacheMemcachedClient.this.appName, EVCacheMemcachedClient.this.serverGroup.getName());
                    }
                    if (EVCacheMemcachedClient.this.bulkDataSize != null) {
                        EVCacheMemcachedClient.this.bulkDataSize.record((long)data.length);
                    }
                }
                m.put(k, EVCacheMemcachedClient.this.tcService.decode(tc, new CachedData(flags, data, tc.getMaxSize())));
            }

            public void complete() {
                if (pendingChunks.decrementAndGet() <= 0) {
                    latch.countDown();
                    rv.signalComplete();
                }
            }
        };
        HashMap mops = new HashMap();
        for (Map.Entry me : chunks.entrySet()) {
            GetOperation op = this.opFact.get((Collection)me.getValue(), cb);
            mops.put(me.getKey(), op);
            ops.add((Operation)op);
        }
        assert (mops.size() == chunks.size());
        this.mconn.checkState();
        this.mconn.addOperations(mops);
        return rv;
    }

    public <T> EVCacheOperationFuture<CASValue<T>> asyncGetAndTouch(final String key, int exp, final Transcoder<T> tc) {
        final CountDownLatch latch = new CountDownLatch(1);
        final EVCacheOperationFuture<Object> rv = new EVCacheOperationFuture<Object>(key, latch, new AtomicReference<Object>(null), this.connectionFactory.getOperationTimeout(), this.executorService, this.appName, this.serverGroup);
        final Stopwatch operationDuration = this.getTimer("GetAndTouchOperation").start();
        GetAndTouchOperation op = this.opFact.getAndTouch(key, exp, new GetAndTouchOperation.Callback(){
            private CASValue<T> val = null;

            public void receivedStatus(OperationStatus status) {
                operationDuration.stop();
                if (log.isDebugEnabled()) {
                    log.debug("GetAndTouch Key : " + key + "; Status : " + status.getStatusCode().name() + (log.isTraceEnabled() ? " Node : " + EVCacheMemcachedClient.this.getEVCacheNode(key) : "") + "; Message : " + status.getMessage() + "; Elapsed Time - " + operationDuration.getDuration(TimeUnit.MILLISECONDS));
                }
                if (status.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                    EVCacheMemcachedClient.this.getCounter("GetAndTouchOperation-SUCCESS").increment();
                } else if (status.getStatusCode().equals((Object)StatusCode.TIMEDOUT)) {
                    MemcachedNode node = EVCacheMemcachedClient.this.getEVCacheNode(key);
                    if (node instanceof EVCacheNodeImpl) {
                        EVCacheMemcachedClient.this.getCounter("GetAndTouchOperation-" + status.getStatusCode().name(), ((EVCacheNodeImpl)node).getBaseTags()).increment();
                    } else {
                        EVCacheMemcachedClient.this.getCounter("GetAndTouchOperation-" + status.getStatusCode().name(), (TagList)BasicTagList.of((String[])new String[]{"HOST", node.getSocketAddress().toString()})).increment();
                    }
                } else {
                    EVCacheMemcachedClient.this.getCounter("GetAndTouchOperation-" + status.getStatusCode().name()).increment();
                }
                rv.set(this.val, status);
            }

            public void complete() {
                latch.countDown();
                rv.signalComplete();
            }

            public void gotData(String k, int flags, long cas, byte[] data) {
                if (!key.equals(k)) {
                    log.warn("Wrong key returned. Key - {}; Returned Key {}", (Object)key, (Object)k);
                }
                if (data != null) {
                    if (EVCacheMemcachedClient.this.getAndTouchDataSize == null) {
                        EVCacheMemcachedClient.this.getAndTouchDataSize = EVCacheMetricsFactory.getDistributionSummary(EVCacheMemcachedClient.this.appName + "-GATOperation-DataSize", EVCacheMemcachedClient.this.appName, EVCacheMemcachedClient.this.serverGroup.getName());
                    }
                    if (EVCacheMemcachedClient.this.getAndTouchDataSize != null) {
                        EVCacheMemcachedClient.this.getAndTouchDataSize.record((long)data.length);
                    }
                }
                this.val = new CASValue(cas, tc.decode(new CachedData(flags, data, tc.getMaxSize())));
            }
        });
        rv.setOperation((Operation)op);
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public <T> OperationFuture<Boolean> set(String key, int exp, T o, Transcoder<T> tc) {
        return this.asyncStore(StoreType.set, key, exp, o, tc, null);
    }

    public OperationFuture<Boolean> set(String key, int exp, Object o) {
        return this.asyncStore(StoreType.set, key, exp, o, this.transcoder, null);
    }

    public <T> OperationFuture<Boolean> set(String key, int exp, T o, Transcoder<T> tc, EVCacheLatch latch) {
        Transcoder t = tc == null ? this.transcoder : tc;
        return this.asyncStore(StoreType.set, key, exp, o, t, latch);
    }

    public <T> OperationFuture<Boolean> replace(String key, int exp, T o, Transcoder<T> tc, EVCacheLatch latch) {
        Transcoder t = tc == null ? this.transcoder : tc;
        return this.asyncStore(StoreType.replace, key, exp, o, t, latch);
    }

    public <T> OperationFuture<Boolean> add(String key, int exp, T o, Transcoder<T> tc) {
        return this.asyncStore(StoreType.add, key, exp, o, tc, null);
    }

    public OperationFuture<Boolean> delete(final String key, EVCacheLatch evcacheLatch) {
        final CountDownLatch latch = new CountDownLatch(1);
        final OperationFuture rv = new OperationFuture(key, latch, this.connectionFactory.getOperationTimeout(), this.executorService);
        final Stopwatch operationDuration = this.getTimer("DeleteOperation").start();
        DeleteOperation.Callback callback = new DeleteOperation.Callback(){

            public void receivedStatus(OperationStatus status) {
                operationDuration.stop();
                rv.set((Object)Boolean.TRUE, status);
                if (status.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                    EVCacheMemcachedClient.this.getCounter("DeleteOperation-SUCCESS").increment();
                } else if (status.getStatusCode().equals((Object)StatusCode.TIMEDOUT)) {
                    MemcachedNode node = EVCacheMemcachedClient.this.getEVCacheNode(key);
                    if (node instanceof EVCacheNodeImpl) {
                        EVCacheMemcachedClient.this.getCounter("DeleteOperation-" + status.getStatusCode().name(), ((EVCacheNodeImpl)node).getBaseTags()).increment();
                    } else {
                        EVCacheMemcachedClient.this.getCounter("DeleteOperation-" + status.getStatusCode().name(), (TagList)BasicTagList.of((String[])new String[]{"HOST", node.getSocketAddress().toString()})).increment();
                    }
                } else {
                    EVCacheMemcachedClient.this.getCounter("DeleteOperation-" + status.getStatusCode().name()).increment();
                }
            }

            public void gotData(long cas) {
                rv.setCas(cas);
            }

            public void complete() {
                latch.countDown();
                rv.signalComplete();
            }
        };
        DeleteOperation op = this.opFact.delete(key, callback);
        rv.setOperation((Operation)op);
        if (evcacheLatch != null && evcacheLatch instanceof EVCacheLatchImpl && !this.client.isInWriteOnly()) {
            ((EVCacheLatchImpl)evcacheLatch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)rv);
        }
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public <T> OperationFuture<Boolean> touch(final String key, int exp, EVCacheLatch evcacheLatch) {
        final CountDownLatch latch = new CountDownLatch(1);
        final OperationFuture rv = new OperationFuture(key, latch, this.connectionFactory.getOperationTimeout(), this.executorService);
        final Stopwatch operationDuration = this.getTimer("TouchOperation").start();
        KeyedOperation op = this.opFact.touch(key, exp, new OperationCallback(){

            public void receivedStatus(OperationStatus status) {
                operationDuration.stop();
                rv.set((Object)status.isSuccess(), status);
                if (status.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                    EVCacheMemcachedClient.this.getCounter("TouchOperation-SUCCESS").increment();
                } else if (status.getStatusCode().equals((Object)StatusCode.TIMEDOUT)) {
                    MemcachedNode node = EVCacheMemcachedClient.this.getEVCacheNode(key);
                    if (node instanceof EVCacheNodeImpl) {
                        EVCacheMemcachedClient.this.getCounter("TouchOperation-" + status.getStatusCode().name(), ((EVCacheNodeImpl)node).getBaseTags()).increment();
                    } else {
                        EVCacheMemcachedClient.this.getCounter("TouchOperation-" + status.getStatusCode().name(), (TagList)BasicTagList.of((String[])new String[]{"HOST", node.getSocketAddress().toString()})).increment();
                    }
                } else {
                    EVCacheMemcachedClient.this.getCounter("TouchOperation-" + status.getStatusCode().name()).increment();
                }
            }

            public void complete() {
                latch.countDown();
                rv.signalComplete();
            }
        });
        rv.setOperation((Operation)op);
        if (evcacheLatch != null && evcacheLatch instanceof EVCacheLatchImpl && !this.client.isInWriteOnly()) {
            ((EVCacheLatchImpl)evcacheLatch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)rv);
        }
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public <T> OperationFuture<Boolean> asyncAppendOrAdd(final String key, final int exp, final CachedData co, EVCacheLatch evcacheLatch) {
        final CountDownLatch latch = new CountDownLatch(1);
        final EVCacheOperationFuture<Object> rv = new EVCacheOperationFuture<Object>(key, latch, new AtomicReference<Object>(null), this.connectionFactory.getOperationTimeout(), this.executorService, this.appName, this.serverGroup);
        final Stopwatch operationDuration = this.getTimer("AoAOperation").start();
        ConcatenationOperation op = this.opFact.cat(ConcatenationType.append, 0L, key, co.getData(), new OperationCallback(){
            boolean appendSuccess = false;

            public void receivedStatus(OperationStatus val) {
                if (val.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                    if (log.isDebugEnabled()) {
                        log.debug("AddOrAppend Key (Append Operation): " + key + "; Status : " + val.getStatusCode().name() + "; Message : " + val.getMessage() + "; Elapsed Time - " + operationDuration.getDuration(TimeUnit.MILLISECONDS));
                    }
                    EVCacheMemcachedClient.this.getCounter("AoA-AppendOperation-SUCCESS").increment();
                    rv.set((Object)Boolean.TRUE, val);
                    this.appendSuccess = true;
                } else {
                    EVCacheMemcachedClient.this.getCounter("AoA-AppendOperation-" + val.getStatusCode().name()).increment();
                }
            }

            public void complete() {
                if (this.appendSuccess) {
                    operationDuration.stop();
                    latch.countDown();
                    rv.signalComplete();
                } else {
                    StoreOperation op = EVCacheMemcachedClient.this.opFact.store(StoreType.add, key, co.getFlags(), exp, co.getData(), new StoreOperation.Callback(){

                        public void receivedStatus(OperationStatus addStatus) {
                            if (log.isDebugEnabled()) {
                                log.debug("AddOrAppend Key (Ad Operation): " + key + "; Status : " + addStatus.getStatusCode().name() + "; Message : " + addStatus.getMessage() + "; Elapsed Time - " + operationDuration.getDuration(TimeUnit.MILLISECONDS));
                            }
                            if (addStatus.isSuccess()) {
                                rv.set((Object)Boolean.TRUE, addStatus);
                                appendSuccess = true;
                                EVCacheMemcachedClient.this.getCounter("AoA-AddOperation-SUCCESS").increment();
                            } else {
                                EVCacheMemcachedClient.this.getCounter("AoA-AddOperation-" + addStatus.getStatusCode().name()).increment();
                                ConcatenationOperation op = EVCacheMemcachedClient.this.opFact.cat(ConcatenationType.append, 0L, key, co.getData(), new OperationCallback(){

                                    public void receivedStatus(OperationStatus retryAppendStatus) {
                                        if (retryAppendStatus.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                                            rv.set((Object)Boolean.TRUE, retryAppendStatus);
                                            if (log.isDebugEnabled()) {
                                                log.debug("AddOrAppend Retry append Key (Append Operation): " + key + "; Status : " + retryAppendStatus.getStatusCode().name() + "; Message : " + retryAppendStatus.getMessage() + "; Elapsed Time - " + operationDuration.getDuration(TimeUnit.MILLISECONDS));
                                            }
                                            EVCacheMemcachedClient.this.getCounter("AoA-RetryAppendOperation-SUCCESS").increment();
                                        } else {
                                            rv.set((Object)Boolean.FALSE, retryAppendStatus);
                                            if (retryAppendStatus.getStatusCode().equals((Object)StatusCode.TIMEDOUT)) {
                                                MemcachedNode node = EVCacheMemcachedClient.this.getEVCacheNode(key);
                                                if (node instanceof EVCacheNodeImpl) {
                                                    EVCacheMemcachedClient.this.getCounter("AoA-RetryAppendOperation-" + retryAppendStatus.getStatusCode().name(), ((EVCacheNodeImpl)node).getBaseTags()).increment();
                                                } else {
                                                    EVCacheMemcachedClient.this.getCounter("AoA-RetryAppendOperation-" + retryAppendStatus.getStatusCode().name(), (TagList)BasicTagList.of((String[])new String[]{"HOST", node.getSocketAddress().toString()})).increment();
                                                }
                                            } else {
                                                EVCacheMemcachedClient.this.getCounter("AoA-RetryAppendOperation-" + retryAppendStatus.getStatusCode().name()).increment();
                                            }
                                        }
                                    }

                                    public void complete() {
                                        operationDuration.stop();
                                        latch.countDown();
                                        rv.signalComplete();
                                    }
                                });
                                rv.setOperation((Operation)op);
                                EVCacheMemcachedClient.this.mconn.enqueueOperation(key, (Operation)op);
                            }
                        }

                        public void gotData(String key, long cas) {
                            rv.setCas(cas);
                        }

                        public void complete() {
                            if (appendSuccess) {
                                operationDuration.stop();
                                latch.countDown();
                                rv.signalComplete();
                            }
                        }
                    });
                    rv.setOperation((Operation)op);
                    EVCacheMemcachedClient.this.mconn.enqueueOperation(key, (Operation)op);
                }
            }
        });
        rv.setOperation((Operation)op);
        this.mconn.enqueueOperation(key, (Operation)op);
        if (evcacheLatch != null && evcacheLatch instanceof EVCacheLatchImpl && !this.client.isInWriteOnly()) {
            ((EVCacheLatchImpl)evcacheLatch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)rv);
        }
        return rv;
    }

    private Timer getTimer(String name) {
        Timer timer = this.timerMap.get(name);
        if (timer != null) {
            return timer;
        }
        timer = EVCacheMetricsFactory.getStatsTimer(this.appName, this.serverGroup, name);
        this.timerMap.put(name, timer);
        return timer;
    }

    private Counter getCounter(String counterMetric, TagList tagList) {
        String name = tagList == null ? counterMetric : counterMetric + tagList;
        Counter counter = this.counterMap.get(name);
        if (counter != null) {
            return counter;
        }
        counter = EVCacheMetricsFactory.getCounter(this.appName, null, this.serverGroup.getName(), this.appName + "-" + counterMetric, tagList);
        this.counterMap.put(name, counter);
        return counter;
    }

    private Counter getCounter(String counterMetric) {
        return this.getCounter(counterMetric, null);
    }

    private <T> OperationFuture<Boolean> asyncStore(StoreType storeType, final String key, int exp, T value, Transcoder<T> tc, EVCacheLatch evcacheLatch) {
        String operationSuccessStr;
        String operationStr;
        CachedData co = value instanceof CachedData ? (CachedData)value : tc.encode(value);
        final CountDownLatch latch = new CountDownLatch(1);
        if (storeType == StoreType.set) {
            operationStr = "SetOperation";
            operationSuccessStr = "SetOperation-SUCCESS";
        } else if (storeType == StoreType.add) {
            operationStr = "AddOperation";
            operationSuccessStr = "AddOperation-SUCCESS";
        } else {
            operationStr = "ReplaceOperation";
            operationSuccessStr = "ReplaceOperation-SUCCESS";
        }
        final Timer timer = this.getTimer(operationStr);
        final EVCacheOperationFuture<Object> rv = new EVCacheOperationFuture<Object>(key, latch, new AtomicReference<Object>(null), this.connectionFactory.getOperationTimeout(), this.executorService, this.appName, this.serverGroup);
        StoreOperation op = this.opFact.store(storeType, key, co.getFlags(), exp, co.getData(), new StoreOperation.Callback(){
            final Stopwatch operationDuration;
            {
                this.operationDuration = timer.start();
            }

            public void receivedStatus(OperationStatus val) {
                this.operationDuration.stop();
                if (log.isDebugEnabled()) {
                    log.debug("Storing Key : " + key + "; Status : " + val.getStatusCode().name() + (log.isTraceEnabled() ? " Node : " + EVCacheMemcachedClient.this.getEVCacheNode(key) : "") + "; Message : " + val.getMessage() + "; Elapsed Time - " + this.operationDuration.getDuration(TimeUnit.MILLISECONDS));
                }
                if (val.getStatusCode().equals((Object)StatusCode.SUCCESS)) {
                    EVCacheMemcachedClient.this.getCounter(operationSuccessStr).increment();
                } else if (val.getStatusCode().equals((Object)StatusCode.TIMEDOUT)) {
                    MemcachedNode node = EVCacheMemcachedClient.this.getEVCacheNode(key);
                    if (node instanceof EVCacheNodeImpl) {
                        if (log.isInfoEnabled()) {
                            log.info(val.getStatusCode().name() + " Storing Key : " + key + "; Status : " + val.getStatusCode().name() + "; Node : " + node + "; Message : " + val.getMessage() + "; Elapsed Time - " + this.operationDuration.getDuration(TimeUnit.MILLISECONDS), (Throwable)new Exception());
                        }
                        if (node instanceof EVCacheNodeImpl) {
                            EVCacheMemcachedClient.this.getCounter(operationStr + "-" + val.getStatusCode().name(), ((EVCacheNodeImpl)node).getBaseTags()).increment();
                        } else {
                            EVCacheMemcachedClient.this.getCounter(operationStr + "-" + val.getStatusCode().name(), (TagList)BasicTagList.of((String[])new String[]{"HOST", node.getSocketAddress().toString()})).increment();
                        }
                    }
                } else {
                    EVCacheMemcachedClient.this.getCounter(operationStr + "-" + val.getStatusCode().name()).increment();
                }
                rv.set(val.isSuccess(), val);
            }

            public void gotData(String key2, long cas) {
                rv.setCas(cas);
            }

            public void complete() {
                latch.countDown();
                rv.signalComplete();
            }
        });
        rv.setOperation((Operation)op);
        if (evcacheLatch != null && evcacheLatch instanceof EVCacheLatchImpl && !this.client.isInWriteOnly()) {
            ((EVCacheLatchImpl)evcacheLatch).addFuture((ListenableFuture<Boolean, OperationCompletionListener>)rv);
        }
        this.mconn.enqueueOperation(key, (Operation)op);
        return rv;
    }

    public String toString() {
        return this.appName + "_" + this.zone + " _" + this.id;
    }

    public <T> OperationFuture<Boolean> add(String key, int exp, T o, Transcoder<T> tc, EVCacheLatch latch) {
        Transcoder t = tc == null ? this.transcoder : tc;
        return this.asyncStore(StoreType.add, key, exp, o, t, latch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incr(String key, long by, long def, int exp) {
        Stopwatch operationDuration = this.getTimer("IncrOperation").start();
        long val = 0L;
        try {
            val = this.mutate(Mutator.incr, key, by, def, exp);
        }
        finally {
            operationDuration.stop();
            if (log.isDebugEnabled()) {
                log.debug("Increment Key : " + key + "; by : " + by + "; default : " + def + "; exp : " + exp + "; val : " + val + "; Elapsed Time - " + operationDuration.getDuration(TimeUnit.MILLISECONDS));
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long decr(String key, long by, long def, int exp) {
        Stopwatch operationDuration = this.getTimer("DecrOperation").start();
        long val = 0L;
        try {
            val = super.decr(key, by, def, exp);
        }
        finally {
            operationDuration.stop();
            if (log.isDebugEnabled()) {
                log.debug("decrement Key : " + key + "; by : " + by + "; default : " + def + "; exp : " + exp + "; val : " + val + "; Elapsed Time - " + operationDuration.getDuration(TimeUnit.MILLISECONDS));
            }
        }
        return val;
    }

    public long mutate(Mutator m, final String key, long by, long def, int exp) {
        final AtomicLong rv = new AtomicLong();
        final CountDownLatch latch = new CountDownLatch(1);
        this.mconn.enqueueOperation(key, (Operation)this.opFact.mutate(m, key, by, def, exp, new OperationCallback(){

            public void receivedStatus(OperationStatus s) {
                rv.set(new Long(s.isSuccess() ? s.getMessage() : "-1"));
                MemcachedNode node = EVCacheMemcachedClient.this.getEVCacheNode(key);
                if (node instanceof EVCacheNodeImpl) {
                    EVCacheMemcachedClient.this.getCounter("MutateOperation-" + s.getStatusCode().name(), ((EVCacheNodeImpl)node).getBaseTags()).increment();
                } else {
                    EVCacheMemcachedClient.this.getCounter("MutateOperation-" + s.getStatusCode().name(), (TagList)BasicTagList.of((String[])new String[]{"HOST", node.getSocketAddress().toString()})).increment();
                }
            }

            public void complete() {
                latch.countDown();
            }
        }));
        try {
            if (this.mutateOperationTimeout == null) {
                this.mutateOperationTimeout = EVCacheConfig.getInstance().getDynamicLongProperty("evache.mutate.timeout", this.connectionFactory.getOperationTimeout());
            }
            if (!latch.await(this.mutateOperationTimeout.get(), TimeUnit.MILLISECONDS)) {
                return rv.get();
            }
        }
        catch (InterruptedException e) {
            log.error("InterruptedException", (Throwable)e);
        }
        this.getLogger().debug((Object)("Mutation returned " + rv));
        return rv.get();
    }

    public void reconnectNode(EVCacheNodeImpl evcNode) {
        long upTime = System.currentTimeMillis() - evcNode.getCreateTime();
        if (log.isDebugEnabled()) {
            log.debug("Reconnecting node : " + evcNode + "; UpTime : " + upTime);
        }
        if (upTime > 30000L) {
            EVCacheMetricsFactory.getCounter(this.appName + "-RECONNECT", evcNode.getBaseTags()).increment();
            evcNode.setConnectTime(System.currentTimeMillis());
            this.mconn.queueReconnect((MemcachedNode)evcNode);
        }
    }
}

