/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.config.DynamicIntProperty;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.pool.EVCacheExecutorMBean;
import com.netflix.evcache.util.EVCacheConfig;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.LongGauge;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.Tag;
import java.lang.management.ManagementFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVCacheExecutor
extends ThreadPoolExecutor
implements EVCacheExecutorMBean {
    private static final Logger log = LoggerFactory.getLogger(EVCacheExecutor.class);
    private final DynamicIntProperty maxAsyncPoolSize;
    private final DynamicIntProperty coreAsyncPoolSize;
    private final String name;

    public EVCacheExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, RejectedExecutionHandler handler, String name) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("EVCacheExecutor-" + name + "-%d").build());
        this.name = name;
        this.maxAsyncPoolSize = EVCacheConfig.getInstance().getDynamicIntProperty("EVCacheExecutor." + name + ".max.size", maximumPoolSize);
        this.setMaximumPoolSize(this.maxAsyncPoolSize.get());
        this.coreAsyncPoolSize = EVCacheConfig.getInstance().getDynamicIntProperty("EVCacheExecutor." + name + ".core.size", corePoolSize);
        this.setCorePoolSize(this.coreAsyncPoolSize.get());
        this.setKeepAliveTime(keepAliveTime, unit);
        this.maxAsyncPoolSize.addCallback(new Runnable(){

            @Override
            public void run() {
                EVCacheExecutor.this.setMaximumPoolSize(EVCacheExecutor.this.maxAsyncPoolSize.get());
            }
        });
        this.coreAsyncPoolSize.addCallback(new Runnable(){

            @Override
            public void run() {
                EVCacheExecutor.this.setCorePoolSize(EVCacheExecutor.this.coreAsyncPoolSize.get());
                EVCacheExecutor.this.prestartAllCoreThreads();
            }
        });
        this.setupMonitoring(name);
    }

    private void setupMonitoring(String name) {
        block5: {
            try {
                ObjectName mBeanName = ObjectName.getInstance("com.netflix.evcache:Group=ThreadPool,SubGroup=" + name);
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mbeanServer.isRegistered(mBeanName)) {
                    if (log.isDebugEnabled()) {
                        log.debug("MBEAN with name " + mBeanName + " has been registered. Will unregister the previous instance and register a new one.");
                    }
                    mbeanServer.unregisterMBean(mBeanName);
                }
                mbeanServer.registerMBean(this, mBeanName);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("Exception", (Throwable)e);
            }
        }
        MonitorRegistry registry = DefaultMonitorRegistry.getInstance();
        registry.register((Monitor)new Monitor<Number>(){
            final MonitorConfig config = MonitorConfig.builder((String)"EVCacheExecutor.completedTaskCount").withTag((Tag)DataSourceType.COUNTER).withTag(EVCacheMetricsFactory.OWNER).build();

            public Number getValue() {
                return EVCacheExecutor.this.getCompletedTaskCount();
            }

            public Number getValue(int pollerIndex) {
                return this.getValue();
            }

            public MonitorConfig getConfig() {
                return this.config;
            }
        });
        MonitorConfig.Builder builder = MonitorConfig.builder((String)"EVCacheExecutor.currentQueueSize").withTag((Tag)DataSourceType.GAUGE).withTag(EVCacheMetricsFactory.OWNER);
        LongGauge queueSize = new LongGauge(builder.build()){

            public Long getValue() {
                return EVCacheExecutor.this.getQueueSize();
            }

            public Long getValue(int pollerIndex) {
                return this.getValue();
            }
        };
        if (registry.isRegistered((Monitor)queueSize)) {
            registry.unregister((Monitor)queueSize);
        }
        registry.register((Monitor)queueSize);
    }

    @Override
    public void shutdown() {
        block2: {
            try {
                ObjectName mBeanName = ObjectName.getInstance("com.netflix.evcache:Group=ThreadPool,SubGroup=" + this.name);
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                mbeanServer.unregisterMBean(mBeanName);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Exception", (Throwable)e);
            }
        }
        super.shutdown();
    }

    @Override
    public int getQueueSize() {
        return this.getQueue().size();
    }
}

