/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache;

import com.google.inject.AbstractModule;
import com.google.inject.Singleton;
import com.netflix.archaius.api.annotations.ConfigurationSource;
import com.netflix.evcache.event.hotkey.HotKeyListener;
import com.netflix.evcache.event.throttle.ThrottleListener;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.TagList;

@Singleton
public class EVCacheModule
extends AbstractModule {
    protected void configure() {
        this.bind(EVCacheModuleConfigLoader.class).asEagerSingleton();
        this.bind(EVCacheClientPoolManager.class).asEagerSingleton();
        this.bind(HotKeyListener.class).asEagerSingleton();
        this.bind(ThrottleListener.class).asEagerSingleton();
        this.bind(VersionTracker.class).asEagerSingleton();
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == ((Object)((Object)this)).getClass();
    }

    @Singleton
    private static class VersionTracker {
        private VersionTracker() {
            String fullVersion = this.getClass().getPackage().getImplementationVersion() != null ? this.getClass().getPackage().getImplementationVersion() : "unknown";
            String jarName = this.getClass().getPackage().getImplementationTitle() != null ? this.getClass().getPackage().getImplementationTitle() : "unknown";
            EVCacheMetricsFactory.getLongGauge("evcache-client", (TagList)BasicTagList.of((String[])new String[]{"version", fullVersion, "jarName", jarName})).set(Long.valueOf(1L));
        }
    }

    @Singleton
    @ConfigurationSource(value={"evcache"})
    public static class EVCacheModuleConfigLoader {
    }
}

