/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.config.ChainedDynamicProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.shared.Application;
import com.netflix.evcache.pool.ServerGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.util.DefaultKetamaNodeLocatorConfiguration;

public class EVCacheKetamaNodeLocatorConfiguration
extends DefaultKetamaNodeLocatorConfiguration {
    private final String appId;
    private final ServerGroup replicaSet;
    private final ChainedDynamicProperty.IntProperty bucketSize;

    public EVCacheKetamaNodeLocatorConfiguration(String appId, ServerGroup serverGroup) {
        this.appId = appId;
        this.replicaSet = serverGroup;
        this.bucketSize = new ChainedDynamicProperty.IntProperty(appId + "." + serverGroup.getName() + ".bucket.size", new DynamicIntProperty(appId + ".bucket.size", super.getNodeRepetitions()));
    }

    public int getNodeRepetitions() {
        return (Integer)this.bucketSize.get();
    }

    protected String getSocketAddressForNode(MemcachedNode node) {
        String result = (String)this.socketAddresses.get(node);
        if (result == null) {
            SocketAddress socketAddress = node.getSocketAddress();
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress isa = (InetSocketAddress)socketAddress;
                if (DiscoveryManager.getInstance() != null && DiscoveryManager.getInstance().getDiscoveryClient() != null) {
                    DiscoveryClient mgr = DiscoveryManager.getInstance().getDiscoveryClient();
                    Application app = mgr.getApplication(this.appId);
                    List instances = app.getInstances();
                    for (InstanceInfo info : instances) {
                        String hostName = info.getHostName();
                        if (!hostName.equalsIgnoreCase(isa.getHostName())) continue;
                        String ip = info.getIPAddr();
                        String port = (String)info.getMetadata().get("evcache.port");
                        result = hostName + '/' + ip + ':' + (port != null ? port : "11211");
                    }
                } else {
                    result = ((InetSocketAddress)socketAddress).getHostName() + '/' + ((InetSocketAddress)socketAddress).getPort();
                }
            } else {
                result = String.valueOf(socketAddress);
                if (result.startsWith("/")) {
                    result = result.substring(1);
                }
            }
            this.socketAddresses.put(node, result);
        }
        return result;
    }

    public String toString() {
        return "EVCacheKetamaNodeLocatorConfiguration [app=" + this.appId + ", ReplicaSet=" + this.replicaSet + ", BucketSize=" + this.getNodeRepetitions() + "]";
    }
}

