/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache;

import com.netflix.config.ChainedDynamicProperty;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.evcache.EVCache;
import com.netflix.evcache.EVCacheException;
import com.netflix.evcache.EVCacheGetOperationListener;
import com.netflix.evcache.EVCacheInMemoryCache;
import com.netflix.evcache.EVCacheLatch;
import com.netflix.evcache.EVCacheMissException;
import com.netflix.evcache.EVCacheReadQueueException;
import com.netflix.evcache.event.EVCacheEvent;
import com.netflix.evcache.event.EVCacheEventListener;
import com.netflix.evcache.metrics.EVCacheMetricsFactory;
import com.netflix.evcache.metrics.Operation;
import com.netflix.evcache.metrics.Stats;
import com.netflix.evcache.operation.EVCacheFuture;
import com.netflix.evcache.operation.EVCacheLatchImpl;
import com.netflix.evcache.operation.EVCacheOperationFuture;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.EVCacheClientPool;
import com.netflix.evcache.pool.EVCacheClientPoolManager;
import com.netflix.evcache.util.EVCacheConfig;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.tag.Tag;
import com.netflix.spectator.api.DistributionSummary;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import net.spy.memcached.CachedData;
import net.spy.memcached.internal.CheckedOperationTimeoutException;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.schedulers.Schedulers;

@SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS", "WMI_WRONG_MAP_ITERATOR", "DB_DUPLICATE_BRANCHES", "REC_CATCH_EXCEPTION", "RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
public final class EVCacheImpl
implements EVCache {
    private static Logger log = LoggerFactory.getLogger(EVCacheImpl.class);
    private final String _appName;
    private final String _cacheName;
    private final String _metricPrefix;
    private final String _metricName;
    private final Transcoder<?> _transcoder;
    private final boolean _zoneFallback;
    private final boolean _throwException;
    private final int _timeToLive;
    private final EVCacheClientPool _pool;
    private final ChainedDynamicProperty.BooleanProperty _throwExceptionFP;
    private final ChainedDynamicProperty.BooleanProperty _zoneFallbackFP;
    private final DynamicBooleanProperty _bulkZoneFallbackFP;
    private final DynamicBooleanProperty _bulkPartialZoneFallbackFP;
    private final ChainedDynamicProperty.BooleanProperty _useInMemoryCache;
    private final Stats stats;
    private EVCacheInMemoryCache<?> cache;
    private final EVCacheClientPoolManager _poolManager;
    private DistributionSummary ttlSummary;
    private DistributionSummary dataSizeSummary;
    private Counter touchCounter;
    private Counter observeGetCounter;

    EVCacheImpl(String appName, String cacheName, int timeToLive, Transcoder<?> transcoder, boolean enableZoneFallback, boolean throwException, EVCacheClientPoolManager poolManager) {
        this._appName = appName;
        this._cacheName = cacheName;
        this._timeToLive = timeToLive;
        this._transcoder = transcoder;
        this._zoneFallback = enableZoneFallback;
        this._throwException = throwException;
        this.stats = EVCacheMetricsFactory.getStats(appName, cacheName);
        this._metricName = this._cacheName == null ? this._appName : this._appName + "." + this._cacheName;
        this._metricPrefix = this._cacheName == null ? this._appName : this._appName + "-" + this._cacheName;
        this._poolManager = poolManager;
        this._pool = poolManager.getEVCacheClientPool(this._appName);
        this._throwExceptionFP = EVCacheConfig.getInstance().getChainedBooleanProperty(this._metricName + ".throw.exception", this._appName + ".throw.exception", Boolean.FALSE);
        this._zoneFallbackFP = EVCacheConfig.getInstance().getChainedBooleanProperty(this._metricName + ".fallback.zone", this._appName + ".fallback.zone", Boolean.TRUE);
        this._bulkZoneFallbackFP = EVCacheConfig.getInstance().getDynamicBooleanProperty(this._appName + ".bulk.fallback.zone", true);
        this._bulkPartialZoneFallbackFP = EVCacheConfig.getInstance().getDynamicBooleanProperty(this._appName + ".bulk.partial.fallback.zone", true);
        this._useInMemoryCache = EVCacheConfig.getInstance().getChainedBooleanProperty(this._appName + ".use.inmemory.cache", "evcache.use.inmemory.cache", Boolean.FALSE);
        this._pool.pingServers();
    }

    private String getCanonicalizedKey(String key) {
        if (this._cacheName == null) {
            return key;
        }
        return this._cacheName + ':' + key;
    }

    private String getKey(String canonicalizedKey) {
        if (canonicalizedKey == null) {
            return canonicalizedKey;
        }
        if (this._cacheName == null) {
            return canonicalizedKey;
        }
        String _cacheNameDelimited = this._cacheName + ':';
        return canonicalizedKey.replaceFirst(_cacheNameDelimited, "");
    }

    private boolean hasZoneFallbackForBulk() {
        if (!this._pool.supportsFallback()) {
            return false;
        }
        if (!this._bulkZoneFallbackFP.get()) {
            return false;
        }
        return this._zoneFallback;
    }

    private boolean hasZoneFallback() {
        if (!this._pool.supportsFallback()) {
            return false;
        }
        if (!((Boolean)this._zoneFallbackFP.get()).booleanValue()) {
            return false;
        }
        return this._zoneFallback;
    }

    private boolean shouldLog() {
        return this._poolManager.shouldLog(this._appName);
    }

    private boolean doThrowException() {
        return this._throwException || (Boolean)this._throwExceptionFP.get() != false;
    }

    private List<EVCacheEventListener> getEVCacheEventListeners() {
        return this._poolManager.getEVCacheEventListeners();
    }

    private EVCacheEvent createEVCacheEvent(Collection<EVCacheClient> clients, Collection<String> keys, EVCache.Call call) {
        List<EVCacheEventListener> evcacheEventListenerList = this.getEVCacheEventListeners();
        if (evcacheEventListenerList == null || evcacheEventListenerList.size() == 0) {
            return null;
        }
        EVCacheEvent event = new EVCacheEvent(call, this._appName, this._cacheName);
        event.setKeys(keys);
        event.setClients(clients);
        return event;
    }

    private boolean shouldThrottle(EVCacheEvent event) {
        for (EVCacheEventListener evcacheEventListener : this.getEVCacheEventListeners()) {
            if (!evcacheEventListener.onThrottle(event)) continue;
            return true;
        }
        return false;
    }

    private void startEvent(EVCacheEvent event) {
        List<EVCacheEventListener> evcacheEventListenerList = this.getEVCacheEventListeners();
        for (EVCacheEventListener evcacheEventListener : evcacheEventListenerList) {
            evcacheEventListener.onStart(event);
        }
    }

    private void endEvent(EVCacheEvent event) {
        List<EVCacheEventListener> evcacheEventListenerList = this.getEVCacheEventListeners();
        for (EVCacheEventListener evcacheEventListener : evcacheEventListenerList) {
            evcacheEventListener.onComplete(event);
        }
    }

    private void eventError(EVCacheEvent event, Throwable t) {
        List<EVCacheEventListener> evcacheEventListenerList = this.getEVCacheEventListeners();
        for (EVCacheEventListener evcacheEventListener : evcacheEventListenerList) {
            evcacheEventListener.onError(event, t);
        }
    }

    private <T> EVCacheInMemoryCache<T> getInMemoryCache() {
        if (this.cache == null) {
            this.cache = new EVCacheInMemoryCache(this._appName);
        }
        return this.cache;
    }

    @Override
    public <T> void get(String key, EVCacheGetOperationListener<T> listener) throws EVCacheException {
        this.get(key, this._transcoder, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void get(String key, Transcoder<T> tc, EVCacheGetOperationListener<T> listener) throws EVCacheException {
        if (null == key) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient client = this._pool.getEVCacheClientForRead();
        if (client == null) {
            EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-NULL_CLIENT");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to get the data APP " + this._appName);
            }
            return;
        }
        EVCacheEvent event = this.createEVCacheEvent(Collections.singletonList(client), Collections.singletonList(key), EVCache.Call.GETL);
        if (event != null) {
            if (this.shouldThrottle(event)) {
                EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-THROTTLED");
                if (throwExc) {
                    throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                }
                return;
            }
            this.startEvent(event);
        }
        String canonicalKey = this.getCanonicalizedKey(key);
        Operation op = EVCacheMetricsFactory.getOperation(this._metricName, EVCache.Call.GETL, this.stats, Operation.TYPE.MILLI);
        try {
            boolean hasZF = this.hasZoneFallback();
            boolean throwEx = hasZF ? false : throwExc;
            client.get(canonicalKey, tc, throwEx, hasZF, listener);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("GETL : APP " + this._appName + ", key [" + canonicalKey + "], " + ", zone : " + client.getZone());
            }
            if (event != null) {
                this.endEvent(event);
            }
            return;
        }
        catch (CheckedOperationTimeoutException ex) {
            if (event != null) {
                this.eventError(event, ex);
            }
            if (throwExc) {
                throw new EVCacheException("CheckedOperationTimeoutException getting data for APP " + this._appName + ", key = " + canonicalKey + ".\nYou can set the following property to increase the timeout " + this._appName + ".EVCacheClientPool.readTimeout=<timeout in milli-seconds>", ex);
            }
        }
        catch (Exception ex) {
            if (event != null) {
                this.eventError(event, ex);
            }
            if (throwExc) {
                throw new EVCacheException("Exception getting data for APP " + this._appName + ", key = " + canonicalKey, ex);
            }
        }
        finally {
            op.stop();
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("GETL : APP " + this._appName + ", Took " + op.getDuration() + " milliSec.");
            }
        }
    }

    @Override
    public <T> T get(String key) throws EVCacheException {
        return (T)this.get(key, this._transcoder);
    }

    @Override
    public <T> T get(String key, Transcoder<T> tc) throws EVCacheException {
        if (null == key) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient client = this._pool.getEVCacheClientForRead();
        if (client == null) {
            EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-NULL_CLIENT");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to get the data APP " + this._appName);
            }
            return null;
        }
        EVCacheEvent event = this.createEVCacheEvent(Collections.singletonList(client), Collections.singletonList(key), EVCache.Call.GET);
        if (event != null) {
            if (this.shouldThrottle(event)) {
                EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-THROTTLED");
                if (throwExc) {
                    throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                }
                return null;
            }
            this.startEvent(event);
        }
        String canonicalKey = this.getCanonicalizedKey(key);
        if (((Boolean)this._useInMemoryCache.get()).booleanValue()) {
            T value = this.getInMemoryCache().get(canonicalKey);
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Value retrieved from inmemory cache for APP " + this._appName + ", key : " + canonicalKey + "; value : " + value);
            }
            if (value != null) {
                return value;
            }
        }
        Operation op = EVCacheMetricsFactory.getOperation(this._metricName, EVCache.Call.GET, this.stats, Operation.TYPE.MILLI);
        try {
            List<EVCacheClient> fbClients;
            boolean hasZF = this.hasZoneFallback();
            boolean throwEx = hasZF ? false : throwExc;
            T data = this.getData(client, canonicalKey, tc, throwEx, hasZF);
            if (data == null && hasZF && (fbClients = this._pool.getEVCacheClientsForReadExcluding(client.getServerGroup())) != null && !fbClients.isEmpty()) {
                for (EVCacheClient fbClient : fbClients) {
                    data = this.getData(fbClient, canonicalKey, tc, throwExc, false);
                    if (log.isDebugEnabled() && this.shouldLog()) {
                        log.debug("Retry for APP " + this._appName + ", key [" + canonicalKey + "], Value [" + data + "]" + ", ServerGroup : " + fbClient.getServerGroup());
                    }
                    if (data == null) continue;
                    client = fbClient;
                    break;
                }
                EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-RETRY_" + (data == null ? "MISS" : "HIT"));
            }
            if (data != null) {
                this.stats.cacheHit(EVCache.Call.GET);
                if (event != null) {
                    event.setAttribute("status", "GHIT");
                }
                if (((Boolean)this._useInMemoryCache.get()).booleanValue()) {
                    this.getInMemoryCache().put(canonicalKey, data);
                    if (log.isDebugEnabled() && this.shouldLog()) {
                        log.debug("Value added to inmemory cache for APP " + this._appName + ", key : " + canonicalKey);
                    }
                }
            } else {
                if (event != null) {
                    event.setAttribute("status", "GMISS");
                }
                if (log.isInfoEnabled() && this.shouldLog()) {
                    log.info("GET : APP " + this._appName + " ; cache miss for key : " + canonicalKey);
                }
            }
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("GET : APP " + this._appName + ", key [" + canonicalKey + "], Value [" + data + "]" + ", ServerGroup : " + client.getServerGroup());
            }
            if (event != null) {
                this.endEvent(event);
            }
            T t = data;
            return t;
        }
        catch (CheckedOperationTimeoutException ex) {
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                T t = null;
                return t;
            }
            throw new EVCacheException("CheckedOperationTimeoutException getting data for APP " + this._appName + ", key = " + canonicalKey + ".\nYou can set the following property to increase the timeout " + this._appName + ".EVCacheClientPool.readTimeout=<timeout in milli-seconds>", ex);
        }
        catch (Exception ex) {
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                T t = null;
                return t;
            }
            throw new EVCacheException("Exception getting data for APP " + this._appName + ", key = " + canonicalKey, ex);
        }
        finally {
            op.stop();
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("GET : APP " + this._appName + ", Took " + op.getDuration() + " milliSec.");
            }
        }
    }

    private <T> T getData(EVCacheClient client, String canonicalKey, Transcoder<T> tc, boolean throwException, boolean hasZF) throws Exception {
        if (client == null) {
            return null;
        }
        try {
            return client.get(canonicalKey, tc, throwException, hasZF);
        }
        catch (EVCacheReadQueueException ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("EVCacheReadQueueException while getting data for APP " + this._appName + ", key : " + canonicalKey + "; hasZF : " + hasZF, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
        catch (EVCacheException ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("EVCacheException while getting data for APP " + this._appName + ", key : " + canonicalKey + "; hasZF : " + hasZF, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception while getting data for APP " + this._appName + ", key : " + canonicalKey, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
    }

    private <T> T getAndTouchData(EVCacheClient client, String canonicalKey, Transcoder<T> tc, boolean throwException, boolean hasZF, int timeToLive) throws Exception {
        try {
            return client.getAndTouch(canonicalKey, tc, timeToLive, throwException, hasZF);
        }
        catch (EVCacheReadQueueException ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("EVCacheReadQueueException while getAndTouch data for APP " + this._appName + ", key : " + canonicalKey + "; hasZF : " + hasZF, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
        catch (EVCacheException ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("EVCacheException while getAndTouch data for APP " + this._appName + ", key : " + canonicalKey + "; hasZF : " + hasZF, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception while getAndTouch data for APP " + this._appName + ", key : " + canonicalKey, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public <T> T getAndTouch(String key, int timeToLive) throws EVCacheException {
        return (T)this.getAndTouch(key, timeToLive, this._transcoder);
    }

    @Override
    public <T> T getAndTouch(String key, int timeToLive, Transcoder<T> tc) throws EVCacheException {
        T value;
        if (null == key) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient client = this._pool.getEVCacheClientForRead();
        if (client == null) {
            EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-NULL_CLIENT");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to get and touch the data");
            }
            return null;
        }
        EVCacheEvent event = this.createEVCacheEvent(Collections.singletonList(client), Collections.singletonList(key), EVCache.Call.GET_AND_TOUCH);
        if (event != null) {
            if (this.shouldThrottle(event)) {
                EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-THROTTLED");
                if (throwExc) {
                    throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                }
                return null;
            }
            this.startEvent(event);
        }
        String canonicalKey = this.getCanonicalizedKey(key);
        if (((Boolean)this._useInMemoryCache.get()).booleanValue() && (value = this.getInMemoryCache().get(canonicalKey)) != null) {
            this.touch(key, timeToLive);
            return value;
        }
        Operation op = EVCacheMetricsFactory.getOperation(this._metricName, EVCache.Call.GET_AND_TOUCH, this.stats, Operation.TYPE.MILLI);
        try {
            boolean hasZF = this.hasZoneFallback();
            boolean throwEx = hasZF ? false : throwExc;
            T data = this.getAndTouchData(client, canonicalKey, tc, throwEx, hasZF, timeToLive);
            if (data == null && hasZF) {
                List<EVCacheClient> fbClients = this._pool.getEVCacheClientsForReadExcluding(client.getServerGroup());
                for (EVCacheClient fbClient : fbClients) {
                    data = this.getData(fbClient, canonicalKey, tc, throwExc, false);
                    if (log.isDebugEnabled() && this.shouldLog()) {
                        log.debug("GetAndTouch Retry for APP " + this._appName + ", key [" + canonicalKey + "], Value [" + data + "]" + ", ServerGroup : " + fbClient.getServerGroup());
                    }
                    if (data == null) continue;
                    client = fbClient;
                    break;
                }
                EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-RETRY_" + (data == null ? "MISS" : "HIT"));
            }
            if (data != null) {
                this.stats.cacheHit(EVCache.Call.GET_AND_TOUCH);
                if (event != null) {
                    event.setAttribute("status", "THIT");
                }
                if (((Boolean)this._useInMemoryCache.get()).booleanValue()) {
                    this.getInMemoryCache().put(canonicalKey, data);
                    if (log.isDebugEnabled() && this.shouldLog()) {
                        log.debug("Value added to inmemory cache for APP " + this._appName + ", key : " + canonicalKey);
                    }
                }
                this.touch(key, timeToLive);
            } else {
                if (log.isInfoEnabled() && this.shouldLog()) {
                    log.info("GET_AND_TOUCH : APP " + this._appName + " ; cache miss for key : " + canonicalKey);
                }
                if (event != null) {
                    event.setAttribute("status", "TMISS");
                }
            }
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("GET_AND_TOUCH : APP " + this._appName + ", key [" + canonicalKey + "], Value [" + data + "]" + ", ServerGroup : " + client.getServerGroup());
            }
            if (event != null) {
                this.endEvent(event);
            }
            T t = data;
            return t;
        }
        catch (CheckedOperationTimeoutException ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("CheckedOperationTimeoutException executing getAndTouch APP " + this._appName + ", key : " + canonicalKey, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                T t = null;
                return t;
            }
            throw new EVCacheException("CheckedOperationTimeoutException executing getAndTouch APP " + this._appName + ", key  = " + canonicalKey + ".\nYou can set the following property to increase the timeout " + this._appName + ".EVCacheClientPool.readTimeout=<timeout in milli-seconds>", ex);
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception executing getAndTouch APP " + this._appName + ", key = " + canonicalKey, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                T t = null;
                return t;
            }
            throw new EVCacheException("Exception executing getAndTouch APP " + this._appName + ", key = " + canonicalKey, ex);
        }
        finally {
            op.stop();
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Took " + op.getDuration() + " milliSec to get&Touch the value for APP " + this._appName + ", key " + canonicalKey);
            }
        }
    }

    @Override
    public Future<Boolean>[] touch(String key, int timeToLive) throws EVCacheException {
        if (null == key) {
            throw new IllegalArgumentException();
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-NULL_CLIENT");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to set the data");
            }
            return new EVCacheFuture[0];
        }
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), Collections.singletonList(key), EVCache.Call.TOUCH);
        if (event != null) {
            if (this.shouldThrottle(event)) {
                EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-THROTTLED");
                if (throwExc) {
                    throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                }
                return new EVCacheFuture[0];
            }
            this.startEvent(event);
        }
        String canonicalKey = this.getCanonicalizedKey(key);
        try {
            EVCacheFuture[] futures = new EVCacheFuture[clients.length];
            int index = 0;
            for (EVCacheClient client : clients) {
                Future<Boolean> future = client.touch(canonicalKey, timeToLive);
                futures[index++] = new EVCacheFuture(future, key, this._appName, client.getServerGroup());
            }
            if (this.touchCounter == null) {
                this.touchCounter = EVCacheMetricsFactory.getCounter(this._appName, this._cacheName, this._metricPrefix + "-TouchCall", (Tag)DataSourceType.COUNTER);
            }
            if (this.touchCounter != null) {
                this.touchCounter.increment();
            }
            if (event != null) {
                event.setCanonicalKeys(Arrays.asList(canonicalKey));
                event.setTTL(timeToLive);
                this.endEvent(event);
            }
            EVCacheFuture[] eVCacheFutureArray = futures;
            return eVCacheFutureArray;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception touching the data for APP " + this._appName + ", key : " + canonicalKey, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                EVCacheFuture[] eVCacheFutureArray = new EVCacheFuture[]{};
                return eVCacheFutureArray;
            }
            throw new EVCacheException("Exception setting data for APP " + this._appName + ", key : " + canonicalKey, ex);
        }
        finally {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("TOUCH : APP " + this._appName + " for key : " + canonicalKey + " with ttl : " + timeToLive);
            }
        }
    }

    @Override
    public <T> Future<T> getAsynchronous(String key) throws EVCacheException {
        return this.getAsynchronous(key, this._transcoder);
    }

    @Override
    public <T> Future<T> getAsynchronous(String key, Transcoder<T> tc) throws EVCacheException {
        Future<T> r;
        if (null == key) {
            throw new IllegalArgumentException();
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient client = this._pool.getEVCacheClientForRead();
        if (client == null) {
            EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-NULL_CLIENT");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to asynchronously get the data");
            }
            return null;
        }
        EVCacheEvent event = this.createEVCacheEvent(Collections.singletonList(client), Collections.singletonList(key), EVCache.Call.ASYNC_GET);
        if (event != null) {
            if (this.shouldThrottle(event)) {
                EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-THROTTLED");
                if (throwExc) {
                    throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                }
                return null;
            }
            this.startEvent(event);
        }
        Operation op = EVCacheMetricsFactory.getOperation(this._metricName, EVCache.Call.ASYNC_GET, this.stats, Operation.TYPE.MILLI);
        try {
            String canonicalKey = this.getCanonicalizedKey(key);
            r = client.asyncGet(canonicalKey, tc, throwExc, false);
            if (event != null) {
                this.endEvent(event);
            }
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception while getting data for keys Asynchronously APP " + this._appName + ", key : " + key, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                Future<T> future = null;
                return future;
            }
            throw new EVCacheException("Exception getting data for APP " + this._appName + ", key : " + key, ex);
        }
        finally {
            op.stop();
        }
        return r;
    }

    private <T> Map<String, T> getBulkData(EVCacheClient client, Collection<String> canonicalKeys, Transcoder<T> tc, boolean throwException, boolean hasZF) throws Exception {
        try {
            return client.getBulk(canonicalKeys, tc, throwException, hasZF);
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception while getBulk data for APP " + this._appName + ", key : " + canonicalKeys, (Throwable)ex);
            }
            if (!throwException || hasZF) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public <T> Map<String, T> getBulk(Collection<String> keys, Transcoder<T> tc) throws EVCacheException {
        return this.getBulk(keys, tc, false, 0);
    }

    @Override
    public <T> Map<String, T> getBulkAndTouch(Collection<String> keys, Transcoder<T> tc, int timeToLive) throws EVCacheException {
        return this.getBulk(keys, tc, true, timeToLive);
    }

    private <T> Map<String, T> getBulk(Collection<String> keys, Transcoder<T> tc, boolean touch, int ttl) throws EVCacheException {
        if (null == keys) {
            throw new IllegalArgumentException();
        }
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient client = this._pool.getEVCacheClientForRead();
        if (client == null) {
            EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-NULL_CLIENT");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to get the data in bulk");
            }
            return Collections.emptyMap();
        }
        EVCacheEvent event = this.createEVCacheEvent(Collections.singletonList(client), keys, EVCache.Call.BULK);
        if (event != null) {
            if (this.shouldThrottle(event)) {
                EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-THROTTLED");
                if (throwExc) {
                    throw new EVCacheException("Request Throttled for app " + this._appName + " & keys " + keys);
                }
                return Collections.emptyMap();
            }
            this.startEvent(event);
        }
        ArrayList<String> canonicalKeys = new ArrayList<String>();
        for (String k : keys) {
            String canonicalK = this.getCanonicalizedKey(k);
            canonicalKeys.add(canonicalK);
        }
        Operation op = EVCacheMetricsFactory.getOperation(this._metricName, EVCache.Call.BULK, this.stats, Operation.TYPE.MILLI);
        try {
            boolean hasZF = this.hasZoneFallbackForBulk();
            boolean throwEx = hasZF ? false : throwExc;
            EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-BULK_GET");
            Map<String, T> retMap = this.getBulkData(client, canonicalKeys, tc, throwEx, hasZF);
            List<EVCacheClient> fbClients = null;
            if (hasZF) {
                if ((retMap == null || retMap.isEmpty()) && (fbClients = this._pool.getEVCacheClientsForReadExcluding(client.getServerGroup())) != null && !fbClients.isEmpty()) {
                    for (EVCacheClient fbClient : fbClients) {
                        retMap = this.getBulkData(fbClient, canonicalKeys, tc, throwEx, false);
                        if (log.isDebugEnabled() && this.shouldLog()) {
                            log.debug("Fallback for APP " + this._appName + ", key [" + canonicalKeys + "], Value [" + retMap + "]" + ", zone : " + fbClient.getZone());
                        }
                        if (retMap == null || retMap.isEmpty()) continue;
                        break;
                    }
                    EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricName + "-BULK_GET-FULL_RETRY-" + (retMap == null || retMap.isEmpty() ? "MISS" : "HIT"));
                }
                if (retMap != null && keys.size() > retMap.size() && this._bulkPartialZoneFallbackFP.get()) {
                    int initRetMapSize = retMap.size();
                    int initRetrySize = keys.size() - retMap.size();
                    ArrayList<String> retryKeys = new ArrayList<String>(initRetrySize);
                    for (String key : canonicalKeys) {
                        if (retMap.containsKey(key)) continue;
                        retryKeys.add(key);
                    }
                    fbClients = this._pool.getEVCacheClientsForReadExcluding(client.getServerGroup());
                    if (fbClients != null && !fbClients.isEmpty()) {
                        for (int ind = 0; ind < fbClients.size(); ++ind) {
                            EVCacheClient fbClient = fbClients.get(ind);
                            Map<String, T> fbRetMap = this.getBulkData(fbClient, retryKeys, tc, false, hasZF);
                            if (log.isDebugEnabled() && this.shouldLog()) {
                                log.debug("Fallback for APP " + this._appName + ", key [" + retryKeys + "], Fallback Server Group : " + fbClient.getServerGroup().getName());
                            }
                            for (Map.Entry<String, T> i : fbRetMap.entrySet()) {
                                retMap.put(i.getKey(), i.getValue());
                                if (!log.isDebugEnabled() || !this.shouldLog()) continue;
                                log.debug("Fallback for APP " + this._appName + ", key [" + i.getKey() + "], Value [" + i.getValue() + "]");
                            }
                            if (retryKeys.size() == fbRetMap.size()) break;
                            if (ind >= fbClients.size()) continue;
                            retryKeys = new ArrayList(keys.size() - retMap.size());
                            for (String key : canonicalKeys) {
                                if (retMap.containsKey(key)) continue;
                                retryKeys.add(key);
                            }
                        }
                        if (retMap.size() > initRetMapSize) {
                            EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricName + "-BULK_GET-PARTIAL_RETRY-" + (retMap.isEmpty() ? "MISS" : "HIT"));
                        }
                    }
                    if (log.isDebugEnabled() && this.shouldLog() && retMap.size() == keys.size()) {
                        log.debug("Fallback SUCCESS for APP " + this._appName + ",  retMap [" + retMap + "]");
                    }
                }
            }
            if (retMap == null || retMap.isEmpty()) {
                if (log.isInfoEnabled() && this.shouldLog()) {
                    log.info("BULK : APP " + this._appName + " ; Full cache miss for keys : " + keys);
                }
                if (event != null) {
                    event.setAttribute("status", "BMISS_ALL");
                }
                if (retMap != null && retMap.isEmpty()) {
                    retMap = new HashMap<String, T>();
                    for (String k : keys) {
                        retMap.put(k, null);
                    }
                }
                EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-BULK_MISS");
                if (event != null) {
                    this.endEvent(event);
                }
                Map<String, T> i$ = retMap;
                return i$;
            }
            HashMap<String, T> decanonicalR = new HashMap<String, T>(canonicalKeys.size() * 4 / 3 + 1);
            for (String key : canonicalKeys) {
                String deCanKey = this.getKey(key);
                T value = retMap.get(key);
                if (value != null) {
                    decanonicalR.put(deCanKey, value);
                    if (!touch) continue;
                    this.touch(deCanKey, ttl);
                    continue;
                }
                if (fbClients == null || fbClients.size() <= 0) continue;
                decanonicalR.put(deCanKey, null);
            }
            if (!decanonicalR.isEmpty()) {
                if (decanonicalR.size() == keys.size()) {
                    this.stats.cacheHit(EVCache.Call.BULK);
                    EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-BULK_HIT");
                    if (event != null) {
                        event.setAttribute("status", "BHIT");
                    }
                } else {
                    if (event != null) {
                        event.setAttribute("status", "BHIT_PARTIAL");
                        event.setAttribute("BHIT_PARTIAL_KEYS", decanonicalR);
                    }
                    EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-BULK_HIT_PARTIAL");
                    if (log.isInfoEnabled() && this.shouldLog()) {
                        log.info("BULK_HIT_PARTIAL for APP " + this._appName + ", keys in cache [" + decanonicalR + "], all keys [" + keys + "]");
                    }
                }
            }
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("APP " + this._appName + ", BULK : Data [" + decanonicalR + "]");
            }
            if (event != null) {
                this.endEvent(event);
            }
            HashMap<String, T> hashMap = decanonicalR;
            return hashMap;
        }
        catch (CheckedOperationTimeoutException ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("CheckedOperationTimeoutException getting bulk data for APP " + this._appName + ", keys : " + canonicalKeys, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                Map<String, T> map = null;
                return map;
            }
            throw new EVCacheException("CheckedOperationTimeoutException getting bulk data for APP " + this._appName + ", keys = " + canonicalKeys + ".\nYou can set the following property to increase the timeout " + this._appName + ".EVCacheClientPool.bulkReadTimeout=<timeout in milli-seconds>", ex);
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception getting bulk data for APP " + this._appName + ", keys = " + canonicalKeys, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                Map<String, T> map = null;
                return map;
            }
            throw new EVCacheException("Exception getting bulk data for APP " + this._appName + ", keys = " + canonicalKeys, ex);
        }
        finally {
            op.stop();
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("BULK : APP " + this._appName + " Took " + op.getDuration() + " milliSec to get the value for key " + canonicalKeys);
            }
        }
    }

    @Override
    public <T> Map<String, T> getBulk(Collection<String> keys) throws EVCacheException {
        return this.getBulk(keys, this._transcoder);
    }

    @Override
    public <T> Map<String, T> getBulk(String ... keys) throws EVCacheException {
        return this.getBulk(Arrays.asList(keys), this._transcoder);
    }

    @Override
    public <T> Map<String, T> getBulk(Transcoder<T> tc, String ... keys) throws EVCacheException {
        return this.getBulk(Arrays.asList(keys), tc);
    }

    public <T> EVCacheFuture[] set(String key, T value, Transcoder<T> tc, int timeToLive) throws EVCacheException {
        EVCacheLatch latch = this.set(key, value, tc, timeToLive, null);
        if (latch == null) {
            return new EVCacheFuture[0];
        }
        List<Future<Boolean>> futures = latch.getAllFutures();
        if (futures == null || futures.isEmpty()) {
            return new EVCacheFuture[0];
        }
        EVCacheFuture[] eFutures = new EVCacheFuture[futures.size()];
        for (int i = 0; i < futures.size(); ++i) {
            Future<Boolean> future = futures.get(i);
            eFutures[i] = future instanceof EVCacheFuture ? (EVCacheFuture)future : (future instanceof EVCacheOperationFuture ? new EVCacheFuture(futures.get(i), key, this._appName, ((EVCacheOperationFuture)((Object)futures.get(i))).getServerGroup()) : new EVCacheFuture(futures.get(i), key, this._appName, null));
        }
        return eFutures;
    }

    @Override
    public <T> EVCacheLatch set(String key, T value, Transcoder<T> tc, int timeToLive, EVCacheLatch.Policy policy) throws EVCacheException {
        if (null == key || null == value) {
            throw new IllegalArgumentException();
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-NULL_CLIENT");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to set the data");
            }
            return new EVCacheLatchImpl(policy, 0, this._appName);
        }
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), Collections.singletonList(key), EVCache.Call.SET);
        if (event != null) {
            if (this.shouldThrottle(event)) {
                EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-THROTTLED");
                if (throwExc) {
                    throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                }
                return new EVCacheLatchImpl(policy, 0, this._appName);
            }
            this.startEvent(event);
        }
        String canonicalKey = this.getCanonicalizedKey(key);
        Operation op = EVCacheMetricsFactory.getOperation(this._metricName, EVCache.Call.SET, this.stats, Operation.TYPE.MILLI);
        EVCacheLatchImpl latch = new EVCacheLatchImpl(policy == null ? EVCacheLatch.Policy.ALL_MINUS_1 : policy, clients.length, this._appName);
        try {
            CachedData cd = null;
            for (EVCacheClient client : clients) {
                if (cd == null) {
                    cd = tc != null ? tc.encode(value) : client.getTranscoder().encode(value);
                    if (this.ttlSummary == null) {
                        this.ttlSummary = EVCacheConfig.getInstance().getDistributionSummary(this._appName + "-Data-TTL");
                    }
                    if (this.ttlSummary != null) {
                        this.ttlSummary.record((long)timeToLive);
                    }
                    if (cd != null) {
                        if (this.dataSizeSummary == null) {
                            this.dataSizeSummary = EVCacheConfig.getInstance().getDistributionSummary(this._appName + "-Data-Size");
                        }
                        if (this.dataSizeSummary != null) {
                            this.dataSizeSummary.record((long)cd.getData().length);
                        }
                    }
                }
                Future<Boolean> future = client.set(canonicalKey, cd, timeToLive, latch);
                if (log.isDebugEnabled() && this.shouldLog()) {
                    log.debug("SET : APP " + this._appName + ", Future " + future + " for key : " + canonicalKey);
                }
                if (!((Boolean)this._useInMemoryCache.get()).booleanValue()) continue;
                this.getInMemoryCache().put(canonicalKey, value);
            }
            if (event != null) {
                event.setCanonicalKeys(Arrays.asList(canonicalKey));
                event.setTTL(timeToLive);
                event.setCachedData(cd);
                event.setLatch(latch);
                this.endEvent(event);
            }
            EVCacheLatchImpl eVCacheLatchImpl = latch;
            return eVCacheLatchImpl;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception setting the data for APP " + this._appName + ", key : " + canonicalKey, (Throwable)ex);
            }
            if (event != null) {
                this.endEvent(event);
            }
            if (!throwExc) {
                EVCacheLatchImpl eVCacheLatchImpl = new EVCacheLatchImpl(policy, 0, this._appName);
                return eVCacheLatchImpl;
            }
            throw new EVCacheException("Exception setting data for APP " + this._appName + ", key : " + canonicalKey, ex);
        }
        finally {
            op.stop();
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("SET : APP " + this._appName + ", Took " + op.getDuration() + " milliSec for key : " + canonicalKey);
            }
        }
    }

    public <T> EVCacheFuture[] append(String key, T value) throws EVCacheException {
        return this.append(key, value, (Transcoder<T>)null);
    }

    public <T> EVCacheFuture[] append(String key, T value, Transcoder<T> tc) throws EVCacheException {
        if (null == key || null == value) {
            throw new IllegalArgumentException();
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-NULL_CLIENT");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to set the data");
            }
            return new EVCacheFuture[0];
        }
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), Collections.singletonList(key), EVCache.Call.APPEND);
        if (event != null) {
            if (this.shouldThrottle(event)) {
                EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-THROTTLED");
                if (throwExc) {
                    throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                }
                return new EVCacheFuture[0];
            }
            this.startEvent(event);
        }
        String canonicalKey = this.getCanonicalizedKey(key);
        Operation op = EVCacheMetricsFactory.getOperation(this._metricName, EVCache.Call.APPEND, this.stats, Operation.TYPE.MILLI);
        try {
            EVCacheFuture[] futures = new EVCacheFuture[clients.length];
            CachedData cd = null;
            int index = 0;
            for (EVCacheClient client : clients) {
                if (cd == null) {
                    cd = tc != null ? tc.encode(value) : client.getTranscoder().encode(value);
                }
                Future<Boolean> future = client.append(canonicalKey, cd);
                futures[index++] = new EVCacheFuture(future, key, this._appName, client.getServerGroup());
            }
            if (event != null) {
                event.setCanonicalKeys(Arrays.asList(canonicalKey));
                event.setCachedData(cd);
                this.endEvent(event);
            }
            EVCacheFuture[] eVCacheFutureArray = futures;
            return eVCacheFutureArray;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception setting the data for APP " + this._appName + ", key : " + canonicalKey, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                EVCacheFuture[] eVCacheFutureArray = new EVCacheFuture[]{};
                return eVCacheFutureArray;
            }
            throw new EVCacheException("Exception setting data for APP " + this._appName + ", key : " + canonicalKey, ex);
        }
        finally {
            op.stop();
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("APPEND : APP " + this._appName + ", Took " + op.getDuration() + " milliSec for key : " + canonicalKey);
            }
        }
    }

    public <T> EVCacheFuture[] set(String key, T value, Transcoder<T> tc) throws EVCacheException {
        return this.set(key, value, tc, this._timeToLive);
    }

    public <T> EVCacheFuture[] set(String key, T value, int timeToLive) throws EVCacheException {
        return this.set(key, value, (Transcoder<T>)this._transcoder, timeToLive);
    }

    public <T> EVCacheFuture[] set(String key, T value) throws EVCacheException {
        return this.set(key, value, (Transcoder<T>)this._transcoder, this._timeToLive);
    }

    public EVCacheFuture[] delete(String key) throws EVCacheException {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-NULL_CLIENT");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to delete the keyAPP " + this._appName + ", Key " + key);
            }
            return new EVCacheFuture[0];
        }
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), Collections.singletonList(key), EVCache.Call.DELETE);
        if (event != null) {
            if (this.shouldThrottle(event)) {
                EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-THROTTLED");
                if (throwExc) {
                    throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                }
                return new EVCacheFuture[0];
            }
            this.startEvent(event);
        }
        String canonicalKey = this.getCanonicalizedKey(key);
        if (((Boolean)this._useInMemoryCache.get()).booleanValue()) {
            this.getInMemoryCache().delete(canonicalKey);
        }
        Operation op = EVCacheMetricsFactory.getOperation(this._metricName, EVCache.Call.DELETE, this.stats);
        try {
            EVCacheFuture[] futures = new EVCacheFuture[clients.length];
            for (int i = 0; i < clients.length; ++i) {
                Future<Boolean> future = clients[i].delete(canonicalKey);
                futures[i] = new EVCacheFuture(future, key, this._appName, clients[i].getServerGroup());
            }
            if (event != null) {
                event.setCanonicalKeys(Arrays.asList(canonicalKey));
                this.endEvent(event);
            }
            EVCacheFuture[] eVCacheFutureArray = futures;
            return eVCacheFutureArray;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception while deleting the data for APP " + this._appName + ", key : " + key, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                EVCacheFuture[] eVCacheFutureArray = new EVCacheFuture[]{};
                return eVCacheFutureArray;
            }
            throw new EVCacheException("Exception while deleting the data for APP " + this._appName + ", key : " + key, ex);
        }
        finally {
            op.stop();
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("DELETE : APP " + this._appName + " Took " + op.getDuration() + " milliSec for key : " + key);
            }
        }
    }

    public int getDefaultTTL() {
        return this._timeToLive;
    }

    public String getAppName() {
        return this._appName;
    }

    public String getCacheName() {
        return this._cacheName;
    }

    @Override
    public long incr(String key, long by, long defaultVal, int timeToLive) throws EVCacheException {
        if (null == key || by < 0L || defaultVal < 0L || timeToLive < 0) {
            throw new IllegalArgumentException();
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-NULL_CLIENT");
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("INCR : " + this._metricName + ":NULL_CLIENT");
            }
            if (throwExc) {
                throw new EVCacheException("Could not find a client to incr the data");
            }
            return -1L;
        }
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), Collections.singletonList(key), EVCache.Call.INCR);
        if (event != null) {
            if (this.shouldThrottle(event)) {
                EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-THROTTLED");
                if (throwExc) {
                    throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                }
                return -1L;
            }
            this.startEvent(event);
        }
        Operation op = EVCacheMetricsFactory.getOperation(this._metricName, EVCache.Call.INCR, this.stats, Operation.TYPE.MILLI);
        try {
            long[] vals = new long[clients.length];
            String canonicalKey = this.getCanonicalizedKey(key);
            int index = 0;
            long currentValue = -1L;
            for (EVCacheClient client : clients) {
                vals[index] = client.incr(canonicalKey, by, defaultVal, timeToLive);
                if (vals[index] != -1L && currentValue < vals[index]) {
                    currentValue = vals[index];
                }
                ++index;
            }
            if (currentValue != -1L) {
                if (log.isDebugEnabled()) {
                    log.debug("INCR : APP " + this._appName + " current value = " + currentValue + " for key : " + key);
                }
                for (int i = 0; i < vals.length; ++i) {
                    if (vals[i] == -1L && currentValue > -1L) {
                        if (log.isDebugEnabled()) {
                            log.debug("INCR : APP " + this._appName + "; Zone " + clients[i].getZone() + " had a value = -1 so setting it to current value = " + currentValue + " for key : " + key);
                        }
                        clients[i].incr(canonicalKey, 0L, currentValue, timeToLive);
                        continue;
                    }
                    if (vals[i] == currentValue) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("INCR : APP " + this._appName + "; Zone " + clients[i].getZone() + " had a value of " + vals[i] + " so setting it to current value = " + currentValue + " for key : " + key);
                    }
                    clients[i].set(canonicalKey, String.valueOf(currentValue), timeToLive);
                }
            }
            if (event != null) {
                this.endEvent(event);
            }
            long l = currentValue;
            return l;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception incrementing the value for APP " + this._appName + ", key : " + key, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                long l = -1L;
                return l;
            }
            throw new EVCacheException("Exception incrementing value for APP " + this._appName + ", key : " + key, ex);
        }
        finally {
            op.stop();
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("INCR : APP " + this._appName + ", Took " + op.getDuration() + " milliSec for key : " + key);
            }
        }
    }

    @Override
    public long decr(String key, long by, long defaultVal, int timeToLive) throws EVCacheException {
        if (null == key || by < 0L || defaultVal < 0L || timeToLive < 0) {
            throw new IllegalArgumentException();
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-NULL_CLIENT");
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("DECR : " + this._metricName + ":NULL_CLIENT");
            }
            if (throwExc) {
                throw new EVCacheException("Could not find a client to decr the data");
            }
            return -1L;
        }
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), Collections.singletonList(key), EVCache.Call.DECR);
        if (event != null) {
            if (this.shouldThrottle(event)) {
                EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-THROTTLED");
                if (throwExc) {
                    throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                }
                return -1L;
            }
            this.startEvent(event);
        }
        Operation op = EVCacheMetricsFactory.getOperation(this._metricName, EVCache.Call.DECR, this.stats, Operation.TYPE.MILLI);
        try {
            long[] vals = new long[clients.length];
            String canonicalKey = this.getCanonicalizedKey(key);
            int index = 0;
            long currentValue = -1L;
            for (EVCacheClient client : clients) {
                vals[index] = client.decr(canonicalKey, by, defaultVal, timeToLive);
                if (vals[index] != -1L && currentValue < vals[index]) {
                    currentValue = vals[index];
                }
                ++index;
            }
            if (currentValue != -1L) {
                if (log.isDebugEnabled()) {
                    log.debug("DECR : APP " + this._appName + " current value = " + currentValue + " for key : " + key);
                }
                for (int i = 0; i < vals.length; ++i) {
                    if (vals[i] == -1L && currentValue > -1L) {
                        if (log.isDebugEnabled()) {
                            log.debug("DECR : APP " + this._appName + "; Zone " + clients[i].getZone() + " had a value = -1 so setting it to current value = " + currentValue + " for key : " + key);
                        }
                        clients[i].decr(canonicalKey, 0L, currentValue, timeToLive);
                        continue;
                    }
                    if (vals[i] == currentValue) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("DECR : APP " + this._appName + "; Zone " + clients[i].getZone() + " had a value of " + vals[i] + " so setting it to current value = " + currentValue + " for key : " + key);
                    }
                    clients[i].set(canonicalKey, String.valueOf(currentValue), timeToLive);
                }
            }
            if (event != null) {
                this.endEvent(event);
            }
            long l = currentValue;
            return l;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception decrementing the value for APP " + this._appName + ", key : " + key, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                long l = -1L;
                return l;
            }
            throw new EVCacheException("Exception decrementing value for APP " + this._appName + ", key : " + key, ex);
        }
        finally {
            op.stop();
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("DECR : APP " + this._appName + ", Took " + op.getDuration() + " milliSec for key : " + key);
            }
        }
    }

    @Override
    public <T> Observable<T> get(String key, Map<String, Object> requestProperties) throws EVCacheException {
        return this.observeGet(key, Schedulers.computation());
    }

    @Override
    public <T> Observable<T> observeGet(String key) throws EVCacheException {
        return this.observeGet(key, Schedulers.computation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Observable<T> observeGet(final String key, final Scheduler scheduler) {
        if (this.observeGetCounter == null) {
            this.observeGetCounter = EVCacheMetricsFactory.getCounter(this._appName, this._cacheName, this._metricPrefix + "-ObservableGet", (Tag)DataSourceType.COUNTER);
        }
        if (this.observeGetCounter != null) {
            this.observeGetCounter.increment();
        }
        Observable observable = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            public void call(final Subscriber<? super T> subscriber) {
                try {
                    EVCacheImpl.this.get(key, EVCacheImpl.this._transcoder, new EVCacheGetOperationListener<T>(){

                        public void onComplete(final EVCacheOperationFuture<T> future) throws Exception {
                            scheduler.createWorker().schedule(new Action0(){

                                public void call() {
                                    if (future.isCancelled()) {
                                        EVCacheMetricsFactory.getCounter(EVCacheImpl.this._appName, EVCacheImpl.this._cacheName, EVCacheImpl.this._metricPrefix + "-ObservableGet-CANCELLED", (Tag)DataSourceType.COUNTER).increment();
                                        if (EVCacheImpl.this.doThrowException()) {
                                            subscriber.onError((Throwable)new EVCacheException("Cancelled"));
                                        } else {
                                            subscriber.onNext(null);
                                            subscriber.onCompleted();
                                        }
                                    } else {
                                        try {
                                            Object value = future.get();
                                            if (value == null && EVCacheImpl.this.doThrowException()) {
                                                EVCacheMetricsFactory.getCounter(EVCacheImpl.this._appName, EVCacheImpl.this._cacheName, EVCacheImpl.this._metricPrefix + "-ObservableGetMiss", (Tag)DataSourceType.COUNTER).increment();
                                                subscriber.onError((Throwable)new EVCacheMissException("CacheMiss"));
                                            } else {
                                                EVCacheMetricsFactory.getCounter(EVCacheImpl.this._appName, EVCacheImpl.this._cacheName, EVCacheImpl.this._metricPrefix + "-ObservableGetHit", (Tag)DataSourceType.COUNTER).increment();
                                                subscriber.onNext(value);
                                                subscriber.onCompleted();
                                            }
                                        }
                                        catch (Exception e) {
                                            EVCacheMetricsFactory.getCounter(EVCacheImpl.this._appName, EVCacheImpl.this._cacheName, EVCacheImpl.this._metricPrefix + "-ObservableGet-ERROR", (Tag)DataSourceType.COUNTER).increment();
                                            subscriber.onError(e.getCause());
                                        }
                                    }
                                }
                            });
                        }
                    });
                }
                catch (EVCacheException e) {
                    EVCacheMetricsFactory.getCounter(EVCacheImpl.this._appName, EVCacheImpl.this._cacheName, EVCacheImpl.this._metricPrefix + "-ObservableGet-ERROR", (Tag)DataSourceType.COUNTER);
                    if (EVCacheImpl.this.doThrowException()) {
                        subscriber.onError(e.getCause());
                    }
                    subscriber.onNext(null);
                    subscriber.onCompleted();
                }
            }
        });
        return observable;
    }

    @Override
    public <T> EVCacheLatch replace(String key, T value, EVCacheLatch.Policy policy) throws EVCacheException {
        return this.replace(key, value, this._transcoder, policy);
    }

    @Override
    public <T> EVCacheLatch replace(String key, T value, Transcoder<T> tc, EVCacheLatch.Policy policy) throws EVCacheException {
        return this.replace(key, value, this._transcoder, this._timeToLive, policy);
    }

    @Override
    public <T> EVCacheLatch replace(String key, T value, Transcoder<T> tc, int timeToLive, EVCacheLatch.Policy policy) throws EVCacheException {
        if (null == key || null == value) {
            throw new IllegalArgumentException();
        }
        boolean throwExc = this.doThrowException();
        EVCacheClient[] clients = this._pool.getEVCacheClientForWrite();
        if (clients.length == 0) {
            EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-NULL_CLIENT");
            if (throwExc) {
                throw new EVCacheException("Could not find a client to set the data");
            }
            return new EVCacheLatchImpl(policy, 0, this._appName);
        }
        EVCacheEvent event = this.createEVCacheEvent(Arrays.asList(clients), Collections.singletonList(key), EVCache.Call.REPLACE);
        if (event != null) {
            if (this.shouldThrottle(event)) {
                EVCacheMetricsFactory.increment(this._appName, this._cacheName, this._metricPrefix + "-THROTTLED");
                if (throwExc) {
                    throw new EVCacheException("Request Throttled for app " + this._appName + " & key " + key);
                }
                return new EVCacheLatchImpl(policy, 0, this._appName);
            }
            this.startEvent(event);
        }
        String canonicalKey = this.getCanonicalizedKey(key);
        Operation op = EVCacheMetricsFactory.getOperation(this._metricName, EVCache.Call.REPLACE, this.stats, Operation.TYPE.MILLI);
        EVCacheLatchImpl latch = new EVCacheLatchImpl(policy == null ? EVCacheLatch.Policy.ALL_MINUS_1 : policy, clients.length, this._appName);
        try {
            EVCacheFuture[] futures = new EVCacheFuture[clients.length];
            CachedData cd = null;
            int index = 0;
            for (EVCacheClient client : clients) {
                if (cd == null) {
                    cd = tc != null ? tc.encode(value) : client.getTranscoder().encode(value);
                    if (this.ttlSummary == null) {
                        this.ttlSummary = EVCacheConfig.getInstance().getDistributionSummary(this._appName + "-Data-TTL");
                    }
                    if (this.ttlSummary != null) {
                        this.ttlSummary.record((long)timeToLive);
                    }
                    if (cd != null) {
                        if (this.dataSizeSummary == null) {
                            this.dataSizeSummary = EVCacheConfig.getInstance().getDistributionSummary(this._appName + "-Data-Size");
                        }
                        if (this.dataSizeSummary != null) {
                            this.dataSizeSummary.record((long)cd.getData().length);
                        }
                    }
                }
                Future<Boolean> future = client.replace(canonicalKey, cd, timeToLive, latch);
                futures[index++] = new EVCacheFuture(future, key, this._appName, client.getServerGroup());
                if (!((Boolean)this._useInMemoryCache.get()).booleanValue()) continue;
                this.getInMemoryCache().put(canonicalKey, value);
            }
            if (event != null) {
                event.setCanonicalKeys(Arrays.asList(canonicalKey));
                event.setTTL(timeToLive);
                event.setCachedData(cd);
                event.setLatch(latch);
                this.endEvent(event);
            }
            EVCacheLatchImpl eVCacheLatchImpl = latch;
            return eVCacheLatchImpl;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("Exception setting the data for APP " + this._appName + ", key : " + canonicalKey, (Throwable)ex);
            }
            if (event != null) {
                this.eventError(event, ex);
            }
            if (!throwExc) {
                EVCacheLatchImpl eVCacheLatchImpl = new EVCacheLatchImpl(policy, 0, this._appName);
                return eVCacheLatchImpl;
            }
            throw new EVCacheException("Exception setting data for APP " + this._appName + ", key : " + canonicalKey, ex);
        }
        finally {
            op.stop();
            if (log.isDebugEnabled() && this.shouldLog()) {
                log.debug("REPLACE : APP " + this._appName + ", Took " + op.getDuration() + " milliSec for key : " + canonicalKey);
            }
        }
    }
}

