/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool.standalone;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.standalone.AbstractEVCacheClientPoolImpl;
import com.netflix.evcache.pool.standalone.SimpleEVCacheClientImpl;
import com.netflix.evcache.pool.standalone.SimpleEVCacheClientPoolImplMBean;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleEVCacheClientPoolImpl
extends AbstractEVCacheClientPoolImpl
implements SimpleEVCacheClientPoolImplMBean {
    private static Logger log = LoggerFactory.getLogger(SimpleEVCacheClientPoolImpl.class);
    private DynamicStringProperty _serverList;
    private List<EVCacheClient> memcachedInstances;

    @Override
    public void init(String appName) {
        block2: {
            super.init(appName);
            this._serverList = DynamicPropertyFactory.getInstance().getStringProperty(appName + ".EVCacheClientPool.hosts", "");
            this._serverList.addCallback((Runnable)this);
            int size = this.getPoolSize().get() < 0 ? 1 : this.getPoolSize().get();
            this.memcachedInstances = new ArrayList<EVCacheClient>(size);
            try {
                this.refresh();
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Error Refreshing EVCache Instance list for " + appName, t);
            }
        }
    }

    @Override
    public EVCacheClient getEVCacheClient() {
        if (this.memcachedInstances == null || this.memcachedInstances.isEmpty()) {
            return null;
        }
        try {
            if (this.memcachedInstances.size() == 1) {
                return this.memcachedInstances.get(0);
            }
            long currentVal = this.getNumOfOps().incrementAndGet();
            int index = (int)currentVal % this.memcachedInstances.size();
            return this.memcachedInstances.get(index);
        }
        catch (Throwable t) {
            log.error("Exception trying to get an readable EVCache Instance.", t);
            return null;
        }
    }

    private List<InetSocketAddress> getMemcachedSocketAddressList(List<String> discoveredHostsInZone) {
        ArrayList<InetSocketAddress> memcachedNodesInZone = new ArrayList<InetSocketAddress>(discoveredHostsInZone.size());
        for (String hostAddress : discoveredHostsInZone) {
            int colonIndex = hostAddress.lastIndexOf(58);
            String hostName = hostAddress.substring(0, colonIndex);
            String portNum = hostAddress.substring(colonIndex + 1);
            memcachedNodesInZone.add(new InetSocketAddress(hostName, Integer.parseInt(portNum)));
        }
        return memcachedNodesInZone;
    }

    private void setupNewClients(List<EVCacheClient> newClients) {
        List<EVCacheClient> currentClients = this.memcachedInstances;
        this.memcachedInstances = newClients;
        if (currentClients == null || currentClients.isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Replaced an existing Pool for app " + this.getAppName() + " ;\n\tOldClients : " + currentClients + ";\n\tNewClients : " + newClients);
        }
        for (EVCacheClient client : currentClients) {
            if (client.isShutdown()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Shutting down in Fallback -> AppName : " + this.getAppName() + "; client {" + client + "};");
            }
            try {
                if (client.getConnectionObserver() != null) {
                    boolean obsRemoved = client.removeConnectionObserver();
                    if (log.isDebugEnabled()) {
                        log.debug("Connection observer removed " + obsRemoved);
                    }
                }
                boolean status = client.shutdown(60L, TimeUnit.SECONDS);
                if (!log.isDebugEnabled()) continue;
                log.debug("Shutting down {" + client + "} ; status : " + status);
            }
            catch (Exception ex) {
                log.error("Exception while shutting down the old Client", (Throwable)ex);
            }
        }
    }

    private synchronized void refresh() throws IOException {
        try {
            List<String> instances = this.discoverInstances();
            if (instances == null || instances.isEmpty()) {
                return;
            }
            List<InetSocketAddress> memInstances = this.getMemcachedSocketAddressList(instances);
            int poolSize = this.getPoolSize().get();
            ArrayList<EVCacheClient> newClients = new ArrayList<EVCacheClient>(poolSize);
            for (int i = 0; i < poolSize; ++i) {
                int maxQueueSize = ConfigurationManager.getConfigInstance().getInt(this.getAppName() + ".max.queue.length", 16384);
                SimpleEVCacheClientImpl client = new SimpleEVCacheClientImpl(this.getAppName(), i, maxQueueSize, this.getReadTimeout(), memInstances);
                newClients.add(client);
                if (!log.isDebugEnabled()) continue;
                log.debug("AppName :" + this.getAppName() + "; intit : client.getId() : " + client.getId());
            }
            this.setupNewClients(newClients);
        }
        catch (Throwable t) {
            log.error("Exception while refreshing the Server list", t);
        }
    }

    private List<String> discoverInstances() throws IOException {
        if (this.isShutdown()) {
            return Collections.emptyList();
        }
        ArrayList<String> instances = new ArrayList<String>();
        String serverList = this._serverList.get();
        StringTokenizer stk = new StringTokenizer(serverList, ",");
        while (stk.hasMoreTokens()) {
            String memcachedPort;
            String memcachedHost;
            String token = stk.nextToken();
            int index = token.indexOf(":");
            if (index == -1) {
                memcachedHost = token;
                memcachedPort = "11211";
            } else {
                memcachedHost = token.substring(0, index);
                memcachedPort = token.substring(index + 1);
            }
            instances.add(memcachedHost + ":" + memcachedPort);
        }
        return instances;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        for (EVCacheClient client : this.memcachedInstances) {
            this.shutdownClient(client);
        }
    }

    @Override
    @Monitor(name="Instances", type=DataSourceType.COUNTER)
    public int getInstanceCount() {
        if (this.memcachedInstances.size() == 0) {
            return 0;
        }
        return this.memcachedInstances.get(0).getConnectionObserver().getActiveServerCount();
    }

    @Override
    public List<String> getInstances() {
        ArrayList<String> instanceList = new ArrayList<String>(this.memcachedInstances.size());
        for (EVCacheClient client : this.memcachedInstances) {
            instanceList.add(client.toString());
        }
        return instanceList;
    }

    @Override
    public void refreshPool() {
        block2: {
            try {
                this.refresh();
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Error Refreshing EVCache Instance list from MBean : " + this.getAppName(), t);
            }
        }
    }

    @Override
    public EVCacheClient getEVCacheClientExcludeZone(String zone) {
        return this.getEVCacheClient();
    }

    @Override
    public EVCacheClient[] getAllEVCacheClients() {
        EVCacheClient[] clientArr = new EVCacheClient[]{this.getEVCacheClient()};
        return clientArr;
    }

    @Override
    public void run() {
        block2: {
            try {
                this.refresh();
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Error Refreshing EVCache Instance list for " + this.getAppName(), t);
            }
        }
    }

    @Override
    public boolean supportsFallback() {
        return false;
    }

    @Override
    public int getClusterSize() {
        return 1;
    }

    @Override
    public String toString() {
        return "SimpleEVCacheClientPoolImpl [" + super.toString() + ", _serverList=" + this._serverList + ", memcachedInstances=" + this.memcachedInstances + "]";
    }
}

