/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool.eureka.connection;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.shared.Application;
import java.net.InetSocketAddress;
import java.util.List;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.util.DefaultKetamaNodeLocatorConfiguration;

public class EVCacheKetamaNodeLocatorConfiguration
extends DefaultKetamaNodeLocatorConfiguration {
    private final String appName;

    public EVCacheKetamaNodeLocatorConfiguration(String appName) {
        this.appName = appName;
    }

    protected String getSocketAddressForNode(MemcachedNode node) {
        String result = (String)this.socketAddresses.get(node);
        if (result == null) {
            if (node.getSocketAddress() instanceof InetSocketAddress) {
                InetSocketAddress isa = (InetSocketAddress)node.getSocketAddress();
                Application app = DiscoveryManager.getInstance().getDiscoveryClient().getApplication(this.appName);
                if (null == app) {
                    throw new IllegalStateException("No instances found for registered application");
                }
                List instances = app.getInstances();
                for (InstanceInfo info : instances) {
                    if (!info.getHostName().equalsIgnoreCase(isa.getHostName())) continue;
                    String hostName = info.getHostName();
                    String ip = info.getIPAddr();
                    String port = (String)info.getMetadata().get("evcache.port");
                    result = hostName + '/' + ip + ':' + (port != null ? port : "11211");
                    break;
                }
            } else {
                result = String.valueOf(node.getSocketAddress());
                if (result.startsWith("/")) {
                    result = result.substring(1);
                }
            }
            this.socketAddresses.put(node, result);
        }
        return result;
    }
}

