/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool.eureka.connection;

import com.netflix.evcache.pool.eureka.connection.EVCacheKetamaNodeLocatorConfiguration;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.KetamaNodeLocator;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.util.KetamaNodeLocatorConfiguration;

public class EVCacheConnectionFactory
extends BinaryConnectionFactory {
    private final String appName;
    private final String zone;
    private final int id;

    public EVCacheConnectionFactory(String appName, String zone, int id, int len) {
        super(len, 16384, (HashAlgorithm)DefaultHashAlgorithm.KETAMA_HASH);
        this.appName = appName;
        this.zone = zone;
        this.id = id;
    }

    public NodeLocator createLocator(List<MemcachedNode> list) {
        return new KetamaNodeLocator(list, (HashAlgorithm)DefaultHashAlgorithm.KETAMA_HASH, (KetamaNodeLocatorConfiguration)new EVCacheKetamaNodeLocatorConfiguration(this.appName));
    }

    public MemcachedConnection createConnection(List<InetSocketAddress> addrs) throws IOException {
        MemcachedConnection connection = new MemcachedConnection(this.getReadBufSize(), (ConnectionFactory)this, addrs, this.getInitialObservers(), this.getFailureMode(), this.getOperationFactory());
        connection.setName(this.appName + "-" + this.zone + "-" + this.id);
        return connection;
    }
}

