/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.pool;

import com.netflix.config.DynamicIntProperty;
import com.netflix.evcache.EVCacheTranscoder;
import com.netflix.evcache.pool.EVCacheClient;
import com.netflix.evcache.pool.observer.EVCacheConnectionObserver;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.CASValue;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedClient;

public abstract class AbstractEVCacheClientImpl
implements EVCacheClient {
    protected final ConnectionFactory connectionFactory;
    protected final int id;
    protected final String appName;
    protected final String zone;
    protected final DynamicIntProperty readTimeout;
    protected boolean shutdown;
    protected MemcachedClient client;

    protected AbstractEVCacheClientImpl(String appName, String zone, int id, int maxQueueSize, DynamicIntProperty readTimeout) {
        this(appName, zone, id, readTimeout, (ConnectionFactory)new BinaryConnectionFactory(maxQueueSize, 16384, (HashAlgorithm)DefaultHashAlgorithm.KETAMA_HASH));
    }

    protected AbstractEVCacheClientImpl(String appName, String zone, int id, DynamicIntProperty readTimeout, ConnectionFactory connectionFactory) {
        this.id = id;
        this.appName = appName;
        this.zone = zone;
        this.readTimeout = readTimeout;
        this.connectionFactory = connectionFactory;
    }

    @Override
    public boolean shutdown(long timeout, TimeUnit unit) {
        this.shutdown = true;
        return this.client.shutdown(timeout, unit);
    }

    @Override
    public <T> T get(String key, EVCacheTranscoder<T> tc) throws Exception {
        return this.asyncGet(key, tc).get(this.readTimeout.get(), TimeUnit.MILLISECONDS);
    }

    @Override
    public <T> T getAndTouch(String key, EVCacheTranscoder<T> tc, int timeToLive) throws Exception {
        CASValue value = tc == null ? (CASValue)this.client.asyncGetAndTouch(key, timeToLive).get((long)this.readTimeout.get(), TimeUnit.MILLISECONDS) : (CASValue)this.client.asyncGetAndTouch(key, timeToLive, tc).get((long)this.readTimeout.get(), TimeUnit.MILLISECONDS);
        return (T)(value == null ? null : value.getValue());
    }

    @Override
    public <T> Future<CASValue<T>> asyncGetAndTouch(String key, EVCacheTranscoder<T> tc, int timeToLive) throws Exception {
        if (tc == null) {
            return this.client.asyncGetAndTouch(key, timeToLive, this.client.getTranscoder());
        }
        return this.client.asyncGetAndTouch(key, timeToLive, tc);
    }

    @Override
    public Future<Boolean> touch(String key, int timeToLive) throws Exception {
        return this.client.touch(key, timeToLive);
    }

    @Override
    public <T> Future<Boolean> set(String key, EVCacheTranscoder<T> tc, T value, int timeToLive) throws Exception {
        if (tc == null) {
            return this.client.set(key, timeToLive, value);
        }
        return this.client.set(key, timeToLive, value, tc);
    }

    @Override
    public <T> Future<T> asyncGet(String key, EVCacheTranscoder<T> tc) throws Exception {
        if (tc == null) {
            return this.client.asyncGet(key);
        }
        return this.client.asyncGet(key, tc);
    }

    @Override
    public <T> Map<String, T> getBulk(Collection<String> canonicalKeys, EVCacheTranscoder<T> tc) throws Exception {
        if (tc == null) {
            return (Map)this.client.asyncGetBulk(canonicalKeys).get((long)this.readTimeout.get(), TimeUnit.MILLISECONDS);
        }
        return (Map)this.client.asyncGetBulk(canonicalKeys, tc).get((long)this.readTimeout.get(), TimeUnit.MILLISECONDS);
    }

    @Override
    public Future<Boolean> delete(String key) throws Exception {
        return this.client.delete(key);
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public String getZone() {
        return this.zone;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public Map<SocketAddress, Map<String, String>> getStats(String cmd) {
        return this.client.getStats(cmd);
    }

    @Override
    public Map<SocketAddress, String> getVersions() {
        return this.client.getVersions();
    }

    @Override
    public boolean removeConnectionObserver() {
        return true;
    }

    @Override
    public EVCacheConnectionObserver getConnectionObserver() {
        return null;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout.get();
    }

    public String toString() {
        return "connectionFactory=" + this.connectionFactory.toString() + ", client=" + this.client.toString() + ", shutdown=" + this.shutdown + ", id=" + this.id + ", appName=" + this.appName + ", zone=" + this.zone;
    }
}

