/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache;

import com.netflix.evcache.EVCacheException;
import com.netflix.evcache.EVCacheImpl;
import com.netflix.evcache.EVCacheTranscoder;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Future;

public interface EVCache {
    public <T> Future<Boolean>[] set(String var1, T var2) throws EVCacheException;

    public <T> Future<Boolean>[] set(String var1, T var2, int var3) throws EVCacheException;

    public <T> Future<Boolean>[] set(String var1, T var2, EVCacheTranscoder<T> var3) throws EVCacheException;

    public <T> Future<Boolean>[] set(String var1, T var2, EVCacheTranscoder<T> var3, int var4) throws EVCacheException;

    public Future<Boolean>[] delete(String var1) throws EVCacheException;

    public <T> T get(String var1) throws EVCacheException;

    public <T> T get(String var1, EVCacheTranscoder<T> var2) throws EVCacheException;

    public <T> T getAndTouch(String var1, int var2) throws EVCacheException;

    public <T> T getAndTouch(String var1, int var2, EVCacheTranscoder<T> var3) throws EVCacheException;

    public <T> Map<String, T> getBulk(String ... var1) throws EVCacheException;

    public <T> Map<String, T> getBulk(EVCacheTranscoder<T> var1, String ... var2) throws EVCacheException;

    public <T> Map<String, T> getBulk(Collection<String> var1) throws EVCacheException;

    public <T> Map<String, T> getBulk(Collection<String> var1, EVCacheTranscoder<T> var2) throws EVCacheException;

    public <T> Future<T> getAsynchronous(String var1) throws EVCacheException;

    public <T> Future<T> getAsynchronous(String var1, EVCacheTranscoder<T> var2) throws EVCacheException;

    public static class Builder {
        public static final int DEFAULT_TTL = 900;
        private String appName;
        private String cacheName;
        private int ttl = 900;
        private EVCacheTranscoder<?> transcoder;
        private boolean zoneFallback = false;

        public Builder setAppName(String pAppName) {
            if (pAppName == null) {
                throw new IllegalArgumentException("param pAppName cannot be null.");
            }
            this.appName = pAppName.toUpperCase();
            return this;
        }

        public Builder setCacheName(String pCacheName) {
            if (pCacheName != null) {
                if (pCacheName.indexOf(58) != -1) {
                    throw new IllegalArgumentException("param pCacheName cannot contain ':' character");
                }
                for (char ch : pCacheName.toCharArray()) {
                    if (!Character.isWhitespace(ch)) continue;
                    throw new IllegalArgumentException("param pCacheName cannot contain an illegal character '" + ch + "'");
                }
            }
            this.cacheName = pCacheName;
            return this;
        }

        public Builder setDefaultTTL(int pttl) {
            if (pttl < 0) {
                throw new IllegalArgumentException("Time to Live cannot be less than 0.");
            }
            this.ttl = pttl;
            return this;
        }

        public <T> Builder setTranscoder(EVCacheTranscoder<T> pTranscoder) {
            this.transcoder = pTranscoder;
            return this;
        }

        public <T> Builder enableZoneFallback() {
            this.zoneFallback = true;
            return this;
        }

        public EVCache build() {
            if (this.appName == null) {
                throw new IllegalArgumentException("param appName cannot be null.");
            }
            EVCacheImpl cache = new EVCacheImpl(this.appName, this.cacheName, this.ttl, this.transcoder, this.zoneFallback);
            return cache;
        }
    }
}

