/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.evcache.sample;

import com.netflix.evcache.EVCache;
import com.netflix.evcache.EVCacheException;
import java.util.concurrent.Future;

public class EVCacheClientSample {
    private final EVCache evCache;
    private final String key = "evcacheSample";
    private final String value = " This is my value1";
    private final int timeToLive = 100;

    public EVCacheClientSample() {
        System.setProperty("EVCACHE_APP1.use.simple.node.list.provider", "true");
        System.setProperty("EVCACHE_APP1-NODES", "SERVERGROUP1=localhost:11211;SERVERGROUP2=localhost:11212");
        this.evCache = new EVCache.Builder().setAppName("EVCACHE_APP1").build();
    }

    public void setKey() throws Exception {
        try {
            Future[] _future;
            for (Future f : _future = this.evCache.set("evcacheSample", (Object)" This is my value1", 100)) {
                System.out.println("set key evcacheSample is successful" + f.get());
            }
        }
        catch (EVCacheException e) {
            e.printStackTrace();
        }
    }

    public String getKey() {
        try {
            String _response = (String)this.evCache.get("evcacheSample");
            return _response;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            EVCacheClientSample evCacheClientSample = new EVCacheClientSample();
            evCacheClientSample.setKey();
            Thread.sleep(1000L);
            System.out.println(" Key returned is >> " + evCacheClientSample.getKey());
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

