/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.resolver.aws;

import com.netflix.discovery.endpoint.DnsResolver;
import com.netflix.discovery.shared.resolver.ClusterResolver;
import com.netflix.discovery.shared.resolver.ClusterResolverException;
import com.netflix.discovery.shared.resolver.ResolverUtils;
import com.netflix.discovery.shared.resolver.aws.AwsEndpoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsTxtRecordClusterResolver
implements ClusterResolver<AwsEndpoint> {
    private static final Logger logger = LoggerFactory.getLogger(DnsTxtRecordClusterResolver.class);
    private final String region;
    private final String rootClusterDNS;
    private final boolean extractZoneFromDNS;
    private final int port;
    private final boolean isSecure;
    private final String relativeUri;

    public DnsTxtRecordClusterResolver(String region, String rootClusterDNS, boolean extractZoneFromDNS, int port, boolean isSecure, String relativeUri) {
        this.region = region;
        this.rootClusterDNS = rootClusterDNS;
        this.extractZoneFromDNS = extractZoneFromDNS;
        this.port = port;
        this.isSecure = isSecure;
        this.relativeUri = relativeUri;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public List<AwsEndpoint> getClusterEndpoints() {
        List<AwsEndpoint> eurekaEndpoints = DnsTxtRecordClusterResolver.resolve(this.region, this.rootClusterDNS, this.extractZoneFromDNS, this.port, this.isSecure, this.relativeUri);
        if (logger.isDebugEnabled()) {
            logger.debug("Resolved {} to {}", (Object)this.rootClusterDNS, eurekaEndpoints);
        }
        return eurekaEndpoints;
    }

    private static List<AwsEndpoint> resolve(String region, String rootClusterDNS, boolean extractZone, int port, boolean isSecure, String relativeUri) {
        try {
            Set<String> zoneDomainNames = DnsTxtRecordClusterResolver.resolve(rootClusterDNS);
            if (zoneDomainNames.isEmpty()) {
                throw new ClusterResolverException("Cannot resolve Eureka cluster addresses; there are no data in TXT record for DN " + rootClusterDNS);
            }
            ArrayList<AwsEndpoint> endpoints = new ArrayList<AwsEndpoint>();
            for (String zoneDomain : zoneDomainNames) {
                String zone = extractZone ? ResolverUtils.extractZoneFromHostName(zoneDomain) : null;
                Set<String> zoneAddresses = DnsTxtRecordClusterResolver.resolve(zoneDomain);
                for (String address : zoneAddresses) {
                    endpoints.add(new AwsEndpoint(address, port, isSecure, relativeUri, region, zone));
                }
            }
            return endpoints;
        }
        catch (NamingException e) {
            throw new ClusterResolverException("Cannot resolve Eureka cluster addresses", e);
        }
    }

    private static Set<String> resolve(String rootClusterDNS) throws NamingException {
        Set<String> result;
        try {
            result = DnsResolver.getCNamesFromTxtRecord(rootClusterDNS);
            if (!rootClusterDNS.startsWith("txt.")) {
                result = DnsResolver.getCNamesFromTxtRecord("txt." + rootClusterDNS);
            }
        }
        catch (NamingException e) {
            if (!rootClusterDNS.startsWith("txt.")) {
                result = DnsResolver.getCNamesFromTxtRecord("txt." + rootClusterDNS);
            }
            throw e;
        }
        return result;
    }
}

