/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.provider;

import com.netflix.discovery.converters.wrappers.CodecWrappers;
import com.netflix.discovery.converters.wrappers.DecoderWrapper;
import com.netflix.discovery.converters.wrappers.EncoderWrapper;
import com.netflix.discovery.provider.ISerializer;
import com.netflix.discovery.provider.Serializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"*/*"})
@Consumes(value={"*/*"})
public class DiscoveryJerseyProvider
implements MessageBodyWriter,
MessageBodyReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscoveryJerseyProvider.class);
    private static ConcurrentHashMap<Class, ISerializer> serializers = new ConcurrentHashMap();
    private final EncoderWrapper encoder;
    private final DecoderWrapper decoder;

    public DiscoveryJerseyProvider() {
        this(null, null);
    }

    public DiscoveryJerseyProvider(EncoderWrapper encoder, DecoderWrapper decoder) {
        this.encoder = encoder == null ? CodecWrappers.getEncoder(CodecWrappers.JacksonJson.class) : encoder;
        DecoderWrapper decoderWrapper = this.decoder = decoder == null ? CodecWrappers.getDecoder(CodecWrappers.JacksonJson.class) : decoder;
        if (encoder instanceof CodecWrappers.JacksonJsonMini) {
            throw new UnsupportedOperationException("Encoder: " + encoder.codecName() + "is not supported for the client");
        }
        LOGGER.info("Using encoding codec {}", (Object)this.encoder.codecName());
        LOGGER.info("Using decoding codec {}", (Object)this.decoder.codecName());
    }

    public EncoderWrapper getEncoder() {
        return this.encoder;
    }

    public DecoderWrapper getDecoder() {
        return this.decoder;
    }

    public boolean isReadable(Class serializableClass, Type type, Annotation[] annotations, MediaType mediaType) {
        if ("application".equals(mediaType.getType()) && ("xml".equals(mediaType.getSubtype()) || "json".equals(mediaType.getSubtype()))) {
            return this.checkForAnnotation(serializableClass);
        }
        return false;
    }

    public Object readFrom(Class serializableClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap headers, InputStream inputStream) throws IOException {
        if (this.decoder.support(mediaType)) {
            try {
                return this.decoder.decode(inputStream, serializableClass);
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    DiscoveryJerseyProvider.closeInputOnError(inputStream);
                    throw new WebApplicationException(DiscoveryJerseyProvider.createErrorReply(500, e, mediaType));
                }
                LOGGER.debug("Cannot parse request body", e);
                throw new WebApplicationException(DiscoveryJerseyProvider.createErrorReply(400, "cannot parse request body", mediaType));
            }
        }
        ISerializer serializer = DiscoveryJerseyProvider.getSerializer(serializableClass);
        if (null != serializer) {
            try {
                return serializer.read(inputStream, serializableClass, mediaType);
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    DiscoveryJerseyProvider.closeInputOnError(inputStream);
                    throw new WebApplicationException(DiscoveryJerseyProvider.createErrorReply(500, e, mediaType));
                }
                LOGGER.debug("Cannot parse request body", e);
                throw new WebApplicationException(DiscoveryJerseyProvider.createErrorReply(400, "cannot parse request body", mediaType));
            }
        }
        LOGGER.error("No serializer available for serializable class: {}, de-serialization will fail.", (Object)serializableClass);
        throw new WebApplicationException(DiscoveryJerseyProvider.createErrorReply(500, "No serializer available for serializable class: " + serializableClass, mediaType));
    }

    public long getSize(Object serializableObject, Class serializableClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class serializableClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return this.checkForAnnotation(serializableClass);
    }

    public void writeTo(Object serializableObject, Class serializableClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap headers, OutputStream outputStream) throws IOException, WebApplicationException {
        if (this.encoder.support(mediaType)) {
            this.encoder.encode(serializableObject, outputStream);
        } else {
            ISerializer serializer = DiscoveryJerseyProvider.getSerializer(serializableClass);
            if (null != serializer) {
                serializer.write(serializableObject, outputStream, mediaType);
            } else {
                LOGGER.error("No serializer available for serializable class: " + serializableClass + ", serialization will fail.");
                throw new IOException("No serializer available for serializable class: " + serializableClass);
            }
        }
    }

    private boolean checkForAnnotation(Class serializableClass) {
        try {
            Serializer annotation = serializableClass.getAnnotation(Serializer.class);
            if (annotation != null) {
                return true;
            }
        }
        catch (Throwable th) {
            LOGGER.warn("Exception in checking for annotations", th);
        }
        return false;
    }

    @Nullable
    private static ISerializer getSerializer(Class serializableClass) {
        Serializer payloadConverter;
        String serializer;
        ISerializer converter = null;
        Serializer annotation = serializableClass.getAnnotation(Serializer.class);
        if (annotation != null && (serializer = (payloadConverter = annotation).value()) != null && (converter = serializers.get(serializableClass)) == null) {
            try {
                converter = (ISerializer)Class.forName(serializer).newInstance();
            }
            catch (InstantiationException e) {
                LOGGER.error("Error creating a serializer.", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Error creating a serializer.", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Error creating a serializer.", (Throwable)e);
            }
            if (null != converter) {
                serializers.put(serializableClass, converter);
            }
        }
        return converter;
    }

    private static Response createErrorReply(int status, Throwable cause, MediaType mediaType) {
        StringBuilder sb = new StringBuilder(cause.getClass().getName());
        if (cause.getMessage() != null) {
            sb.append(": ").append(cause.getMessage());
        }
        return DiscoveryJerseyProvider.createErrorReply(status, sb.toString(), mediaType);
    }

    private static Response createErrorReply(int status, String errorMessage, MediaType mediaType) {
        String message = MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType) ? "{\"error\": \"" + errorMessage + "\"}" : "<error><message>" + errorMessage + "</message></error>";
        return Response.status((int)status).entity((Object)message).type(mediaType).build();
    }

    private static void closeInputOnError(InputStream inputStream) {
        if (inputStream != null) {
            LOGGER.error("Unexpected error occurred during de-serialization of discovery data, done connection cleanup");
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.debug("Cannot close input", (Throwable)e);
            }
        }
    }
}

