/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.inject.ProvidedBy;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.LeaseInfo;
import com.netflix.appinfo.UniqueIdentifier;
import com.netflix.appinfo.providers.EurekaConfigBasedInstanceInfoProvider;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.discovery.converters.Auto;
import com.netflix.discovery.provider.Serializer;
import com.netflix.discovery.util.StringCache;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProvidedBy(value=EurekaConfigBasedInstanceInfoProvider.class)
@Serializer(value="com.netflix.discovery.converters.EntityBodyConverter")
@XStreamAlias(value="instance")
@JsonRootName(value="instance")
public class InstanceInfo {
    private static final Logger logger = LoggerFactory.getLogger(InstanceInfo.class);
    private static final Pattern VIP_ATTRIBUTES_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");
    public static final int DEFAULT_PORT = 7001;
    public static final int DEFAULT_SECURE_PORT = 7002;
    public static final int DEFAULT_COUNTRY_ID = 1;
    private volatile String appName;
    @Auto
    private volatile String appGroupName;
    private volatile String ipAddr;
    private volatile String sid = "na";
    private volatile int port = 7001;
    private volatile int securePort = 7002;
    @Auto
    private volatile String homePageUrl;
    @Auto
    private volatile String statusPageUrl;
    @Auto
    private volatile String healthCheckUrl;
    @Auto
    private volatile String secureHealthCheckUrl;
    @Auto
    private volatile String vipAddress;
    @Auto
    private volatile String secureVipAddress;
    @XStreamOmitField
    private String statusPageRelativeUrl;
    @XStreamOmitField
    private String statusPageExplicitUrl;
    @XStreamOmitField
    private String healthCheckRelativeUrl;
    @XStreamOmitField
    private String healthCheckSecureExplicitUrl;
    @XStreamOmitField
    private String vipAddressUnresolved;
    @XStreamOmitField
    private String secureVipAddressUnresolved;
    @XStreamOmitField
    private String healthCheckExplicitUrl;
    @Deprecated
    private volatile int countryId = 1;
    private volatile boolean isSecurePortEnabled = false;
    private volatile boolean isUnsecurePortEnabled = true;
    private volatile DataCenterInfo dataCenterInfo;
    private volatile String hostName;
    private volatile InstanceStatus status = InstanceStatus.UP;
    private volatile InstanceStatus overriddenstatus = InstanceStatus.UNKNOWN;
    @XStreamOmitField
    private volatile boolean isInstanceInfoDirty = false;
    private volatile LeaseInfo leaseInfo;
    @Auto
    private volatile Boolean isCoordinatingDiscoveryServer = Boolean.FALSE;
    @XStreamAlias(value="metadata")
    private volatile Map<String, String> metadata = new ConcurrentHashMap<String, String>();
    @Auto
    private volatile Long lastUpdatedTimestamp = System.currentTimeMillis();
    @Auto
    private volatile Long lastDirtyTimestamp = System.currentTimeMillis();
    @Auto
    private volatile ActionType actionType;
    @Auto
    private volatile String asgName;
    private String version = "unknown";

    private InstanceInfo() {
    }

    @JsonCreator
    public InstanceInfo(@JsonProperty(value="app") String appName, @JsonProperty(value="appGroupName") String appGroupName, @JsonProperty(value="ipAddr") String ipAddr, @JsonProperty(value="sid") String sid, @JsonProperty(value="port") int port, @JsonProperty(value="portEnabled") boolean portEnabled, @JsonProperty(value="securePort") int securePort, @JsonProperty(value="securePortEnabled") boolean securePortEnabled, @JsonProperty(value="homePageUrl") String homePageUrl, @JsonProperty(value="statusPageUrl") String statusPageUrl, @JsonProperty(value="healthCheckUrl") String healthCheckUrl, @JsonProperty(value="secureHealthCheckUrl") String secureHealthCheckUrl, @JsonProperty(value="vipAddress") String vipAddress, @JsonProperty(value="secureVipAddress") String secureVipAddress, @JsonProperty(value="countryId") int countryId, @JsonProperty(value="dataCenterInfo") DataCenterInfo dataCenterInfo, @JsonProperty(value="hostName") String hostName, @JsonProperty(value="status") InstanceStatus status, @JsonProperty(value="overriddenstatus") InstanceStatus overriddenstatus, @JsonProperty(value="leaseInfo") LeaseInfo leaseInfo, @JsonProperty(value="isCoordinatingDiscoveryServer") Boolean isCoordinatingDiscoveryServer, @JsonProperty(value="metadata") HashMap<String, String> metadata, @JsonProperty(value="lastUpdatedTimestamp") Long lastUpdatedTimestamp, @JsonProperty(value="lastDirtyTimestamp") Long lastDirtyTimestamp, @JsonProperty(value="actionType") ActionType actionType, @JsonProperty(value="asgName") String asgName) {
        this.appName = StringCache.intern(appName);
        this.appGroupName = StringCache.intern(appGroupName);
        this.ipAddr = ipAddr;
        this.sid = sid;
        this.port = port;
        this.isUnsecurePortEnabled = portEnabled;
        this.securePort = securePort;
        this.isSecurePortEnabled = securePortEnabled;
        this.homePageUrl = homePageUrl;
        this.statusPageUrl = statusPageUrl;
        this.healthCheckUrl = healthCheckUrl;
        this.secureHealthCheckUrl = secureHealthCheckUrl;
        this.vipAddress = StringCache.intern(vipAddress);
        this.secureVipAddress = StringCache.intern(secureVipAddress);
        this.countryId = countryId;
        this.dataCenterInfo = dataCenterInfo;
        this.hostName = hostName;
        this.status = status;
        this.overriddenstatus = overriddenstatus;
        this.leaseInfo = leaseInfo;
        this.isCoordinatingDiscoveryServer = isCoordinatingDiscoveryServer;
        this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        this.lastDirtyTimestamp = lastDirtyTimestamp;
        this.actionType = actionType;
        this.asgName = StringCache.intern(asgName);
        this.metadata = metadata == null ? Collections.emptyMap() : (metadata.size() == 1 ? this.removeMetadataMapLegacyValues(metadata) : metadata);
    }

    private Map<String, String> removeMetadataMapLegacyValues(Map<String, String> metadata) {
        if ("java.util.Collections$EmptyMap".equals(metadata.get("@class"))) {
            metadata.remove("@class");
        } else if ("java.util.Collections$EmptyMap".equals(metadata.get("class"))) {
            metadata.remove("class");
        }
        return metadata;
    }

    public InstanceInfo(InstanceInfo ii) {
        this.appName = ii.appName;
        this.appGroupName = ii.appGroupName;
        this.ipAddr = ii.ipAddr;
        this.sid = ii.sid;
        this.port = ii.port;
        this.securePort = ii.securePort;
        this.homePageUrl = ii.homePageUrl;
        this.statusPageUrl = ii.statusPageUrl;
        this.healthCheckUrl = ii.healthCheckUrl;
        this.secureHealthCheckUrl = ii.secureHealthCheckUrl;
        this.vipAddress = ii.vipAddress;
        this.secureVipAddress = ii.secureVipAddress;
        this.statusPageRelativeUrl = ii.statusPageRelativeUrl;
        this.statusPageExplicitUrl = ii.statusPageExplicitUrl;
        this.healthCheckRelativeUrl = ii.healthCheckRelativeUrl;
        this.healthCheckSecureExplicitUrl = ii.healthCheckSecureExplicitUrl;
        this.vipAddressUnresolved = ii.vipAddressUnresolved;
        this.secureVipAddressUnresolved = ii.secureVipAddressUnresolved;
        this.healthCheckExplicitUrl = ii.healthCheckExplicitUrl;
        this.countryId = ii.countryId;
        this.isSecurePortEnabled = ii.isSecurePortEnabled;
        this.isUnsecurePortEnabled = ii.isUnsecurePortEnabled;
        this.dataCenterInfo = ii.dataCenterInfo;
        this.hostName = ii.hostName;
        this.status = ii.status;
        this.overriddenstatus = ii.overriddenstatus;
        this.isInstanceInfoDirty = ii.isInstanceInfoDirty;
        this.leaseInfo = ii.leaseInfo;
        this.isCoordinatingDiscoveryServer = ii.isCoordinatingDiscoveryServer;
        this.metadata = ii.metadata;
        this.lastUpdatedTimestamp = ii.lastUpdatedTimestamp;
        this.lastDirtyTimestamp = ii.lastDirtyTimestamp;
        this.actionType = ii.actionType;
        this.asgName = ii.asgName;
        this.version = ii.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstanceInfo other = (InstanceInfo)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    @JsonProperty(value="app")
    public String getAppName() {
        return this.appName;
    }

    public String getAppGroupName() {
        return this.appGroupName;
    }

    public String getHostName() {
        return this.hostName;
    }

    @Deprecated
    public void setSID(String sid) {
        this.sid = sid;
        this.setIsDirty();
    }

    @Deprecated
    @JsonIgnore
    public String getSID() {
        return this.sid;
    }

    @JsonIgnore
    public String getId() {
        if (this.dataCenterInfo instanceof UniqueIdentifier) {
            return ((UniqueIdentifier)((Object)this.dataCenterInfo)).getId();
        }
        return this.hostName;
    }

    @JsonProperty(value="ipAddr")
    public String getIPAddr() {
        return this.ipAddr;
    }

    @JsonIgnore
    public int getPort() {
        return this.port;
    }

    public InstanceStatus getStatus() {
        return this.status;
    }

    public InstanceStatus getOverriddenStatus() {
        return this.overriddenstatus;
    }

    public DataCenterInfo getDataCenterInfo() {
        return this.dataCenterInfo;
    }

    public LeaseInfo getLeaseInfo() {
        return this.leaseInfo;
    }

    public void setLeaseInfo(LeaseInfo info) {
        this.leaseInfo = info;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Deprecated
    public int getCountryId() {
        return this.countryId;
    }

    @JsonIgnore
    public int getSecurePort() {
        return this.securePort;
    }

    @JsonIgnore
    public boolean isPortEnabled(PortType type) {
        if (type == PortType.SECURE) {
            return this.isSecurePortEnabled;
        }
        return this.isUnsecurePortEnabled;
    }

    public long getLastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public void setLastUpdatedTimestamp() {
        this.lastUpdatedTimestamp = System.currentTimeMillis();
    }

    public String getHomePageUrl() {
        return this.homePageUrl;
    }

    public String getStatusPageUrl() {
        return this.statusPageUrl;
    }

    @JsonIgnore
    public Set<String> getHealthCheckUrls() {
        LinkedHashSet<String> healthCheckUrlSet = new LinkedHashSet<String>();
        if (this.isUnsecurePortEnabled && this.healthCheckUrl != null && !this.healthCheckUrl.isEmpty()) {
            healthCheckUrlSet.add(this.healthCheckUrl);
        }
        if (this.isSecurePortEnabled && this.secureHealthCheckUrl != null && !this.secureHealthCheckUrl.isEmpty()) {
            healthCheckUrlSet.add(this.secureHealthCheckUrl);
        }
        return healthCheckUrlSet;
    }

    public String getHealthCheckUrl() {
        return this.healthCheckUrl;
    }

    public String getSecureHealthCheckUrl() {
        return this.secureHealthCheckUrl;
    }

    @JsonProperty(value="vipAddress")
    public String getVIPAddress() {
        return this.vipAddress;
    }

    public String getSecureVipAddress() {
        return this.secureVipAddress;
    }

    public Long getLastDirtyTimestamp() {
        return this.lastDirtyTimestamp;
    }

    public void setLastDirtyTimestamp(Long lastDirtyTimestamp) {
        this.lastDirtyTimestamp = lastDirtyTimestamp;
    }

    public synchronized InstanceStatus setStatus(InstanceStatus status) {
        if (this.status != status) {
            InstanceStatus prev = this.status;
            this.status = status;
            this.setIsDirty();
            return prev;
        }
        return null;
    }

    public synchronized void setStatusWithoutDirty(InstanceStatus status) {
        if (this.status != status) {
            this.status = status;
        }
    }

    public synchronized void setOverriddenStatus(InstanceStatus status) {
        if (this.overriddenstatus != status) {
            this.overriddenstatus = status;
        }
    }

    @JsonIgnore
    public boolean isDirty() {
        return this.isInstanceInfoDirty;
    }

    public synchronized Long isDirtyWithTime() {
        if (this.isInstanceInfoDirty) {
            return this.lastDirtyTimestamp;
        }
        return null;
    }

    @Deprecated
    public synchronized void setIsDirty(boolean isDirty) {
        if (isDirty) {
            this.setIsDirty();
        } else {
            this.isInstanceInfoDirty = false;
        }
    }

    public synchronized void setIsDirty() {
        this.isInstanceInfoDirty = true;
        this.lastDirtyTimestamp = System.currentTimeMillis();
    }

    public synchronized void unsetIsDirty(long unsetDirtyTimestamp) {
        if (this.lastDirtyTimestamp <= unsetDirtyTimestamp) {
            this.isInstanceInfoDirty = false;
        }
    }

    public void setIsCoordinatingDiscoveryServer() {
        String instanceId = this.getId();
        this.isCoordinatingDiscoveryServer = instanceId != null && instanceId.equals(ApplicationInfoManager.getInstance().getInfo().getId()) ? Boolean.TRUE : Boolean.FALSE;
    }

    @JsonProperty(value="isCoordinatingDiscoveryServer")
    public Boolean isCoordinatingDiscoveryServer() {
        return this.isCoordinatingDiscoveryServer;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public void setActionType(ActionType actionType) {
        this.actionType = actionType;
    }

    @JsonProperty(value="asgName")
    public String getASGName() {
        return this.asgName;
    }

    @Deprecated
    @JsonIgnore
    public String getVersion() {
        return this.version;
    }

    synchronized void registerRuntimeMetadata(Map<String, String> runtimeMetadata) {
        this.metadata.putAll(runtimeMetadata);
        this.setIsDirty();
    }

    private static String resolveDeploymentContextBasedVipAddresses(String vipAddressMacro) {
        String result = vipAddressMacro;
        if (vipAddressMacro == null) {
            return null;
        }
        Matcher matcher = VIP_ATTRIBUTES_PATTERN.matcher(result);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = DynamicPropertyFactory.getInstance().getStringProperty(key, "").get();
            logger.debug("att:" + matcher.group());
            logger.debug(", att key:" + key);
            logger.debug(", att value:" + value);
            logger.debug("");
            result = result.replaceAll("\\$\\{" + key + "\\}", value);
            matcher = VIP_ATTRIBUTES_PATTERN.matcher(result);
        }
        return result;
    }

    public static String getZone(String[] availZones, InstanceInfo myInfo) {
        String awsInstanceZone;
        String instanceZone;
        String string = instanceZone = availZones == null || availZones.length == 0 ? "default" : availZones[0];
        if (myInfo != null && myInfo.getDataCenterInfo().getName() == DataCenterInfo.Name.Amazon && (awsInstanceZone = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.availabilityZone)) != null) {
            instanceZone = awsInstanceZone;
        }
        return instanceZone;
    }

    public static enum ActionType {
        ADDED,
        MODIFIED,
        DELETED;

    }

    public static final class Builder {
        private static final String COLON = ":";
        private static final String HTTPS_PROTOCOL = "https://";
        private static final String HTTP_PROTOCOL = "http://";
        @XStreamOmitField
        private InstanceInfo result;
        private String namespace;

        private Builder() {
            this.result = new InstanceInfo();
        }

        public Builder(InstanceInfo instanceInfo) {
            this.result = instanceInfo;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder setAppName(String appName) {
            this.result.appName = StringCache.intern(appName.toUpperCase(Locale.ROOT));
            return this;
        }

        public Builder setAppGroupName(String appGroupName) {
            if (appGroupName != null) {
                this.result.appGroupName = appGroupName.toUpperCase(Locale.ROOT);
            } else {
                this.result.appGroupName = null;
            }
            return this;
        }

        public Builder setHostName(String hostName) {
            String existingHostName = this.result.hostName;
            this.result.hostName = hostName;
            if (existingHostName != null && !hostName.equals(existingHostName)) {
                this.refreshStatusPageUrl().refreshHealthCheckUrl().refreshVIPAddress().refreshSecureVIPAddress();
            }
            return this;
        }

        public Builder setStatus(InstanceStatus status) {
            this.result.status = status;
            return this;
        }

        public Builder setOverriddenStatus(InstanceStatus status) {
            this.result.overriddenstatus = status;
            return this;
        }

        public Builder setIPAddr(String ip) {
            this.result.ipAddr = ip;
            return this;
        }

        @Deprecated
        public Builder setSID(String sid) {
            this.result.sid = sid;
            return this;
        }

        public Builder setPort(int port) {
            this.result.port = port;
            return this;
        }

        public Builder setSecurePort(int port) {
            this.result.securePort = port;
            return this;
        }

        public Builder enablePort(PortType type, boolean isEnabled) {
            if (type == PortType.SECURE) {
                this.result.isSecurePortEnabled = isEnabled;
            } else {
                this.result.isUnsecurePortEnabled = isEnabled;
            }
            return this;
        }

        @Deprecated
        public Builder setCountryId(int id) {
            this.result.countryId = id;
            return this;
        }

        public Builder setHomePageUrl(String relativeUrl, String explicitUrl) {
            String hostNameInterpolationExpression = "${" + this.namespace + "hostname}";
            if (explicitUrl != null) {
                this.result.homePageUrl = explicitUrl.replace(hostNameInterpolationExpression, this.result.hostName);
            } else if (relativeUrl != null) {
                this.result.homePageUrl = HTTP_PROTOCOL + this.result.hostName + COLON + this.result.port + relativeUrl;
            }
            return this;
        }

        public Builder setHomePageUrlForDeser(String homePageUrl) {
            this.result.homePageUrl = homePageUrl;
            return this;
        }

        public Builder setStatusPageUrl(String relativeUrl, String explicitUrl) {
            String hostNameInterpolationExpression = "${" + this.namespace + "hostname}";
            this.result.statusPageRelativeUrl = relativeUrl;
            this.result.statusPageExplicitUrl = explicitUrl;
            if (explicitUrl != null) {
                this.result.statusPageUrl = explicitUrl.replace(hostNameInterpolationExpression, this.result.hostName);
            } else if (relativeUrl != null) {
                this.result.statusPageUrl = HTTP_PROTOCOL + this.result.hostName + COLON + this.result.port + relativeUrl;
            }
            return this;
        }

        public Builder setStatusPageUrlForDeser(String statusPageUrl) {
            this.result.statusPageUrl = statusPageUrl;
            return this;
        }

        public Builder setHealthCheckUrls(String relativeUrl, String explicitUrl, String secureExplicitUrl) {
            String hostNameInterpolationExpression = "${" + this.namespace + "hostname}";
            this.result.healthCheckRelativeUrl = relativeUrl;
            this.result.healthCheckExplicitUrl = explicitUrl;
            this.result.healthCheckSecureExplicitUrl = secureExplicitUrl;
            if (explicitUrl != null) {
                this.result.healthCheckUrl = explicitUrl.replace(hostNameInterpolationExpression, this.result.hostName);
            } else if (this.result.isUnsecurePortEnabled) {
                this.result.healthCheckUrl = HTTP_PROTOCOL + this.result.hostName + COLON + this.result.port + relativeUrl;
            }
            if (secureExplicitUrl != null) {
                this.result.secureHealthCheckUrl = secureExplicitUrl.replace(hostNameInterpolationExpression, this.result.hostName);
            } else if (this.result.isSecurePortEnabled) {
                this.result.secureHealthCheckUrl = HTTPS_PROTOCOL + this.result.hostName + COLON + this.result.securePort + relativeUrl;
            }
            return this;
        }

        public Builder setHealthCheckUrlsForDeser(String healthCheckUrl, String secureHealthCheckUrl) {
            if (healthCheckUrl != null) {
                this.result.healthCheckUrl = healthCheckUrl;
            }
            if (secureHealthCheckUrl != null) {
                this.result.secureHealthCheckUrl = secureHealthCheckUrl;
            }
            return this;
        }

        public Builder setVIPAddress(String vipAddress) {
            this.result.vipAddressUnresolved = StringCache.intern(vipAddress);
            this.result.vipAddress = StringCache.intern(InstanceInfo.resolveDeploymentContextBasedVipAddresses(vipAddress));
            return this;
        }

        public Builder setVIPAddressDeser(String vipAddress) {
            this.result.vipAddress = StringCache.intern(vipAddress);
            return this;
        }

        public Builder setSecureVIPAddress(String secureVIPAddress) {
            this.result.secureVipAddressUnresolved = StringCache.intern(secureVIPAddress);
            this.result.secureVipAddress = StringCache.intern(InstanceInfo.resolveDeploymentContextBasedVipAddresses(secureVIPAddress));
            return this;
        }

        public Builder setSecureVIPAddressDeser(String secureVIPAddress) {
            this.result.secureVipAddress = StringCache.intern(secureVIPAddress);
            return this;
        }

        public Builder setDataCenterInfo(DataCenterInfo datacenter) {
            this.result.dataCenterInfo = datacenter;
            return this;
        }

        public Builder setLeaseInfo(LeaseInfo info) {
            this.result.leaseInfo = info;
            return this;
        }

        public Builder add(String key, String val) {
            this.result.metadata.put(key, val);
            return this;
        }

        public Builder setMetadata(Map<String, String> mt) {
            this.result.metadata = mt;
            return this;
        }

        public InstanceInfo getRawInstance() {
            return this.result;
        }

        public InstanceInfo build() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("name is required!");
            }
            return this.result;
        }

        public boolean isInitialized() {
            return this.result.appName != null;
        }

        public Builder setASGName(String asgName) {
            this.result.asgName = StringCache.intern(asgName);
            return this;
        }

        private Builder refreshStatusPageUrl() {
            this.setStatusPageUrl(this.result.statusPageRelativeUrl, this.result.statusPageExplicitUrl);
            return this;
        }

        private Builder refreshHealthCheckUrl() {
            this.setHealthCheckUrls(this.result.healthCheckRelativeUrl, this.result.healthCheckExplicitUrl, this.result.healthCheckSecureExplicitUrl);
            return this;
        }

        private Builder refreshSecureVIPAddress() {
            this.setSecureVIPAddress(this.result.secureVipAddressUnresolved);
            return this;
        }

        private Builder refreshVIPAddress() {
            this.setVIPAddress(this.result.vipAddressUnresolved);
            return this;
        }

        public Builder setIsCoordinatingDiscoveryServer(boolean isCoordinatingDiscoveryServer) {
            this.result.isCoordinatingDiscoveryServer = isCoordinatingDiscoveryServer;
            return this;
        }

        public Builder setLastUpdatedTimestamp(long lastUpdatedTimestamp) {
            this.result.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public Builder setLastDirtyTimestamp(long lastDirtyTimestamp) {
            this.result.lastDirtyTimestamp = lastDirtyTimestamp;
            return this;
        }

        public Builder setActionType(ActionType actionType) {
            this.result.actionType = actionType;
            return this;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }
    }

    public static enum PortType {
        SECURE,
        UNSECURE;

    }

    public static enum InstanceStatus {
        UP,
        DOWN,
        STARTING,
        OUT_OF_SERVICE,
        UNKNOWN;


        public static InstanceStatus toEnum(String s) {
            for (InstanceStatus e : InstanceStatus.values()) {
                if (!e.name().equalsIgnoreCase(s)) continue;
                return e;
            }
            return UNKNOWN;
        }
    }
}

