/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.UniqueIdentifier;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.discovery.converters.jackson.StringInterningAmazonInfoBuilder;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=StringInterningAmazonInfoBuilder.class)
public class AmazonInfo
implements DataCenterInfo,
UniqueIdentifier {
    private Map<String, String> metadata = new HashMap<String, String>();
    private static DynamicBooleanProperty shouldLogAWSMetadataError;
    private static DynamicIntProperty awsMetaDataReadTimeout;
    private static DynamicIntProperty awsMetaDataConnectTimeout;
    private static DynamicIntProperty awsMetaDataRetries;
    private static final String AWS_API_VERSION = "latest";
    private static final String AWS_METADATA_URL = "http://169.254.169.254/latest/meta-data/";

    public AmazonInfo() {
    }

    @JsonCreator
    public AmazonInfo(@JsonProperty(value="name") String name, @JsonProperty(value="metadata") HashMap<String, String> metadata) {
        this.metadata = metadata;
    }

    @Override
    public DataCenterInfo.Name getName() {
        return DataCenterInfo.Name.Amazon;
    }

    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadataMap) {
        this.metadata = metadataMap;
    }

    public String get(MetaDataKey key) {
        return this.metadata.get(key.getName());
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.get(MetaDataKey.instanceId);
    }

    public static final class Builder {
        private static final Logger logger = LoggerFactory.getLogger(Builder.class);
        private static final int SLEEP_TIME_MS = 100;
        @XStreamOmitField
        private AmazonInfo result = new AmazonInfo();

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder addMetadata(MetaDataKey key, String value) {
            this.result.metadata.put(key.getName(), value);
            return this;
        }

        public AmazonInfo build() {
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AmazonInfo autoBuild(String namespace) {
            this.initProperties(namespace);
            block7: for (MetaDataKey key : MetaDataKey.values()) {
                int numOfRetries = awsMetaDataRetries.get();
                while (numOfRetries-- > 0) {
                    try {
                        String mac = null;
                        if (key == MetaDataKey.vpcId) {
                            mac = (String)this.result.metadata.get(MetaDataKey.mac.name());
                        }
                        URL url = key.getURL(null, mac);
                        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
                        uc.setConnectTimeout(awsMetaDataConnectTimeout.get());
                        uc.setReadTimeout(awsMetaDataReadTimeout.get());
                        if (uc.getResponseCode() != 200) {
                            try (BufferedReader br = new BufferedReader(new InputStreamReader(uc.getErrorStream()));){
                                while (br.readLine() != null) {
                                }
                                continue block7;
                            }
                        }
                        String value = key.read(uc.getInputStream());
                        if (value == null) continue block7;
                        this.result.metadata.put(key.getName(), value);
                        continue block7;
                    }
                    catch (Throwable e) {
                        if (shouldLogAWSMetadataError.get()) {
                            logger.warn("Cannot get the value for the metadata key :" + (Object)((Object)key) + " Reason :", e);
                        }
                        if (numOfRetries < 0) continue;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e1) {}
                    }
                }
            }
            return this.result;
        }

        private void initProperties(String namespace) {
            if (shouldLogAWSMetadataError == null) {
                shouldLogAWSMetadataError = DynamicPropertyFactory.getInstance().getBooleanProperty(namespace + "logAmazonMetadataErrors", false);
            }
            if (awsMetaDataReadTimeout == null) {
                awsMetaDataReadTimeout = DynamicPropertyFactory.getInstance().getIntProperty(namespace + "mt.read_timeout", 8000);
            }
            if (awsMetaDataConnectTimeout == null) {
                awsMetaDataConnectTimeout = DynamicPropertyFactory.getInstance().getIntProperty(namespace + "mt.connect_timeout", 3000);
            }
            if (awsMetaDataRetries == null) {
                awsMetaDataRetries = DynamicPropertyFactory.getInstance().getIntProperty(namespace + "mt.num_retries", 3);
            }
        }
    }

    public static enum MetaDataKey {
        amiId("ami-id"),
        instanceId("instance-id"),
        instanceType("instance-type"),
        localIpv4("local-ipv4"),
        availabilityZone("availability-zone", "placement/"),
        publicHostname("public-hostname"),
        publicIpv4("public-ipv4"),
        mac("mac"),
        vpcId("vpc-id", "network/interfaces/macs/"){

            @Override
            public URL getURL(String prepend, String mac) throws MalformedURLException {
                return new URL(AmazonInfo.AWS_METADATA_URL + this.path + mac + "/" + this.name);
            }
        }
        ,
        accountId("accountId"){
            private Pattern pattern = Pattern.compile("\"accountId\"\\s?:\\s?\\\"([A-Za-z0-9]*)\\\"");

            @Override
            public URL getURL(String prepend, String append) throws MalformedURLException {
                return new URL("http://169.254.169.254/latest/dynamic/instance-identity/document");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected String read(InputStream inputStream) throws IOException {
                try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
                    String inputLine;
                    String toReturn = null;
                    while ((inputLine = br.readLine()) != null) {
                        Matcher matcher = this.pattern.matcher(inputLine);
                        if (toReturn != null || !matcher.find()) continue;
                        toReturn = matcher.group(1);
                    }
                    String string = toReturn;
                    return string;
                }
            }
        };

        protected String name;
        protected String path;

        private MetaDataKey(String name) {
            this(name, "");
        }

        private MetaDataKey(String name, String path) {
            this.name = name;
            this.path = path;
        }

        public String getName() {
            return this.name;
        }

        public URL getURL(String prepend, String append) throws MalformedURLException {
            return new URL(AmazonInfo.AWS_METADATA_URL + this.path + this.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String read(InputStream inputStream) throws IOException {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                String toReturn = line = br.readLine();
                while (line != null) {
                    line = br.readLine();
                }
                String string = toReturn;
                return string;
            }
        }
    }
}

