/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.discovery.shared.Pair;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInstanceConfig
implements EurekaInstanceConfig {
    private static final Logger logger = LoggerFactory.getLogger(AbstractInstanceConfig.class);
    public static final String DEFAULT_NAMESPACE = "eureka";
    private static final int LEASE_EXPIRATION_DURATION_SECONDS = 90;
    private static final int LEASE_RENEWAL_INTERVAL_SECONDS = 30;
    private static final boolean SECURE_PORT_ENABLED = false;
    private static final boolean NON_SECURE_PORT_ENABLED = true;
    private static final int NON_SECURE_PORT = 80;
    private static final int SECURE_PORT = 443;
    private static final boolean INSTANCE_ENABLED_ON_INIT = false;
    private static final Pair<String, String> hostInfo = AbstractInstanceConfig.getHostInfo();
    private DataCenterInfo info = new DataCenterInfo(){

        @Override
        public DataCenterInfo.Name getName() {
            return DataCenterInfo.Name.MyOwn;
        }
    };

    protected AbstractInstanceConfig() {
    }

    protected AbstractInstanceConfig(DataCenterInfo info) {
        this.info = info;
    }

    @Override
    public abstract String getAppname();

    @Override
    public boolean isInstanceEnabledOnit() {
        return false;
    }

    @Override
    public int getNonSecurePort() {
        return 80;
    }

    @Override
    public int getSecurePort() {
        return 443;
    }

    @Override
    public boolean isNonSecurePortEnabled() {
        return true;
    }

    @Override
    public boolean getSecurePortEnabled() {
        return false;
    }

    @Override
    public int getLeaseRenewalIntervalInSeconds() {
        return 30;
    }

    @Override
    public int getLeaseExpirationDurationInSeconds() {
        return 90;
    }

    @Override
    public String getVirtualHostName() {
        return this.getHostName(false) + ":" + this.getNonSecurePort();
    }

    @Override
    public String getSecureVirtualHostName() {
        return this.getHostName(false) + ":" + this.getSecurePort();
    }

    @Override
    public String getASGName() {
        return null;
    }

    @Override
    public String getHostName(boolean refresh) {
        return hostInfo.second();
    }

    @Override
    public Map<String, String> getMetadataMap() {
        return null;
    }

    @Override
    public DataCenterInfo getDataCenterInfo() {
        return this.info;
    }

    @Override
    public String getIpAddress() {
        return hostInfo.first();
    }

    private static Pair<String, String> getHostInfo() {
        Pair<String, String> pair = new Pair<String, String>("", "");
        try {
            pair.setFirst(InetAddress.getLocalHost().getHostAddress());
            pair.setSecond(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            logger.error("Cannot get host info", (Throwable)e);
        }
        return pair;
    }
}

