/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared;

import com.google.common.base.Preconditions;
import com.netflix.discovery.provider.DiscoveryJerseyProvider;
import com.netflix.discovery.shared.MonitoredConnectionManager;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.BasicTimer;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import com.sun.jersey.client.apache4.config.DefaultApacheHttpClient4Config;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EurekaJerseyClient {
    private EurekaJerseyClient() {
    }

    public static JerseyClient createJerseyClient(String clientName, int connectionTimeout, int readTimeout, int maxConnectionsPerHost, int maxTotalConnections, int connectionIdleTimeout) {
        Preconditions.checkNotNull((Object)clientName, (Object)"Client name can not be null.");
        try {
            CustomApacheHttpClientConfig jerseyClientConfig = new CustomApacheHttpClientConfig(clientName, maxConnectionsPerHost, maxTotalConnections);
            return new JerseyClient(connectionTimeout, readTimeout, connectionIdleTimeout, (ClientConfig)jerseyClientConfig);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot create Jersey client ", e);
        }
    }

    public static JerseyClient createProxyJerseyClient(String clientName, int connectionTimeout, int readTimeout, int maxConnectionsPerHost, int maxTotalConnections, int connectionIdleTimeout, String proxyHost, String proxyPort, String proxyUserName, String proxyPassword) {
        Preconditions.checkNotNull((Object)clientName, (Object)"Client name can not be null.");
        try {
            ProxyCustomApacheHttpClientConfig jerseyClientConfig = new ProxyCustomApacheHttpClientConfig(clientName, maxConnectionsPerHost, maxTotalConnections, proxyHost, proxyPort, proxyUserName, proxyPassword);
            return new JerseyClient(connectionTimeout, readTimeout, connectionIdleTimeout, (ClientConfig)jerseyClientConfig);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot create Jersey client ", e);
        }
    }

    public static JerseyClient createSSLJerseyClient(String clientName, int connectionTimeout, int readTimeout, int maxConnectionsPerHost, int maxTotalConnections, int connectionIdleTimeout, String trustStoreFileName, String trustStorePassword) {
        Preconditions.checkNotNull((Object)clientName, (Object)"Client name can not be null.");
        try {
            SSLCustomApacheHttpClientConfig jerseyClientConfig = new SSLCustomApacheHttpClientConfig(clientName, maxConnectionsPerHost, maxTotalConnections, trustStoreFileName, trustStorePassword);
            return new JerseyClient(connectionTimeout, readTimeout, connectionIdleTimeout, (ClientConfig)jerseyClientConfig);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot create SSL Jersey client ", e);
        }
    }

    public static JerseyClient createSystemSSLJerseyClient(String clientName, int connectionTimeout, int readTimeout, int maxConnectionsPerHost, int maxTotalConnections, int connectionIdleTimeout) {
        Preconditions.checkNotNull((Object)clientName, (Object)"Client name can not be null.");
        try {
            SystemSSLCustomApacheHttpClientConfig jerseyClientConfig = new SystemSSLCustomApacheHttpClientConfig(clientName, maxConnectionsPerHost, maxTotalConnections);
            return new JerseyClient(connectionTimeout, readTimeout, connectionIdleTimeout, (ClientConfig)jerseyClientConfig);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot create System SSL Jersey client ", e);
        }
    }

    public static class JerseyClient {
        private static final int HTTP_CONNECTION_CLEANER_INTERVAL_MS = 30000;
        private ApacheHttpClient4 apacheHttpClient;
        ClientConfig jerseyClientConfig;
        private ScheduledExecutorService eurekaConnCleaner = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "Eureka-JerseyClient-Conn-Cleaner" + this.threadNumber.incrementAndGet());
                thread.setDaemon(true);
                return thread;
            }
        });
        private static final Logger s_logger = LoggerFactory.getLogger(JerseyClient.class);

        public ApacheHttpClient4 getClient() {
            return this.apacheHttpClient;
        }

        public ClientConfig getClientconfig() {
            return this.jerseyClientConfig;
        }

        public JerseyClient(int connectionTimeout, int readTimeout, int connectionIdleTimeout, ClientConfig clientConfig) {
            try {
                this.jerseyClientConfig = clientConfig;
                this.jerseyClientConfig.getClasses().add(DiscoveryJerseyProvider.class);
                this.apacheHttpClient = ApacheHttpClient4.create((ClientConfig)this.jerseyClientConfig);
                HttpParams params = this.apacheHttpClient.getClientHandler().getHttpClient().getParams();
                HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)connectionTimeout);
                HttpConnectionParams.setSoTimeout((HttpParams)params, (int)readTimeout);
                this.eurekaConnCleaner.scheduleWithFixedDelay(new ConnectionCleanerTask(connectionIdleTimeout), 30000L, 30000L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable e) {
                throw new RuntimeException("Cannot create Jersey client", e);
            }
        }

        public void destroyResources() {
            if (this.eurekaConnCleaner != null) {
                this.eurekaConnCleaner.shutdown();
            }
            if (this.apacheHttpClient != null) {
                this.apacheHttpClient.destroy();
            }
        }

        private class ConnectionCleanerTask
        implements Runnable {
            private final int connectionIdleTimeout;
            private final BasicTimer executionTimeStats;
            private final Counter cleanupFailed;

            public ConnectionCleanerTask(int connectionIdleTimeout) {
                this.connectionIdleTimeout = connectionIdleTimeout;
                MonitorConfig.Builder monitorConfigBuilder = MonitorConfig.builder((String)"Eureka-Connection-Cleaner-Time");
                this.executionTimeStats = new BasicTimer(monitorConfigBuilder.build());
                this.cleanupFailed = new BasicCounter(MonitorConfig.builder((String)"Eureka-Connection-Cleaner-Failure").build());
                try {
                    Monitors.registerObject((Object)this);
                }
                catch (Exception e) {
                    s_logger.error("Unable to register with servo.", (Throwable)e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Stopwatch start = this.executionTimeStats.start();
                try {
                    JerseyClient.this.apacheHttpClient.getClientHandler().getHttpClient().getConnectionManager().closeIdleConnections((long)this.connectionIdleTimeout, TimeUnit.SECONDS);
                }
                catch (Throwable e) {
                    s_logger.error("Cannot clean connections", e);
                    this.cleanupFailed.increment();
                }
                finally {
                    if (null != start) {
                        start.stop();
                    }
                }
            }
        }
    }

    private static class SystemSSLCustomApacheHttpClientConfig
    extends DefaultApacheHttpClient4Config {
        private static final int HTTPS_PORT = 443;
        private static final String PROTOCOL = "https";

        public SystemSSLCustomApacheHttpClientConfig(String clientName, int maxConnectionsPerHost, int maxTotalConnections) throws Throwable {
            SSLSocketFactory sslSocketFactory = SSLSocketFactory.getSystemSocketFactory();
            SchemeRegistry sslSchemeRegistry = new SchemeRegistry();
            sslSchemeRegistry.register(new Scheme(PROTOCOL, 443, (SchemeSocketFactory)sslSocketFactory));
            MonitoredConnectionManager cm = new MonitoredConnectionManager(clientName, sslSchemeRegistry);
            cm.setDefaultMaxPerRoute(maxConnectionsPerHost);
            cm.setMaxTotal(maxTotalConnections);
            this.getProperties().put("com.sun.jersey.impl.client.httpclient.connectionManager", cm);
            this.getProperties().put("com.sun.jersey.client.property.followRedirects", Boolean.FALSE);
            this.getProperties().put("http.protocol.handle-redirects", Boolean.FALSE);
        }
    }

    private static class SSLCustomApacheHttpClientConfig
    extends DefaultApacheHttpClient4Config {
        private static final String PROTOCOL_SCHEME = "SSL";
        private static final int HTTPS_PORT = 443;
        private static final String PROTOCOL = "https";
        private static final String KEYSTORE_TYPE = "JKS";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SSLCustomApacheHttpClientConfig(String clientName, int maxConnectionsPerHost, int maxTotalConnections, String trustStoreFileName, String trustStorePassword) throws Throwable {
            SSLContext sslContext = SSLContext.getInstance(PROTOCOL_SCHEME);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore sslKeyStore = KeyStore.getInstance(KEYSTORE_TYPE);
            try (FileInputStream fin = null;){
                fin = new FileInputStream(trustStoreFileName);
                sslKeyStore.load(fin, trustStorePassword.toCharArray());
                tmf.init(sslKeyStore);
                sslContext.init(null, SSLCustomApacheHttpClientConfig.createTrustManagers(sslKeyStore), null);
                SSLSocketFactory sslSocketFactory = new SSLSocketFactory(sslContext);
                sslSocketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                SchemeRegistry sslSchemeRegistry = new SchemeRegistry();
                sslSchemeRegistry.register(new Scheme(PROTOCOL, 443, (SchemeSocketFactory)sslSocketFactory));
                MonitoredConnectionManager cm = new MonitoredConnectionManager(clientName, sslSchemeRegistry);
                cm.setDefaultMaxPerRoute(maxConnectionsPerHost);
                cm.setMaxTotal(maxTotalConnections);
                this.getProperties().put("com.sun.jersey.impl.client.httpclient.connectionManager", cm);
                this.getProperties().put("com.sun.jersey.client.property.followRedirects", Boolean.FALSE);
                this.getProperties().put("http.protocol.handle-redirects", Boolean.FALSE);
            }
        }

        private static TrustManager[] createTrustManagers(KeyStore trustStore) {
            TrustManagerFactory factory;
            try {
                factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                factory.init(trustStore);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            TrustManager[] managers = factory.getTrustManagers();
            return managers;
        }
    }

    private static class ProxyCustomApacheHttpClientConfig
    extends DefaultApacheHttpClient4Config {
        public ProxyCustomApacheHttpClientConfig(String clientName, int maxConnectionsPerHost, int maxTotalConnections, String proxyHost, String proxyPort, String proxyUserName, String proxyPassword) throws Throwable {
            MonitoredConnectionManager cm = new MonitoredConnectionManager(clientName);
            cm.setDefaultMaxPerRoute(maxConnectionsPerHost);
            cm.setMaxTotal(maxTotalConnections);
            this.getProperties().put("com.sun.jersey.impl.client.httpclient.connectionManager", cm);
            this.getProperties().put("com.sun.jersey.client.property.followRedirects", Boolean.FALSE);
            this.getProperties().put("http.protocol.handle-redirects", Boolean.FALSE);
            if (proxyUserName != null && proxyPassword != null) {
                this.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyUsername", proxyUserName);
                this.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyPassword", proxyPassword);
            } else {
                this.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyUsername", "guest");
                this.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyPassword", "guest");
            }
            this.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyURI", "http://" + proxyHost + ":" + proxyPort);
        }
    }

    private static class CustomApacheHttpClientConfig
    extends DefaultApacheHttpClient4Config {
        public CustomApacheHttpClientConfig(String clientName, int maxConnectionsPerHost, int maxTotalConnections) throws Throwable {
            MonitoredConnectionManager cm = new MonitoredConnectionManager(clientName);
            cm.setDefaultMaxPerRoute(maxConnectionsPerHost);
            cm.setMaxTotal(maxTotalConnections);
            this.getProperties().put("com.sun.jersey.impl.client.httpclient.connectionManager", cm);
            this.getProperties().put("com.sun.jersey.client.property.followRedirects", Boolean.FALSE);
            this.getProperties().put("http.protocol.handle-redirects", Boolean.FALSE);
        }
    }
}

