/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.provider.Serializer;
import com.netflix.discovery.shared.Application;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Serializer(value="com.netflix.discovery.converters.EntityBodyConverter")
@XStreamAlias(value="applications")
public class Applications {
    private static final String APP_INSTANCEID_DELIMITER = "$$";
    private static final Logger logger = LoggerFactory.getLogger(Applications.class);
    private static final String STATUS_DELIMITER = "_";
    private Long version_delta = -1L;
    @XStreamImplicit
    private AbstractQueue<Application> applications;
    private Map<String, Application> appNameApplicationMap = new ConcurrentHashMap<String, Application>();
    private Map<String, AbstractQueue<InstanceInfo>> virtualHostNameAppMap = new ConcurrentHashMap<String, AbstractQueue<InstanceInfo>>();
    private Map<String, AbstractQueue<InstanceInfo>> secureVirtualHostNameAppMap = new ConcurrentHashMap<String, AbstractQueue<InstanceInfo>>();
    private Map<String, AtomicLong> virtualHostNameIndexMap = new ConcurrentHashMap<String, AtomicLong>();
    private Map<String, AtomicLong> secureVirtualHostNameIndexMap = new ConcurrentHashMap<String, AtomicLong>();
    private Map<String, AtomicReference<List<InstanceInfo>>> shuffleVirtualHostNameMap = new ConcurrentHashMap<String, AtomicReference<List<InstanceInfo>>>();
    private Map<String, AtomicReference<List<InstanceInfo>>> shuffledSecureVirtualHostNameMap = new ConcurrentHashMap<String, AtomicReference<List<InstanceInfo>>>();
    private String appsHashCode;

    public Applications() {
        this.applications = new ConcurrentLinkedQueue<Application>();
    }

    public Applications(List<Application> apps) {
        this.applications = new ConcurrentLinkedQueue<Application>();
        this.applications.addAll(apps);
    }

    public void addApplication(Application app) {
        this.appNameApplicationMap.put(app.getName().toUpperCase(), app);
        this.addInstancesToVIPMaps(app);
        this.applications.add(app);
    }

    public List<Application> getRegisteredApplications() {
        ArrayList<Application> list = new ArrayList<Application>();
        list.addAll(this.applications);
        return list;
    }

    public Application getRegisteredApplications(String appName) {
        return this.appNameApplicationMap.get(appName.toUpperCase());
    }

    public List<InstanceInfo> getInstancesByVirtualHostName(String virtualHostName) {
        AtomicReference<List<InstanceInfo>> ref = this.shuffleVirtualHostNameMap.get(virtualHostName.toUpperCase());
        if (ref == null || ref.get() == null) {
            return new ArrayList<InstanceInfo>();
        }
        return ref.get();
    }

    public List<InstanceInfo> getInstancesBySecureVirtualHostName(String secureVirtualHostName) {
        AtomicReference<List<InstanceInfo>> ref = this.shuffledSecureVirtualHostNameMap.get(secureVirtualHostName.toUpperCase());
        if (ref == null || ref.get() == null) {
            return new ArrayList<InstanceInfo>();
        }
        return ref.get();
    }

    @Deprecated
    public void setVersion(Long version) {
        this.version_delta = version;
    }

    @Deprecated
    public Long getVersion() {
        return this.version_delta;
    }

    public void setAppsHashCode(String hashCode) {
        this.appsHashCode = hashCode;
    }

    public String getAppsHashCode() {
        return this.appsHashCode;
    }

    public String getReconcileHashCode() {
        TreeMap<String, AtomicInteger> instanceCountMap = new TreeMap<String, AtomicInteger>();
        for (Application app : this.getRegisteredApplications()) {
            for (InstanceInfo info : app.getInstancesAsIsFromEureka()) {
                AtomicInteger instanceCount = (AtomicInteger)instanceCountMap.get(info.getStatus().name());
                if (instanceCount == null) {
                    instanceCount = new AtomicInteger(0);
                    instanceCountMap.put(info.getStatus().name(), instanceCount);
                }
                instanceCount.incrementAndGet();
            }
        }
        String reconcileHashCode = "";
        for (Map.Entry mapEntry : instanceCountMap.entrySet()) {
            reconcileHashCode = reconcileHashCode + (String)mapEntry.getKey() + STATUS_DELIMITER + ((AtomicInteger)mapEntry.getValue()).get() + STATUS_DELIMITER;
        }
        return reconcileHashCode;
    }

    public Map<String, List<String>> getReconcileMapDiff(Applications apps) {
        TreeMap<String, List<String>> diffMap = new TreeMap<String, List<String>>();
        HashSet<Pair> allInstanceAppInstanceIds = new HashSet<Pair>();
        for (Application otherApp : apps.getRegisteredApplications()) {
            Application thisApp = this.getRegisteredApplications(otherApp.getName());
            if (thisApp == null) {
                logger.warn("The application %s is not found in local cache :", (Object)otherApp.getName());
                continue;
            }
            for (InstanceInfo instanceInfo : thisApp.getInstancesAsIsFromEureka()) {
                allInstanceAppInstanceIds.add(new Pair(thisApp.getName(), instanceInfo.getId()));
            }
            for (InstanceInfo otherInstanceInfo : otherApp.getInstancesAsIsFromEureka()) {
                List<String> diffList;
                InstanceInfo thisInstanceInfo = thisApp.getByInstanceId(otherInstanceInfo.getId());
                if (thisInstanceInfo == null) {
                    diffList = (ArrayList<String>)diffMap.get(InstanceInfo.ActionType.DELETED.name());
                    if (diffList == null) {
                        diffList = new ArrayList<String>();
                        diffMap.put(InstanceInfo.ActionType.DELETED.name(), diffList);
                    }
                    diffList.add(otherInstanceInfo.getId());
                } else if (!thisInstanceInfo.getStatus().name().equalsIgnoreCase(otherInstanceInfo.getStatus().name())) {
                    diffList = (List)diffMap.get(InstanceInfo.ActionType.MODIFIED.name());
                    if (diffList == null) {
                        diffList = new ArrayList();
                        diffMap.put(InstanceInfo.ActionType.MODIFIED.name(), diffList);
                    }
                    diffList.add(thisInstanceInfo.getId() + APP_INSTANCEID_DELIMITER + thisInstanceInfo.getStatus().name() + APP_INSTANCEID_DELIMITER + otherInstanceInfo.getStatus().name());
                }
                allInstanceAppInstanceIds.remove(new Pair(otherApp.getName(), otherInstanceInfo.getId()));
            }
        }
        for (Pair pair : allInstanceAppInstanceIds) {
            Application app = new Application(pair.getItem_1());
            InstanceInfo thisInstanceInfo = app.getByInstanceId(pair.getItem_2());
            if (thisInstanceInfo == null) continue;
            ArrayList<String> diffList = (ArrayList<String>)diffMap.get(InstanceInfo.ActionType.ADDED.name());
            if (diffList == null) {
                diffList = new ArrayList<String>();
                diffMap.put(InstanceInfo.ActionType.ADDED.name(), diffList);
            }
            diffList.add(thisInstanceInfo.getId());
        }
        return diffMap;
    }

    public void shuffleInstances(boolean filterUpInstances) {
        this.virtualHostNameAppMap.clear();
        this.secureVirtualHostNameAppMap.clear();
        for (Application application : this.appNameApplicationMap.values()) {
            application.shuffleAndStoreInstances(filterUpInstances);
            this.addInstancesToVIPMaps(application);
        }
        this.shuffleAndFilterInstances(this.virtualHostNameAppMap, this.shuffleVirtualHostNameMap, this.virtualHostNameIndexMap, filterUpInstances);
        this.shuffleAndFilterInstances(this.secureVirtualHostNameAppMap, this.shuffledSecureVirtualHostNameMap, this.secureVirtualHostNameIndexMap, filterUpInstances);
    }

    public AtomicLong getNextIndex(String virtualHostname, boolean secure) {
        if (secure) {
            return this.secureVirtualHostNameIndexMap.get(virtualHostname);
        }
        return this.virtualHostNameIndexMap.get(virtualHostname);
    }

    private void shuffleAndFilterInstances(Map<String, AbstractQueue<InstanceInfo>> srcMap, Map<String, AtomicReference<List<InstanceInfo>>> destMap, Map<String, AtomicLong> vipIndexMap, boolean filterUpInstances) {
        for (Map.Entry<String, AbstractQueue<InstanceInfo>> entries : srcMap.entrySet()) {
            AbstractQueue<InstanceInfo> instanceInfoQueue = entries.getValue();
            ArrayList<InstanceInfo> l = new ArrayList<InstanceInfo>(instanceInfoQueue);
            if (filterUpInstances) {
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    InstanceInfo instanceInfo = (InstanceInfo)it.next();
                    if (InstanceInfo.InstanceStatus.UP.equals((Object)instanceInfo.getStatus())) continue;
                    it.remove();
                }
            }
            Collections.shuffle(l);
            AtomicReference<List<InstanceInfo>> instanceInfoList = destMap.get(entries.getKey());
            if (instanceInfoList == null) {
                instanceInfoList = new AtomicReference<ArrayList<InstanceInfo>>(l);
                destMap.put(entries.getKey(), instanceInfoList);
            }
            instanceInfoList.set(l);
            vipIndexMap.put(entries.getKey(), new AtomicLong(0L));
        }
    }

    private void addInstanceToMap(InstanceInfo info, String vipAddresses, Map<String, AbstractQueue<InstanceInfo>> vipMap) {
        if (vipAddresses != null) {
            String[] vipAddressArray;
            for (String vipAddress : vipAddressArray = vipAddresses.split(",")) {
                String vipName = vipAddress.toUpperCase();
                AbstractQueue<InstanceInfo> instanceInfoList = vipMap.get(vipName);
                if (instanceInfoList == null) {
                    instanceInfoList = new ConcurrentLinkedQueue<InstanceInfo>();
                    vipMap.put(vipName, instanceInfoList);
                }
                instanceInfoList.add(info);
            }
        }
    }

    private void addInstancesToVIPMaps(Application app) {
        for (InstanceInfo info : app.getInstances()) {
            String vipAddresses = info.getVIPAddress();
            String secureVipAddresses = info.getSecureVipAddress();
            if (vipAddresses == null && secureVipAddresses == null) continue;
            this.addInstanceToMap(info, vipAddresses, this.virtualHostNameAppMap);
            this.addInstanceToMap(info, secureVipAddresses, this.secureVirtualHostNameAppMap);
        }
    }

    private static final class Pair {
        private String item_1;
        private String item_2;

        public Pair(String item_1, String item_2) {
            this.item_1 = item_1;
            this.item_2 = item_2;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.item_1 == null ? 0 : this.item_1.hashCode());
            result = 31 * result + (this.item_2 == null ? 0 : this.item_2.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair other = (Pair)obj;
            if (this.item_1 == null ? other.item_1 != null : !this.item_1.equals(other.item_1)) {
                return false;
            }
            return !(this.item_2 == null ? other.item_2 != null : !this.item_2.equals(other.item_2));
        }

        public String getItem_1() {
            return this.item_1;
        }

        public void setItem_1(String item_1) {
            this.item_1 = item_1;
        }

        public String getItem_2() {
            return this.item_2;
        }

        public void setItem_2(String item_2) {
            this.item_2 = item_2;
        }
    }
}

