/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters;

import com.netflix.discovery.converters.JsonXStream;
import com.netflix.discovery.converters.XmlXStream;
import com.netflix.discovery.provider.ISerializer;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.MediaType;

public class EntityBodyConverter
implements ISerializer {
    @Override
    public Object read(InputStream is, Class type, MediaType mediaType) throws IOException {
        XStream xstream = null;
        if (MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType)) {
            xstream = JsonXStream.getInstance();
        } else if (MediaType.APPLICATION_XML_TYPE.equals((Object)mediaType)) {
            xstream = XmlXStream.getInstance();
        }
        if (xstream != null) {
            return xstream.fromXML(is);
        }
        throw new IllegalArgumentException("Content-type: " + mediaType.getType() + " is currently not supported for " + type.getName());
    }

    @Override
    public void write(Object object, OutputStream os, MediaType mediaType) throws IOException {
        XStream xstream = null;
        if (MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType)) {
            xstream = JsonXStream.getInstance();
        } else if (MediaType.APPLICATION_XML_TYPE.equals((Object)mediaType)) {
            xstream = XmlXStream.getInstance();
        }
        if (xstream == null) {
            throw new IllegalArgumentException("Content-type: " + mediaType.getType() + " is currently not supported for " + object.getClass().getName());
        }
        xstream.toXML(object, os);
    }
}

