/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.providers.EurekaConfigBasedInstanceInfoProvider;
import com.netflix.discovery.StatusChangeEvent;
import com.netflix.governator.guice.lazy.FineGrainedLazySingleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FineGrainedLazySingleton
public class ApplicationInfoManager {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationInfoManager.class);
    private static ApplicationInfoManager instance = new ApplicationInfoManager();
    private InstanceInfo instanceInfo;
    private EurekaInstanceConfig config;
    protected Map<String, StatusChangeListener> listeners;

    private ApplicationInfoManager() {
        this.listeners = new ConcurrentHashMap<String, StatusChangeListener>();
    }

    @Inject
    public ApplicationInfoManager(EurekaInstanceConfig config, InstanceInfo instanceInfo) {
        this.config = config;
        this.instanceInfo = instanceInfo;
        this.listeners = new ConcurrentHashMap<String, StatusChangeListener>();
        instance = this;
    }

    @Deprecated
    public static ApplicationInfoManager getInstance() {
        return instance;
    }

    public void initComponent(EurekaInstanceConfig config) {
        try {
            this.config = config;
            this.instanceInfo = new EurekaConfigBasedInstanceInfoProvider(config).get();
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to initialize ApplicationInfoManager", e);
        }
    }

    public InstanceInfo getInfo() {
        return this.instanceInfo;
    }

    public void registerAppMetadata(Map<String, String> appMetadata) {
        this.instanceInfo.registerRuntimeMetadata(appMetadata);
    }

    public synchronized void setInstanceStatus(InstanceInfo.InstanceStatus status) {
        InstanceInfo.InstanceStatus prev = this.instanceInfo.setStatus(status);
        if (prev != null) {
            for (StatusChangeListener listener : this.listeners.values()) {
                try {
                    listener.notify(new StatusChangeEvent(prev, status));
                }
                catch (Exception e) {
                    logger.warn("failed to notify listener: {}", (Object)listener.getId(), (Object)e);
                }
            }
        }
    }

    public void registerStatusChangeListener(StatusChangeListener listener) {
        this.listeners.put(listener.getId(), listener);
    }

    public void unregisterStatusChangeListener(String listenerId) {
        this.listeners.remove(listenerId);
    }

    public void refreshDataCenterInfoIfRequired() {
        String existingHostname = this.instanceInfo.getHostName();
        String newHostname = this.config.getHostName(true);
        if (newHostname != null && !newHostname.equals(existingHostname)) {
            logger.warn("The public hostname changed from : " + existingHostname + " => " + newHostname);
            InstanceInfo.Builder builder = new InstanceInfo.Builder(this.instanceInfo);
            builder.setHostName(newHostname).setDataCenterInfo(this.config.getDataCenterInfo());
            this.instanceInfo.setIsDirty();
        }
    }

    public static interface StatusChangeListener {
        public String getId();

        public void notify(StatusChangeEvent var1);
    }
}

