/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitors;
import java.util.TimerTask;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedSupervisorTask
extends TimerTask {
    private static final Logger logger = LoggerFactory.getLogger(TimedSupervisorTask.class);
    private static final String PREFIX = "TimedSupervisorTask_";
    private final Counter TIMEOUT_COUNTER = Monitors.newCounter((String)"TimedSupervisorTask_Timeouts");
    private final Counter REJECTED_COUNTER = Monitors.newCounter((String)"TimedSupervisorTask_RejectedExecutions");
    private final Counter THROWABLE_COUNTER = Monitors.newCounter((String)"TimedSupervisorTask_Throwables");
    private final ThreadPoolExecutor executor;
    private final int timeoutSecs;
    private final Runnable task;

    public TimedSupervisorTask(ThreadPoolExecutor executor, int timeoutSecs, Runnable task) {
        this.executor = executor;
        this.timeoutSecs = timeoutSecs;
        this.task = task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Future<?> future = null;
        try {
            future = this.executor.submit(this.task);
            future.get(this.timeoutSecs, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            logger.error("task supervisor timed out", (Throwable)e);
            this.TIMEOUT_COUNTER.increment();
        }
        catch (RejectedExecutionException e) {
            logger.error("task supervisor rejected the task", (Throwable)e);
            this.REJECTED_COUNTER.increment();
        }
        catch (Throwable e) {
            logger.error("task supervisor threw an exception", e);
            this.THROWABLE_COUNTER.increment();
        }
        finally {
            if (future != null) {
                future.cancel(true);
            }
        }
    }
}

