/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import java.io.IOException;
import javax.inject.Provider;

public class JsonMapperProvider
implements Provider<ObjectMapper> {
    public ObjectMapper get() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
        objectMapper.setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.ALWAYS));
        objectMapper.registerModule((Module)new JsonProtoModule());
        return objectMapper;
    }

    private static class JsonProtoModule
    extends SimpleModule {
        private static final String JSON_TYPE = "@type";
        private static final String JSON_VALUE = "@value";

        public JsonProtoModule() {
            super("ConductorJsonProtoModule");
            this.addSerializer(Any.class, new AnySerializer());
            this.addDeserializer(Any.class, new AnyDeserializer());
        }

        protected class AnyDeserializer
        extends JsonDeserializer<Any> {
            protected AnyDeserializer() {
            }

            public Any deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                JsonNode root = (JsonNode)p.getCodec().readTree(p);
                JsonNode type = root.get(JsonProtoModule.JSON_TYPE);
                JsonNode value = root.get(JsonProtoModule.JSON_VALUE);
                if (type == null || !type.isTextual()) {
                    ctxt.reportMappingException("invalid '@type' field when deserializing ProtoBuf Any object", new Object[0]);
                }
                if (value == null || !value.isTextual()) {
                    ctxt.reportMappingException("invalid '@value' field when deserializing ProtoBuf Any object", new Object[0]);
                }
                return Any.newBuilder().setTypeUrl(type.textValue()).setValue(ByteString.copyFrom((byte[])value.binaryValue())).build();
            }
        }

        protected class AnySerializer
        extends JsonSerializer<Any> {
            protected AnySerializer() {
            }

            public void serialize(Any value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeStartObject();
                jgen.writeStringField(JsonProtoModule.JSON_TYPE, value.getTypeUrl());
                jgen.writeBinaryField(JsonProtoModule.JSON_VALUE, value.getValue().toByteArray());
                jgen.writeEndObject();
            }
        }
    }
}

