/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.servlet;

import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.limiter.AbstractLimiterBuilder;
import com.netflix.concurrency.limits.strategy.LookupPartitionStrategy;
import java.security.Principal;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;

public final class ServletLimiterBuilder
extends AbstractLimiterBuilder<ServletLimiterBuilder, HttpServletRequest> {
    public ServletLimiterBuilder partitionByHeader(String name, Consumer<LookupPartitionStrategy.Builder<HttpServletRequest>> configurer) {
        return (ServletLimiterBuilder)this.partitionByLookup(request -> Optional.ofNullable(request.getHeader(name)).orElse(null), configurer);
    }

    public ServletLimiterBuilder partitionByUserPrincipal(Function<Principal, String> principalToGroup, Consumer<LookupPartitionStrategy.Builder<HttpServletRequest>> configurer) {
        return (ServletLimiterBuilder)this.partitionByLookup(request -> Optional.ofNullable(request.getUserPrincipal()).map(principalToGroup).orElse(null), configurer);
    }

    public ServletLimiterBuilder partitionByAttribute(String name, Consumer<LookupPartitionStrategy.Builder<HttpServletRequest>> configurer) {
        return (ServletLimiterBuilder)this.partitionByLookup(request -> Optional.ofNullable(request.getAttribute(name)).map(Object::toString).orElse(null), configurer);
    }

    public ServletLimiterBuilder partitionByParameter(String name, Consumer<LookupPartitionStrategy.Builder<HttpServletRequest>> configurer) {
        return (ServletLimiterBuilder)this.partitionByLookup(request -> Optional.ofNullable(request.getParameter(name)).orElse(null), configurer);
    }

    public ServletLimiterBuilder partitionByPathInfo(Function<String, String> pathToGroup, Consumer<LookupPartitionStrategy.Builder<HttpServletRequest>> configurer) {
        return (ServletLimiterBuilder)this.partitionByLookup(request -> Optional.ofNullable(request.getPathInfo()).map(pathToGroup).orElse(null), configurer);
    }

    protected ServletLimiterBuilder self() {
        return this;
    }

    public Limiter<HttpServletRequest> build() {
        return this.buildLimiter();
    }
}

