/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nis.bugrpt.tool;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Process;
import android.util.Log;
import com.netease.nis.bugrpt.tool.AESCrypt;
import com.netease.nis.bugrpt.tool.ExtroInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONObject;

public class Common {
    public static final long VALID_BUGRPT_SIZE = 1024L;

    public static void sleep(long ms) {
        try {
            TimeUnit.MILLISECONDS.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static boolean isNetworkAvailable(Context context) {
        try {
            ConnectivityManager mgr = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo[] info = mgr.getAllNetworkInfo();
            if (info != null) {
                for (int i = 0; i < info.length; ++i) {
                    if (info[i].getState() != NetworkInfo.State.CONNECTED) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(String filePath) {
        String buffer = "";
        BufferedReader br = null;
        try {
            if (Common.checkFileExist(filePath)) {
                br = new BufferedReader(new FileReader(filePath));
                String line = br.readLine();
                buffer = buffer + line;
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception fnfe) {}
            }
        }
        return buffer;
    }

    public static boolean checkFileExist(String filePath) {
        File logfile;
        return filePath != null && (logfile = new File(filePath)).exists();
    }

    private static String getThreadName(int tid) {
        String threadName = "";
        if (tid <= 0) {
            return threadName;
        }
        int pid = Process.myPid();
        Log.d((String)"bugrpt", (String)("pid:" + pid));
        if (pid == tid) {
            threadName = "main";
        } else {
            String path = "/proc/" + pid + "/task/" + tid + "/comm";
            threadName = Common.readFile(path);
        }
        Log.d((String)"bugrpt", (String)("getTidName:" + threadName));
        return threadName;
    }

    public static String getJavaStackTrace(int tid) {
        String javaStack = "";
        try {
            String tidName = Common.getThreadName(tid);
            if (!tidName.equals("")) {
                JSONArray threadStack = ExtroInfo.getAllThreadStack();
                for (int i = 0; i < threadStack.length(); ++i) {
                    JSONObject obj = (JSONObject)threadStack.get(i);
                    String strThreadName = obj.getString("name");
                    if (!strThreadName.contains(tidName)) continue;
                    Log.d((String)"bugrpt", (String)("threadName:" + strThreadName + " tidName:" + tidName));
                    javaStack = obj.getString("stack");
                    Log.d((String)"bugrpt", (String)("java:" + javaStack));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return javaStack;
    }

    public static String exceptionToString(Throwable ex) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        ex.printStackTrace(printWriter);
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            cause.printStackTrace(printWriter);
        }
        printWriter.close();
        String crashInfo = ((Object)writer).toString();
        return crashInfo;
    }

    public static long getFileSize(File f) throws Exception {
        long size = 0L;
        if (f != null && f.exists()) {
            FileInputStream fis = new FileInputStream(f);
            size = fis.available();
        }
        return size;
    }

    public static boolean isSoValid(String path) {
        boolean bRet = false;
        try {
            File f = new File(path);
            if (f != null && f.exists() && Common.getFileSize(f) >= 1024L) {
                bRet = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bRet;
    }

    public static String encryptData(String origData) {
        String out = "";
        try {
            String encPas = "060819575325440737561e1e2533181c";
            out = AESCrypt.encrypt(AESCrypt.decryptStr(encPas), origData);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    public static boolean isNullOrNil(String object) {
        return object == null || object.length() <= 0;
    }

    private static void decodeJSONArray(JSONArray jarray) {
        try {
            int length = jarray.length();
            for (int i = 0; i < length; ++i) {
                Object o = jarray.get(i);
                if (o instanceof JSONObject) {
                    Common.decodeJSONObject((JSONObject)o);
                    continue;
                }
                if (o instanceof JSONArray) {
                    Common.decodeJSONArray((JSONArray)o);
                    continue;
                }
                if (o instanceof String) {
                    Log.d((String)"bugrpt", (String)(o + "(" + ((String)o).length() + ")"));
                    continue;
                }
                Log.d((String)"bugrpt", (String)("Unknown type:" + o.getClass().getName()));
            }
        }
        catch (Exception e) {
            Log.d((String)"bugrpt", (String)("Exception in decodeJSONArray:" + e.toString()));
        }
    }

    public static void decodeJSONObject(JSONObject json) {
        try {
            Iterator keys = json.keys();
            JSONObject jo = null;
            JSONArray ja = null;
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object o = json.get(key);
                if (o instanceof JSONObject) {
                    jo = (JSONObject)o;
                    Common.decodeJSONObject(jo);
                    continue;
                }
                if (o instanceof JSONArray) {
                    ja = (JSONArray)o;
                    Common.decodeJSONArray(ja);
                    continue;
                }
                if (o instanceof String) {
                    Log.d((String)"bugrpt", (String)(key + ":" + o + "(" + ((String)o).length() + ")"));
                    continue;
                }
                Log.d((String)"bugrpt", (String)("Unknown type:" + o.getClass().getName()));
            }
        }
        catch (Exception e) {
            Log.d((String)"bugrpt", (String)("Exception in decodeJSONObject:" + e.toString()));
        }
    }

    public static boolean isInMidNight() {
        try {
            long nowtime = System.currentTimeMillis();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
            long todaytime = simpleDateFormat.parse(simpleDateFormat.format(new Date())).getTime();
            return todaytime < nowtime && nowtime < todaytime + 300000L;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String truncateUserInput(String input, int nMaxLen) {
        String out = input;
        if (out.length() >= nMaxLen) {
            out = out.substring(0, nMaxLen);
        }
        return out;
    }

    public static StringBuilder generateLogSuffix() {
        StringBuilder suffix = new StringBuilder();
        SimpleDateFormat sDateFormat = new SimpleDateFormat("MM-dd HH:mm:ss");
        String date = sDateFormat.format(new Date());
        int pid = Process.myPid();
        int tid = Process.myTid();
        suffix.append(date).append(" ").append(pid).append(" ").append(tid);
        suffix.append(" I bugrpt:");
        return suffix;
    }
}

