/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nis.bugrpt.tool;

import android.util.Log;
import com.netease.nis.bugrpt.tool.Common;
import com.netease.nis.bugrpt.tool.HttpUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class CacheHelper {
    private static CacheHelper INSTANCE;
    private ReentrantLock lock = new ReentrantLock();
    private long delayTime = 20000L;

    private CacheHelper() {
    }

    public static CacheHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CacheHelper();
        }
        return INSTANCE;
    }

    public void setDelayTime(long time) {
        this.delayTime = time * 1000L;
    }

    public void checkCrashLog(String fileDir) {
        if (Common.checkFileExist(fileDir)) {
            ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
            CheckLogThread upThread = new CheckLogThread(fileDir);
            executorService.schedule(upThread, this.delayTime, TimeUnit.MILLISECONDS);
        } else {
            Log.d((String)"bugrpt", (String)("checkCrashLog:" + fileDir + " not exists"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readCrashLog(String filePath) {
        StringBuffer crashBuffer = new StringBuffer();
        String line = "";
        BufferedReader br = null;
        try {
            this.lock.lock();
            br = new BufferedReader(new FileReader(filePath));
            while ((line = br.readLine()) != null) {
                crashBuffer.append(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.lock.unlock();
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return crashBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeCrashLog(String text, String logDir) {
        boolean bRet = false;
        if (logDir == null || logDir.equals("") || text.equals("")) {
            return bRet;
        }
        File dir = new File(logDir);
        if (!dir.exists()) {
            dir.mkdir();
        }
        long cur = System.currentTimeMillis();
        StringBuffer logPath = new StringBuffer();
        logPath.append(logDir).append(File.separator).append("log").append(Long.valueOf(cur).toString());
        BufferedWriter bw = null;
        try {
            this.lock.lock();
            File logfile = new File(logPath.toString());
            if (!logfile.exists()) {
                logfile.createNewFile();
            }
            bw = new BufferedWriter(new FileWriter(logfile, false));
            bw.write(text);
            bw.newLine();
            bw.flush();
            bRet = true;
            Log.d((String)"bugrpt", (String)("post data cached:" + logPath.toString()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.lock.unlock();
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bRet;
    }

    public class CheckLogThread
    extends Thread
    implements Runnable {
        private static final int MAX_CONTENT_LEN = 204800;
        private static final int MAX_SENDCNT = 10;
        private String uploadDir;

        public CheckLogThread(String dir) {
            this.uploadDir = dir;
        }

        @Override
        public void run() {
            try {
                Log.d((String)"bugrpt", (String)"CheckLogThread Start...");
                int nHaveSend = 0;
                File logDir = new File(this.uploadDir);
                File[] listFiles = logDir.listFiles();
                if (listFiles != null && listFiles.length > 0) {
                    for (File f : listFiles) {
                        if (!f.isFile()) continue;
                        String fName = f.getAbsolutePath();
                        String buf = CacheHelper.this.readCrashLog(fName);
                        if (buf.length() < 204800) {
                            if (HttpUtil.send(buf, HttpUtil.DataType.CRASHINFO_UPLOAD, true)) {
                                f.delete();
                                Log.d((String)"bugrpt", (String)"cache send success");
                                if (++nHaveSend <= 10) continue;
                                break;
                            }
                            Log.d((String)"bugrpt", (String)"cache send failed");
                            break;
                        }
                        f.delete();
                    }
                }
                Log.d((String)"bugrpt", (String)"CheckLogThread end");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

