/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nis.bugrpt.init;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.netease.nis.bugrpt.tool.AppInfo;
import com.netease.nis.bugrpt.tool.Common;
import com.netease.nis.bugrpt.tool.DeviceInfo;
import com.netease.nis.bugrpt.tool.HttpUtil;
import com.netease.nis.bugrpt.user.UserStrategy;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONObject;

public class InitTask
implements Runnable {
    private Context mContext = null;
    private UserStrategy mUserStrategy = null;
    private static boolean mbEncoded = true;
    private JSONObject mVersion = new JSONObject();

    public InitTask(Context ctx) {
        this.mContext = ctx;
    }

    public InitTask setSdkVersion(JSONObject version) {
        this.mVersion = version;
        return this;
    }

    public InitTask setUserStrategy(UserStrategy userStrategy) {
        this.mUserStrategy = userStrategy;
        return this;
    }

    @Override
    public void run() {
        try {
            Log.d((String)"bugrpt", (String)"InitTask Start...");
            String uploadMsg = this.getStartupPostData();
            boolean bRet = HttpUtil.send(uploadMsg, HttpUtil.DataType.INITINFO_UPLOAD, true);
            if (bRet) {
                Log.d((String)"bugrpt", (String)"InitTask success");
            } else {
                Log.d((String)"bugrpt", (String)"InitTask failed");
            }
            Log.d((String)"bugrpt", (String)"InitTask end");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isAppAleadyStartup() {
        boolean bRet = false;
        try {
            SharedPreferences preferences = this.mContext.getSharedPreferences("InitTag", 0);
            String date = preferences.getString("date", "");
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA);
            String today = dateformat.format(calendar.getTime());
            if (date.equals(today)) {
                bRet = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bRet;
    }

    private void saveInitTag() {
        try {
            SharedPreferences preferences = this.mContext.getSharedPreferences("InitTag", 0);
            SharedPreferences.Editor editor = preferences.edit();
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA);
            String today = dateformat.format(calendar.getTime());
            editor.putString("date", today);
            editor.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getInitDataInfo() {
        String proDataInfo = "";
        JSONObject djson = new JSONObject();
        try {
            AppInfo appInfo = new AppInfo();
            String appver = this.mUserStrategy.getAppVersion(this.mContext);
            Log.d((String)"bugrpt", (String)("app version:" + appver));
            String appname = appInfo.getApplicationName(this.mContext);
            String packageName = this.mContext.getPackageName();
            DeviceInfo deviceInfo = new DeviceInfo();
            String imei = deviceInfo.getImei(this.mContext);
            String osversion = deviceInfo.getOsVersion();
            String deviceType = deviceInfo.getDeviceType(this.mContext);
            String model = deviceInfo.getModel();
            String company = deviceInfo.getCompany();
            String mac = deviceInfo.getMacAdderss(this.mContext);
            String network = deviceInfo.getNetworkType(this.mContext);
            String carrier = deviceInfo.getSimCarrier(this.mContext);
            String daid = deviceInfo.getDaid(this.mContext);
            String androidId = deviceInfo.getAndroid_id(this.mContext);
            String openUdid = deviceInfo.getOpenUDID(this.mContext);
            djson.put("appname", (Object)appname);
            djson.put("appver", (Object)appver);
            djson.put("packagename", (Object)packageName);
            djson.put("imei", (Object)imei);
            djson.put("mac", (Object)mac);
            djson.put("daid", (Object)daid);
            djson.put("android_id", (Object)androidId);
            djson.put("open_uuid", (Object)openUdid);
            djson.put("os", (Object)"Android");
            djson.put("osversion", (Object)osversion);
            djson.put("device", (Object)deviceType);
            djson.put("model", (Object)model);
            djson.put("company", (Object)company);
            djson.put("carrier", (Object)carrier);
            djson.put("network", (Object)network);
            djson.put("sdkversion", (Object)this.mVersion);
            proDataInfo = mbEncoded ? Common.encryptData(djson.toString()) : djson.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return proDataInfo;
    }

    private String getStartupPostData() {
        String data = "";
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            String appid = this.mUserStrategy.getAppID(this.mContext);
            String protcolHdr = HttpUtil.getProtocolHeaderData(appid, mbEncoded);
            String initData = this.getInitDataInfo();
            params.put("head", protcolHdr);
            params.put("data", initData);
            data = HttpUtil.fmtPostData(params, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }
}

