/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nis.bugrpt.init;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;

public class ActivityStatusMonitor {
    private static Application.ActivityLifecycleCallbacks mactivityLifecycleCallbacks = null;
    private int activityCount = 0;
    private Context mContext = null;

    public ActivityStatusMonitor(Context context) {
        this.mContext = context;
        this.registerActiLifeCallbacks();
    }

    private void registerActiLifeCallbacks() {
        Application application = null;
        if (Build.VERSION.SDK_INT >= 14) {
            if (this.mContext.getApplicationContext() instanceof Application) {
                application = (Application)this.mContext.getApplicationContext();
            }
            if (application != null) {
                try {
                    if (mactivityLifecycleCallbacks == null) {
                        mactivityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

                            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                            }

                            public void onActivityStarted(Activity activity) {
                                ActivityStatusMonitor.this.activityCount++;
                            }

                            public void onActivityResumed(Activity activity) {
                            }

                            public void onActivityPaused(Activity activity) {
                            }

                            public void onActivityStopped(Activity activity) {
                                ActivityStatusMonitor.this.activityCount--;
                            }

                            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                            }

                            public void onActivityDestroyed(Activity activity) {
                            }
                        };
                    }
                    application.registerActivityLifecycleCallbacks(mactivityLifecycleCallbacks);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void unregisterActiLifeCallbacks(Context context) {
        if (Build.VERSION.SDK_INT >= 14) {
            Application application = null;
            if (context.getApplicationContext() instanceof Application) {
                application = (Application)context.getApplicationContext();
            }
            if (application != null) {
                try {
                    if (mactivityLifecycleCallbacks != null) {
                        application.unregisterActivityLifecycleCallbacks(mactivityLifecycleCallbacks);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private boolean InForegroundByStackTrace() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        boolean isForeground = false;
        for (int j = 0; j < stackTrace.length; ++j) {
            StackTraceElement stackTraceElement = stackTrace[j];
            if (!stackTraceElement.getClassName().equals("android.app.Activity")) continue;
            isForeground = true;
        }
        return isForeground;
    }

    public boolean isAppBackground() {
        return this.activityCount == 0 && !this.InForegroundByStackTrace();
    }
}

