/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nis.bugrpt.crash.anr;

import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.netease.nis.bugrpt.crash.anr.AnrMonitor;
import com.netease.nis.bugrpt.tool.Common;
import java.io.File;

public class AnrWatchThread
extends Thread {
    private static final int DEFAULT_ANR_TIMEOUT = 5000;
    private static final int WAIT_ANR_TIMEOUT = 20000;
    private static final String TRACE_PATH_FILE = "/data/anr/traces.txt";
    private final Handler _uiHandler = new Handler(Looper.getMainLooper());
    private int _timeoutInterval;
    private boolean _ignoreDebugger = false;
    private volatile int _tick = 0;
    private final Runnable _ticker = new Runnable(){

        @Override
        public void run() {
            AnrWatchThread.this._tick = (AnrWatchThread.this._tick + 1) % Integer.MAX_VALUE;
        }
    };
    private AnrMonitor _monitor = null;
    private long _lastModifyTime = 0L;

    public AnrWatchThread(AnrMonitor monitor) {
        this._monitor = monitor;
        this._timeoutInterval = 5000;
        this._lastModifyTime = this.getAnrTraceFileModifyTime();
    }

    private long getAnrTraceFileModifyTime() {
        long time = 0L;
        File f = new File(TRACE_PATH_FILE);
        if (f != null && f.exists()) {
            time = f.lastModified();
        }
        return time;
    }

    private boolean isAnrTraceReadable() {
        boolean bReadable = false;
        File f = new File(TRACE_PATH_FILE);
        if (f != null && f.exists()) {
            bReadable = f.canRead();
        }
        Log.d((String)"bugrpt", (String)("isAnrTraceReadable:" + bReadable));
        return bReadable;
    }

    public AnrWatchThread setTimeoutInterval(int timeoutInterval) {
        this._timeoutInterval = timeoutInterval;
        return this;
    }

    public AnrWatchThread setIgnoreDebugger(boolean ignoreDebugger) {
        this._ignoreDebugger = ignoreDebugger;
        return this;
    }

    @Override
    public void run() {
        if (!this.isAnrTraceReadable()) {
            return;
        }
        this.setName("|ANR-WatchThread|");
        int lastIgnored = -1;
        while (!this.isInterrupted()) {
            int lastTick = this._tick;
            this._uiHandler.post(this._ticker);
            Common.sleep(this._timeoutInterval);
            if (this._tick != lastTick) continue;
            if (!this._ignoreDebugger && Debug.isDebuggerConnected()) {
                if (this._tick != lastIgnored) {
                    Log.d((String)"bugrpt", (String)"An ANR was detected but ignored because the debugger is connected");
                }
                lastIgnored = this._tick;
                continue;
            }
            long cnt = 40L;
            int i = 0;
            do {
                if (this.isAnrTraceModified()) {
                    if (this._monitor == null) break;
                    this._monitor.onNotifyAnrEvent(TRACE_PATH_FILE);
                    break;
                }
                Common.sleep(500L);
            } while ((long)i++ <= 40L);
            return;
        }
    }

    private boolean isAnrTraceModified() {
        boolean bRet = false;
        long lastModifyTime = this.getAnrTraceFileModifyTime();
        if (lastModifyTime != 0L && this._lastModifyTime != 0L && lastModifyTime != this._lastModifyTime) {
            bRet = true;
            Log.d((String)"bugrpt", (String)("trace file changed:" + lastModifyTime + " orig:" + this._lastModifyTime));
        } else {
            Log.d((String)"bugrpt", (String)("current:" + lastModifyTime + " orig:" + this._lastModifyTime));
        }
        return bRet;
    }
}

