/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nis.bugrpt.crash.JS;

import android.util.Log;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.netease.nis.bugrpt.CrashHandler;
import com.netease.nis.bugrpt.crash.CrashDetailBean;
import java.util.HashMap;
import org.json.JSONObject;

public class H5JavaScriptInterface {
    private static HashMap<H5JavaScriptInterface, WebView> webViewHashMap = new HashMap();
    private String mJsCrashreport = "";
    private String mjavaStackTrace = null;
    private String mwebdescription = null;
    private String jsStackTrace = null;
    private Thread mthread = null;

    private H5JavaScriptInterface() {
    }

    public static H5JavaScriptInterface getInstance(WebView webView) {
        if (webViewHashMap.values().contains(webView)) {
            return null;
        }
        H5JavaScriptInterface h5JavaScriptInterface = new H5JavaScriptInterface();
        webViewHashMap.put(h5JavaScriptInterface, webView);
        h5JavaScriptInterface.mthread = Thread.currentThread();
        h5JavaScriptInterface.mjavaStackTrace = H5JavaScriptInterface.getjavaStack(h5JavaScriptInterface.mthread);
        h5JavaScriptInterface.mwebdescription = H5JavaScriptInterface.getWebDescription(webView);
        Log.d((String)"bugrpt", (String)("mjavaStackTrace:" + h5JavaScriptInterface.mjavaStackTrace));
        Log.d((String)"bugrpt", (String)("mwebdescription:" + h5JavaScriptInterface.mwebdescription));
        return h5JavaScriptInterface;
    }

    private static String getjavaStack(Thread thread) {
        if (thread == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (int i = 2; i < thread.getStackTrace().length; ++i) {
            StackTraceElement stackTraceElement = thread.getStackTrace()[i];
            String stackTrace = stackTraceElement.toString();
            if (stackTrace.contains("bugrpt")) continue;
            sb.append(stackTrace).append("\n");
        }
        return sb.toString();
    }

    private static String getWebDescription(WebView webView) {
        String webdescription = "";
        webdescription = webdescription + webView.getContentDescription();
        return webdescription;
    }

    private String setExtraInfo(String strjson) {
        if (strjson == null || strjson.length() <= 0) {
            return "";
        }
        StringBuilder info = new StringBuilder("");
        try {
            JSONObject jsonObject = new JSONObject(strjson);
            String projectRoot = jsonObject.getString("projectRoot");
            info.append("[projectRoot] = " + projectRoot + "\n");
            String context = jsonObject.getString("context");
            info.append("[context] = " + context + "\n");
            String url = jsonObject.getString("url");
            info.append("[url] = " + url + "\n");
            String userAgent = jsonObject.getString("userAgent");
            info.append("[userAgent] = " + userAgent + "\n");
            String language = jsonObject.getString("language");
            info.append("[language] = " + language + "\n");
            String name = jsonObject.getString("name");
            info.append("[name] = " + name + "\n");
            String stacktrace = jsonObject.getString("stacktrace");
            this.jsStackTrace = stacktrace + "\n";
            String file = jsonObject.getString("file");
            info.append("[file] = " + file + "\n");
            long lineNumber = jsonObject.getLong("lineNumber");
            info.append("[lineNumber] = " + Long.toString(lineNumber) + "\n");
            long columnNumber = jsonObject.getLong("columnNumber");
            info.append("[columnNumber]  = " + Long.toString(columnNumber) + "\n");
        }
        catch (Exception e) {
            return "";
        }
        return info.toString();
    }

    @JavascriptInterface
    public void printLog(String log) {
        Log.d((String)"bugrpt", (String)("Log from js: " + log));
    }

    @JavascriptInterface
    public void reportJSException(String payload) {
        if (null == payload) {
            return;
        }
        if (this.mJsCrashreport != null && this.mJsCrashreport.equals(payload)) {
            return;
        }
        this.mJsCrashreport = payload;
        try {
            String extra = this.setExtraInfo(this.mJsCrashreport);
            if (!extra.equals("")) {
                StringBuilder info = new StringBuilder();
                info.append(this.jsStackTrace).append(extra).append("javaStack:").append(this.mjavaStackTrace);
                CrashDetailBean bean = new CrashDetailBean(info.toString()).setPlatformTag("js").setExceptionType("exception");
                if (CrashHandler.getInstance().asySendReportToServer(bean)) {
                    Log.d((String)"bugrpt", (String)"send JS success!");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

