package com.netcore.android.notification

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.util.Log
import com.netcore.android.notification.services.SMTScheduledNotificationService

/**
 * Copyright © 2019 Netcore. All rights reserved.
 *
 * Handles the incoming notification
 *
 * @author Netcore
 * @version 1.0
 * @since 26-02-2019
 */

class SMTScheduledPNReceiver : BroadcastReceiver() {
    val TAG: String = SMTScheduleNotification::class.java.simpleName
    override fun onReceive(context: Context?, intent: Intent?) {
        Log.d(TAG, "SMTScheduledPNReceiver on received")
        intent?.let { scheduleIntent ->
            if (context != null) {
                SMTScheduledNotificationService.enqueWork(context, intent)
            }
        }
    }
}
