package com.netcore.android.mediadownloader

import android.content.Context
import android.os.AsyncTask
import com.netcore.android.notification.SMTNotificationType
import com.netcore.android.notification.models.SMTNotificationData
import java.lang.ref.WeakReference

/**
 * Async taskt o download the media file from notifications which is not carousel
 *
 */
internal class SMTSingleMediaDownloadAsyncTask(val context: WeakReference<Context>, val notification: SMTNotificationData, val listener: SMTMediaDownloadManager.AsyncDownloadListener) : AsyncTask<Unit, Unit, SMTNotificationData>() {

    override fun doInBackground(vararg p0: Unit?): SMTNotificationData? {
        if (context.get() != null) {
            downloadMedia(notification, context.get()!!)
        }
        return notification
    }

    private fun downloadMedia(notification: SMTNotificationData, context: Context) {
        var filePath: String?
        if (notification.mNotificationType == SMTNotificationType.BIG_IMAGE.type) {
            filePath = SMTImageDownloader(context, notification.mMediaUrl, notification.mNotificationType
                    ?: "", notification.mIsForInbox).download()
        } else {
            filePath = SMTFileDownloader(context, notification.mMediaUrl, notification.mNotificationType
                    ?: "", notification.mIsForInbox).download()
        }
        notification.mDownloadStatus = SMTMediaDownloadManager.DownloadStatus.FAILED.value
        filePath?.let {
            notification.mMediaLocalPath = it
            notification.mDownloadStatus = SMTMediaDownloadManager.DownloadStatus.COMPLETED.value
        }

    }


    override fun onPostExecute(notification: SMTNotificationData) {
        super.onPostExecute(notification)
        return if (notification.mDownloadStatus == SMTMediaDownloadManager.DownloadStatus.COMPLETED.value) {
            listener.onDownloadSuccess()
        } else {
            listener.onDownloadError()
        }
    }

}