package com.netcore.android.notification.models

import android.os.Parcel
import android.os.Parcelable

/**
 * Copyright © 2019 Netcore. All rights reserved.
 *
 * Class holds Notification custom payload Data
 *
 * @author Netcore
 * @version 1.0
 * @since 26-02-2019
 */
internal class SMTNotifCustomPayload(var city: String?, var state: String?, var country: String?) : Parcelable {
    constructor(parcel: Parcel) : this(
            parcel.readString(),
            parcel.readString(),
            parcel.readString())

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeString(city)
        parcel.writeString(state)
        parcel.writeString(country)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<SMTNotifCustomPayload> {
        override fun createFromParcel(parcel: Parcel): SMTNotifCustomPayload {
            return SMTNotifCustomPayload(parcel)
        }

        override fun newArray(size: Int): Array<SMTNotifCustomPayload?> {
            return arrayOfNulls(size)
        }
    }

}