@file:Suppress("UNCHECKED_CAST")

package com.netcore.android.notification.carousel

import android.os.Parcel
import android.os.Parcelable
import com.netcore.android.notification.models.SMTCarouselItemData


/**
 * Copyright © 2019 Netcore. All rights reserved.
 *
 * Carousel data parcel class
 *
 * @author Netcore
 * @version 1.0
 * @since 26-02-2019
 */
internal class SMTCarouselSetup(var trid: String?,
                                var notifType: String?,
                                var source: Int,
                                var carouselItems: ArrayList<SMTCarouselItemData>?,
                                var contentTitle: String?,
                                var contentText: String?,
                                var bigContentTitle: String?,
                                var bigContentText: String?,
                                var contentSubtitle: String?,
                                var deeplink: String?,
                                var pnMeta: String,
                                var carouselNotificationId: Int = 0,
                                var currentStartIndex: Int = 0,
                                var smallIconResourceId: Int = -1,
                                var largeIconId: Int = -1,
                                var carouselPlaceHolderId: Int = -1,
                                var leftItem: SMTCarouselItemData?,
                                var rightItem: SMTCarouselItemData?,
                                var isImagesInCarousel: Boolean,
                                var customPayload: HashMap<String, Any>?,
                                var smtAttributePayload: HashMap<String, String>?,
                                var mSound: Boolean,
                                var mSoundFile: String?,
                                var mChannelId: String?,
                                var mIsScheduledPN: Int
) : Parcelable {

    constructor(parcel: Parcel) : this(
            parcel.readString(),
            parcel.readString(),
            parcel.readInt(),
            readCarouselItem(parcel),
            parcel.readString(),
            parcel.readString(),
            parcel.readString(),
            parcel.readString(),
            parcel.readString(),
            parcel.readString(),
            parcel.readString(),
            parcel.readInt(),
            parcel.readInt(),
            parcel.readInt(),
            parcel.readInt(),
            parcel.readInt(),
            parcel.readParcelable(SMTCarouselItemData::class.java.classLoader) as? SMTCarouselItemData,
            parcel.readParcelable(SMTCarouselItemData::class.java.classLoader) as? SMTCarouselItemData,
            parcel.readByte() != 0.toByte(),
            parcel.readSerializable() as? HashMap<String, Any>,
            parcel.readSerializable() as? HashMap<String, String>,
            parcel.readByte() != 0.toByte(),
            parcel.readString(),
            parcel.readString(),
            parcel.readInt()

    )


    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeString(trid)
        parcel.writeString(notifType)
        parcel.writeInt(source)
        parcel.writeTypedList(carouselItems)
        parcel.writeString(contentTitle)
        parcel.writeString(contentText)
        parcel.writeString(bigContentTitle)
        parcel.writeString(bigContentText)
        parcel.writeString(contentSubtitle)
        parcel.writeString(deeplink)
        parcel.writeString(pnMeta)
        parcel.writeInt(carouselNotificationId)
        parcel.writeInt(currentStartIndex)
        parcel.writeInt(smallIconResourceId)
        parcel.writeInt(largeIconId)
        parcel.writeInt(carouselPlaceHolderId)
        parcel.writeParcelable(leftItem, flags)
        parcel.writeParcelable(rightItem, flags)
        parcel.writeByte(if (isImagesInCarousel) 1 else 0)
        parcel.writeSerializable(customPayload)
        parcel.writeSerializable(smtAttributePayload)
        parcel.writeByte(if (mSound) 1 else 0)
        parcel.writeString(mSoundFile)
        parcel.writeString(mChannelId)
        parcel.writeInt(mIsScheduledPN)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object {
        //        var notificationPriority = NotificationCompat.PRIORITY_DEFAULT
        @JvmField
        val CREATOR = object : Parcelable.Creator<SMTCarouselSetup> {
            override fun createFromParcel(parcel: Parcel): SMTCarouselSetup {
                return SMTCarouselSetup(parcel)
            }

            override fun newArray(size: Int): Array<SMTCarouselSetup?> {
                return arrayOfNulls(size)
            }
        }

        private fun readCarouselItem(parcel: Parcel): ArrayList<SMTCarouselItemData>? {
            val carouselItems = ArrayList<SMTCarouselItemData>()
            parcel.readTypedList(carouselItems, SMTCarouselItemData.CREATOR)
            return carouselItems
        }
    }
}