package com.netcore.android.network.parser

import com.netcore.android.SMTConfigConstants
import com.netcore.android.Smartech
import com.netcore.android.inapp.SMTInAppRuleParser
import com.netcore.android.logger.SMTLogger
import com.netcore.android.network.SMTHttpRequestClient
import com.netcore.android.network.models.SMTSdkInitializeResponse
import org.json.JSONObject

/**
 * @author Netcore
 * created on 26/02/2019
 * @Description: SDK Initialization response parser
 */
internal class SMTSdkInitParser {

    private val TAG = SMTSdkInitParser::class.java.simpleName
    internal fun parse(networkResponse: SMTHttpRequestClient.NetworkResponse): SMTSdkInitializeResponse {

        var sdkInitResponse = SMTSdkInitializeResponse()
        sdkInitResponse.smtApiTypeID = networkResponse.apiID
        try {

            if (networkResponse.response == null) {
                SMTLogger.w("SMTSdkInitParser", " Init api response is null.")
                return sdkInitResponse
            }

            val jsonObject = networkResponse.response?.let {
                JSONObject(networkResponse.response)
            } ?: JSONObject()

            try {
                sdkInitResponse.smartechSettings = SMTSdkInitializeResponse.SmartTechSettings()

                val smartTechSettingJson = jsonObject.optJSONObject("smartechSettings")

                try {
                    var batchInterval = smartTechSettingJson.optInt("batchInterval")
                    if (batchInterval < 5) {
                        batchInterval = 5
                    }
                    sdkInitResponse.smartechSettings?.batchInterval = batchInterval

                } catch (e: Exception) {
                    SMTLogger.e(TAG, e.message.toString())
                }

                try {
                    var batchSize = smartTechSettingJson.optInt("batchSize")
                    if (batchSize < 1) {
                        batchSize = 1
                    }
                    sdkInitResponse.smartechSettings?.batchSize = batchSize
                } catch (e: Exception) {
                    SMTLogger.e(TAG, e.message.toString())
                }

                try {

                    sdkInitResponse.smartechSettings?.fetchLocation = smartTechSettingJson.optBoolean("fetchLocation")
                } catch (e: Exception) {
                    SMTLogger.e(TAG, e.message.toString())
                }

                try {

                    sdkInitResponse.smartechSettings?.paEnabled = smartTechSettingJson.optBoolean("paEnabled")
                } catch (e: Exception) {
                    SMTLogger.e(TAG, e.message.toString())
                }

                try {

                    sdkInitResponse.smartechSettings?.paInterval = smartTechSettingJson.optInt("paInterval")
                } catch (e: Exception) {
                    SMTLogger.e(TAG, e.message.toString())
                }

                try {

                    sdkInitResponse.smartechSettings?.panelActive = smartTechSettingJson.optBoolean("panelActive")
                } catch (e: Exception) {
                    SMTLogger.e(TAG, e.message.toString())
                }

                try {

                    sdkInitResponse.smartechSettings?.sdkActive = smartTechSettingJson.optBoolean("sdkActive")
                } catch (e: Exception) {
                    SMTLogger.e(TAG, e.message.toString())
                }

                try {

                    sdkInitResponse.smartechSettings?.sessionInterval = smartTechSettingJson.optInt("sessionInterval")
                } catch (e: Exception) {
                    SMTLogger.e(TAG, e.message.toString())
                }

                try {
                    var eventLimit = smartTechSettingJson.optInt("eventLimit")
                    if (eventLimit < 1) {
                        eventLimit = SMTConfigConstants.DEFAULT_EVENT_LIMIT_SIZE
                    }
                    sdkInitResponse.smartechSettings?.eventLimit = eventLimit
                } catch (e: Exception) {
                    SMTLogger.e(TAG, e.message.toString())
                }

                try {
                    sdkInitResponse.smartechSettings?.baseUrl = smartTechSettingJson.optString("baseUrl")
                } catch (e: Exception) {
                    SMTLogger.e(TAG, e.message.toString())
                }

                // Parsing Token Frequency
                try {
                    var tokenInterval = smartTechSettingJson.optInt("tokenInterval")
                    if (tokenInterval < 1) {
                        tokenInterval = SMTConfigConstants.DEFAULT_TOKEN_INTERVAL
                    }
                    sdkInitResponse.smartechSettings?.tokenInterval = tokenInterval
                } catch (e: Exception) {
                    SMTLogger.e(TAG, e.message.toString())
                }

                // Parsing base URL
                try {
                    sdkInitResponse.smartechSettings?.smartechURL = SMTSdkInitializeResponse.SmartTechSettings.SmartTechBaseURL()
                    val objURL = smartTechSettingJson.optJSONObject("baseUrls")
                    objURL?.let {
                        sdkInitResponse.smartechSettings?.smartechURL?.trackAppActUrl = it.optString("trackAppActUrl")
                        sdkInitResponse.smartechSettings?.smartechURL?.pushAmpUrl = it.optString("pushAmpUrl")
                        sdkInitResponse.smartechSettings?.smartechURL?.inAppUrl = it.optString("inAppUrl")
                        sdkInitResponse.smartechSettings?.smartechURL?.inAppListSegUrl = it.optString("listSegUrl")
                        sdkInitResponse.smartechSettings?.smartechURL?.inboxUrl = it.optString("inboxUrl")
                    }

                } catch (e: java.lang.Exception) {
                    SMTLogger.e(TAG, e.message.toString())
                }
                // Parsing debug level
                try {
                    sdkInitResponse.smartechSettings?.debuglevel = SMTSdkInitializeResponse.SmartTechSettings.SmartTechDebugLevel()
                    val objURL = smartTechSettingJson.optJSONObject("debug")
                    objURL?.let {
                        sdkInitResponse.smartechSettings?.debuglevel?.logEnabled = it.optBoolean("logEnabled", false)
                        sdkInitResponse.smartechSettings?.debuglevel?.logLevel = it.optInt("logLevel", 0)
                        sdkInitResponse.smartechSettings?.debuglevel?.guids = it.optJSONArray("guids")
                    }

                } catch (e: java.lang.Exception) {
                    SMTLogger.e(TAG, e.message.toString())
                }


            } catch (e: Exception) {
                SMTLogger.e(TAG, e.message.toString())
            }
            try {
                // InAppRule parsing here
                val newInAppRuleList = jsonObject.optJSONArray("inAppRules")
                if (newInAppRuleList != null && newInAppRuleList.length() > 0) {
                    if (sdkInitResponse.inAppRules == null) {
                        sdkInitResponse.inAppRules = ArrayList()
                    }
                    for (i in 0 until newInAppRuleList.length()) {
                        val smtInAppRule = SMTInAppRuleParser().parseRule(newInAppRuleList.get(i) as JSONObject)
                        if (!sdkInitResponse.isListAndSegmentPresent) {
                            sdkInitResponse.isListAndSegmentPresent = smtInAppRule.isListAndSegmentPresent
                        }
                        sdkInitResponse.inAppRules?.add(smtInAppRule)
//                        sdkInitResponse.inAppRules!!.add(SMTInAppRuleParser().parseRule(newInAppRuleList.get(i) as JSONObject))
                    }
                }
                else {
                    SMTLogger.w(TAG, "InApp rules not found")
                }

            } catch (e: Exception) {
                SMTLogger.e(TAG, e.message.toString())
            }

        } catch (e: Exception) {
            SMTLogger.e(TAG, e.message.toString())
        }


        return sdkInitResponse
    }

}