package com.netcore.android.mediadownloader

import android.content.Context
import android.os.AsyncTask
import com.netcore.android.db.SMTDataBaseService
import com.netcore.android.notification.SMTNotificationParser
import com.netcore.android.notification.models.SMTNotificationData
import java.lang.ref.WeakReference

internal class SMTMediaPathUpdaterAsyncTask(val context: WeakReference<Context>, val notification: SMTNotificationData) : AsyncTask<Unit, Unit, Unit>() {
    override fun doInBackground(vararg p0: Unit?): Unit {
        if (notification.mIsForInbox && notification.mDownloadStatus == SMTMediaDownloadManager.DownloadStatus.COMPLETED.value) {
            // insert the downloaded file path into the database
            val mNotificationData = SMTNotificationParser().updatePayload(notification)
            SMTDataBaseService.getInstance(context).updateInboxMessagePayload(mNotificationData)
        }

    }
}