package com.netcore.android.inbox.views.fragment

import com.netcore.android.notification.models.SMTNotificationData
import com.netcore.android.view.BaseView

/**
 * Contract Interface for InboxFragment and InboxPresenter
 *
 * @author Netcore
 * @version 1.0
 * @since 01-05-2019
 */
internal interface SMTInboxContract {

    interface View : BaseView<Presenter> {

        fun showLoading(active: Boolean)

        fun showError(message: String)

        fun showNotifications(notifications: MutableList<SMTNotificationData>?)
    }

    interface Presenter {

        fun getInboxMessages()

    }

}