package com.netcore.android.inbox.helpers

import android.app.Service
import android.content.Intent
import android.os.IBinder
import com.netcore.android.notification.models.SMTNotificationData


internal class SMTInboxAudioPlayerService : Service() {

    var mSMTMediaPlayer: SMTMediaPlayer? = null

    companion object {
        val AUDIO_ACTION = "AudioAction"
        val AUDIO_PROGRESS_RATE = "AudioProgressRate"
        val AUDIO_MAX_DURATION = "AudioMaxDuration"
        val AUDIO_STOPPED = 0
        val AUDIO_PLAYING = 1
        val AUDIO_ERROR = 2
        val AUDIO_PROGRESS = 3
        val PLAY = 4
        val PAUSE = 5
        val STOP = 6
        val SEEK = 7

    }


    override fun onCreate() {
        super.onCreate()
        if (mSMTMediaPlayer == null) {
            mSMTMediaPlayer = SMTMediaPlayer(this)
        }
    }

    override fun onBind(p0: Intent?): IBinder? {
        return null
    }

    override fun onStartCommand(intent: Intent?, flags: Int, startId: Int): Int {
        when (intent?.getIntExtra("Action", 0)) {
            PLAY -> {
                play(intent.getParcelableExtra("Notification"))
            }
            PAUSE -> {
                pause(intent.getParcelableExtra("Notification"))
            }
            STOP -> {
                stop(intent.getParcelableExtra("Notification"))
            }
            SEEK -> {
                seekAudio(intent.getIntExtra("Progress", 0))
            }
        }
        return START_STICKY
    }
//    override fun onHandleIntent(intent: Intent?) {
//        if (mSMTMediaPlayer == null) {
//            mSMTMediaPlayer = SMTMediaPlayer(this)
//        }
//
//        when (intent?.getIntExtra("Action", 0)) {
//            PLAY -> {
//                play(intent.getParcelableExtra("Notification"))
//            }
//            PAUSE -> {
//                pause(intent.getParcelableExtra("Notification"))
//            }
//            STOP -> {
//                stop(intent.getParcelableExtra("Notification"))
//            }
//            SEEK -> {
//                seekAudio(intent.getIntExtra("Progress", 0))
//            }
//        }
//    }

    // This is the object that receives interactions from clients.
//    private val mBinder = LocalBinder()

//    inner class LocalBinder : Binder() {
//        internal val service: SMTInboxAudioPlayerService
//            get() = this@SMTInboxAudioPlayerService
//    }
//
//    override fun onBind(intent: Intent?): IBinder? {
//        return mBinder
//    }

    fun play(notification: SMTNotificationData) {
        mSMTMediaPlayer?.play(notification)

    }

    fun pause(notification: SMTNotificationData) {
        mSMTMediaPlayer?.pause(notification)

    }

    fun seekAudio(progress: Int) {

        if (mSMTMediaPlayer != null) {
            mSMTMediaPlayer!!.seekAudio(progress)
        }
    }

    fun stop(notification: SMTNotificationData) {
        mSMTMediaPlayer?.stop(notification)
        stopPlayerService()
    }


    private fun stopPlayerService() {

        stopSelf()
    }


    override fun onDestroy() {
        super.onDestroy()
        if (mSMTMediaPlayer != null) {
            mSMTMediaPlayer!!.stopPlayer()
        }
        stopSelf()
//        removeAudioFocus();
    }


}