package com.netcore.android.network.parser

import com.netcore.android.network.SMTHttpRequestClient
import com.netcore.android.network.models.*

/**
 * @author Netcore
 * created on 26/02/2019
 * @Description: A perser class which takes care of parsing all the api's responses
 *
 */
internal class SMTResponseParser {

    internal fun parse(networkResponse: SMTHttpRequestClient.NetworkResponse, apiTypeId: SMTRequest.SMTApiTypeID): SMTResponse? {
        return when (apiTypeId.value) {
            SMTRequest.SMTApiTypeID.SDK_INITIALIZE.value -> parseSdkInitializeResponse(networkResponse)
            SMTRequest.SMTApiTypeID.SDK_INITIALIZE_ON_SESSION_REFRESH.value -> parseSdkInitializeResponse(networkResponse)
//            SMTRequest.SMTApiTypeID.TRACK_ALL_EVENTS.value -> return parseTrackEventResponse()
            SMTRequest.SMTApiTypeID.INBOX_API.value -> return parseInboxResponse(networkResponse)
            SMTRequest.SMTApiTypeID.PUSH_AMPLIFICATION.value -> return parsePushAmpResponse(networkResponse)
            SMTRequest.SMTApiTypeID.LIST_SEGMENT.value -> return parseInAppListSegmentResponse(networkResponse)
            else -> null
        }
    }

    private fun parseInboxResponse(networkResponse: SMTHttpRequestClient.NetworkResponse): SMTInboxResponse? {
        return SMTInboxParser().parse(networkResponse)
    }

    private fun parseSdkInitializeResponse(networkResponse: SMTHttpRequestClient.NetworkResponse): SMTSdkInitializeResponse {
        return SMTSdkInitParser().parse(networkResponse)
    }

    private fun parsePushAmpResponse(networkResponse: SMTHttpRequestClient.NetworkResponse): SMTPushAmpResponse {

        return SMTPushAmpParser().parse(networkResponse)
    }

    private fun parseInAppListSegmentResponse(networkResponse: SMTHttpRequestClient.NetworkResponse): SMTInAppResponse {
        return SMTInAppParser().parse(networkResponse)
    }
}