package com.netcore.android.notification.models

import android.os.Parcel
import android.os.Parcelable

/**
 * Copyright © 2019 Netcore. All rights reserved.
 *
 * Data class holds Notification Action Button Data
 *
 * @author Netcore
 * @version 1.0
 * @since 26-02-2019
 */
data class SMTActionButtonData(var actionName: String?, var actionDeeplink: String?) : Parcelable {
    constructor(parcel: Parcel) : this(
            parcel.readString(),
            parcel.readString())

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeString(actionName)
        parcel.writeString(actionDeeplink)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<SMTActionButtonData> {
        override fun createFromParcel(parcel: Parcel): SMTActionButtonData {
            return SMTActionButtonData(parcel)
        }

        override fun newArray(size: Int): Array<SMTActionButtonData?> {
            return arrayOfNulls(size)
        }
    }
}