package com.netcore.android.notification.models

import android.os.Parcel
import android.os.Parcelable

/**
 * Copyright © 2019 Netcore. All rights reserved.
 *
 * Data class holds Notification Carousel Item Data
 *
 * @author Netcore
 * @version 1.0
 * @since 26-02-2019
 */
data class SMTCarouselItemData(var id: Int, // Position of the item
                               var imgTitle: String?, // Title of image
                               var imgMsg: String?, // Message of image
                               var imgUrl: String?, // Remote path of Image
                               var imgDeeplink: String?, // Image deeplink path
                               var mMediaLocalPath: String? // Image deeplink path
) : Parcelable {

    //internal Controlling variable
    var mDownloadStatus: Int = 0

    constructor(parcel: Parcel) : this(
            parcel.readInt(),
            parcel.readString(),
            parcel.readString(),
            parcel.readString(),
            parcel.readString(),
            parcel.readString()) {
        mDownloadStatus = parcel.readInt()
    }

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeInt(id)
        parcel.writeString(imgTitle)
        parcel.writeString(imgMsg)
        parcel.writeString(imgUrl)
        parcel.writeString(imgDeeplink)
        parcel.writeString(mMediaLocalPath)
        parcel.writeInt(mDownloadStatus)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<SMTCarouselItemData> {
        override fun createFromParcel(parcel: Parcel): SMTCarouselItemData {
            return SMTCarouselItemData(parcel)
        }

        override fun newArray(size: Int): Array<SMTCarouselItemData?> {
            return arrayOfNulls(size)
        }
    }

}
